<?php
namespace App\Controllers\Admin;
use App\Models\CommonWebServiceModel;
use CodeIgniter\Controller;
use App\Models\StaffModel;
use App\Models\DocumentModel;
class Staff extends BaseController
{
    protected $staff_model;
    public function __construct() {
        $this->staff_model = new StaffModel();
        $this->document_model = new DocumentModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        // checkAndCreatePath(THUMBNAIL_DOCUMENT_IMAGE_PATH);
        // checkAndCreatePath(THUMBNAIL_STAFF_IMAGE_PATH);
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
		$data['title'] = 'Staff';
		$dataFilters['filters'] = array(
			array(
				"type" => "staff_type",
				"id" => "staff_type",
				"name" => "staff_type",
				"title" => "Staff.staff_type",
			),
			array(
				"type" => "gender",
				"id" => "gender",
				"name" => "gender",
				"title" => "Staff.gender",
			),
			array(
				"type" => "daterange",
				"id" => "filter_date_of_birth",
				"name" => "filter_date_of_birth",
				"title" => "Staff.date_of_birth",
			),
			array(
				"type" => "daterange",
				"id" => "filter_created_at",
				"name" => "filter_created_at",
				"title" => "CommonMessage.common_created_at",
			),
			array(
				"type" => "daterange",
				"id" => "filter_updated_at",
				"name" => "filter_updated_at",
				"title" => "CommonMessage.common_updated_at",
			),
		);
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
		$this->dt_ci_template->load("Admin","Staff/StaffView",$data);
	}

	public function manage($staffId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
        );

        if ($staffId != '') {
			$filterData = array(
				"staff_id" => $staffId
			);
			$data['staff_data'] = $this->staff_model->getStaffData($filterData);

			if (empty($data['staff_data'])) {
                return redirect()->to('Admin/Staff');
            }

			$data['image_data'] = $this->staff_model->getStaffImageData(array(
               "staff_id" => $staffId,
               "is_multiple" => 1
           ));

		   $staffGuardData = $this->staff_model->getStaffGuardData(array(
				'staff_id' => $staffId,
				'is_multiple' => 1
			));
			$data['staff_guard_data'] = $staffGuardData;

			$documentData = $this->document_model->getDocumentData(array(
				'document_for' => 'staff',
				'is_active' => 1,
				'is_multiple' => 1,

			));
			if(!empty($documentData)){
				foreach ($documentData as $key => $displayData) {
					$document = $this->staff_model->getDocument(array(
						'document_id' => $displayData['document_id'],
					));
					if(!empty($document)){
						$documentData[$key]['module_document_id'] = $document['module_document_id'];
						$documentData[$key]['input_box'] = $document['input_box'];
						$documentData[$key]['document_expiry_date'] = $document['document_expiry_date'];
					}
					$documentImageData = $this->staff_model->getDocumentImage(array(
						"document_id" => isset($displayData['document_id']) ? $displayData['document_id'] : "",
						'module_id' => $staffId,
						'module' => 'staff',
						"is_multiple" => 1,
					));
					$documentData[$key]['module_image_data'] = $documentImageData;
				}
			}
			$data['document_data'] = $documentData;
		}
		else{
			$documentType = $this->document_model->getDocumentData(array(
				'document_for' => 'staff',
				'is_active' => 1,
				'is_multiple' => 1,

			));
			$iKey = 0;
			if(!empty($documentType)){
				foreach($documentType as $imageType){
					$documentTypeData[$iKey] = $imageType;
					$iKey = $iKey + 1;
				}
			}
			if(!empty($documentTypeData)){
				$data['document_data'] = $documentTypeData;
			}
		}
		if ($staffId != '') {
			$data['title'] = 'Edit Staff';
		} else {
			$data['title'] = 'Add Staff';
		}

		$data['document_table'] = view('Admin/Staff/DocumentView', isset($data) ? $data : array());
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
		if ((isset($data['staff_data']['society_id']) && $data['staff_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Staff');
        }
		$this->dt_ci_template->load("Admin","Staff/StaffManageView",$data);
	}

    public function getStaffListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}

		$createdAt = $this->request->getVar("filter_created_at");
		$dateOfBirth = $this->request->getVar("filter_date_of_birth");
		$staffType = $this->request->getVar("staff_type");
		$gender = $this->request->getVar("gender");
		$updatedAt = $this->request->getVar("filter_updated_at");

        $this->datatables->table("tbl_staff as ts");
		$this->datatables->select("ts.staff_id, ts.staff_name,tsoc.society_name,ts.father_name,ts.aadhar_card_no,ts.voter_card_no,ts.contact_no,ts.date_of_birth,ts.gender,ts.work,ts.staff_type,ts.present_address,ts.permanent_address,ts.reference");
		$this->datatables->select("ts.is_active,concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,ts.updated_at");
		$this->datatables->join("tbl_society as tsoc","tsoc.society_id = ts.society_id","left");
		$this->datatables->join("tbl_users as tupdate","tupdate.id = ts.updated_by","left");

		if (isset($staffType)) {
			if (is_array($staffType)) {
				$this->datatables->whereIn("ts.staff_type", $staffType);
			} else {
				$this->datatables->where("ts.staff_type", $staffType);
			}
		}

		if (isset($gender) && !empty($gender)) {
			if (is_array($gender)) {
				$this->datatables->whereIn("ts.gender", $gender);
			} else {
				$this->datatables->where("ts.gender", $gender);
			}
		}

		if($dateOfBirth != ''){
			list($fromDate,$toDate) = explode(" - ",$dateOfBirth);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(ts.date_of_birth,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(ts.date_of_birth,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(ts.date_of_birth,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

		if($createdAt != ''){
			list($fromDate,$toDate) = explode(" - ",$createdAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(ts.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(ts.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(ts.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

		if($updatedAt != ''){
			list($fromDate,$toDate) = explode(" - ",$updatedAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(ts.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(ts.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(ts.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

		$this->datatables->groupBy("ts.staff_id");
		accessFilter($this->datatables, array("society" => "ts.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"staff_id" => isset($data[$key]['staff_id']) ? $data[$key]['staff_id'] : ""
				);
				$data[$key]['action_button'] = staffActionButton($actionButtonFilter);
				$data[$key]['date_of_birth'] = siteDateFormat($displayData['date_of_birth']);
				$data[$key]['staff_type'] = underscoreToUcWord($displayData['staff_type']);
				$data[$key]['gender'] = underscoreToUcWord($displayData['gender']);
				$data[$key]['updated_at'] = isValidDate($data[$key]['updated_at']) ? siteDateFormat($data[$key]['updated_at'],true) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $staffId = $this->request->getVar('staff_id');
        $status = $this->request->getVar('status');
        $return = $this->staff_model->statusChange($staffId,$status,'staff_id','tbl_staff');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Staff.staff'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Staff.staff'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
    //    printArray($_POST,1);
		$this->db->transBegin();
		$validation = \Config\Services::validation();
		$staffId = $this->request->getVar('staff_id');
		$staffName = $this->request->getVar('staff_name');
		$fatherName = $this->request->getVar('father_name');
		$dateOfBirth = $this->request->getVar('date_of_birth');
		$gender = $this->request->getVar('gender');
		$work = $this->request->getVar('work');
		$contactNo = $this->request->getVar('contact_no');
		$presentAddress = $this->request->getVar('present_address');
		$permanentAddress = $this->request->getVar('permanent_address');
		$reference = $this->request->getVar('reference');
		$staffType = $this->request->getVar('staff_type');
		$isActive = $this->request->getVar('is_active');
		$isOutsourced = $this->request->getVar('is_outsourced');
		$isLogin = $this->request->getVar('is_login');
		$vendorId = $this->request->getVar('vendor_id');
		
		$validation->setRule('staff_name', lang('Staff.staff_name'), 'required');
		$validation->setRule('father_name', lang('Staff.father_name'), 'required');
		$validation->setRule('date_of_birth', lang('Staff.date_of_birth'), 'required');
		$validation->setRule('gender', lang('Staff.gender'), 'required');
		$validation->setRule('work', lang('Staff.work'), 'required');
		$validation->setRule('contact_no', lang('Staff.contact_no'), 'required');
		$validation->setRule('present_address', lang('Staff.present_address'), 'required');
		$validation->setRule('permanent_address', lang('Staff.permanent_address'), 'required');
		$validation->setRule('staff_type', lang('Staff.staff_type'), 'required');

		if(isset($isOutsourced)){
			$validation->setRule('vendor_id', lang('Staff.vendor'), 'required');
		}

		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

    	    // $userDataFilter = $this->common_web_service_model->getUserData(array(
            // 	'phone' => $mobileNoFilterArray,
            // 	'society_id' => $this->session->get('society_id'),
            // 	'user_type_not' => 'staff',
            // 	'user_type_id_not' => $staffId,
        	// ));
            // if(!empty($userDataFilter)){
            //     $response['success'] = false;
            //     $response['msg'] = 'Duplicate Mobile No Exist';
            //     echo json_encode($response);
            //     exit;
            // }

			$moduleDocumentResult = array();
			if (isset($_FILES["document_image"])) {
				$moduleDocumentResult  = $this->dt_ci_file_upload->MultipleFileUpload('document_image', MAX_IMAGE_SIZE_LIMIT, DOCUMENT_IMAGE_PATH, true, true, array('jpeg', 'png', 'jpg', 'JPG'));

				// printArray($moduleDocumentResult,1);
				if ($moduleDocumentResult['success'] == false) {
					$response['success'] = false;
					$response['msg'] = strip_tags($moduleDocumentResult['message']);
					echo json_encode($response);
					die();
				}
				else{
                    unset($moduleDocumentResult['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($moduleDocumentResult, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                }
			}

			$imageResultArray = array();
			if(!empty($moduleDocumentResult)){
				foreach ($moduleDocumentResult as $keyImage => $imageResultData){
					list($fromKey) = explode("_",$keyImage);
					$imageResultArray[$fromKey][] = $imageResultData;
				}
			}

			$staffImage = array();
			if (isset($_FILES["staff_image"])) {
				$staffImagePath = STAFF_IMAGE_PATH;
				$staffImage = $this->dt_ci_file_upload->UploadMultipleFile('staff_image', MAX_IMAGE_SIZE_LIMIT, $staffImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
				if ($staffImage['success'] == false) {
					$response['success'] = false;
					$response['msg'] = strip_tags($staffImage['message']);
					echo json_encode($response);
					die();
				}
				else{
                    unset($staffImage['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($staffImage, STAFF_IMAGE_PATH, THUMBNAIL_STAFF_IMAGE_PATH);
                }
			}

			$staffUpdateArray = array();
			$staffArray = array(
				'staff_id' => $staffId,
				'staff_name' => $staffName,
				'father_name' => $fatherName,
				'date_of_birth' => DMYToYMD($dateOfBirth),
				'gender' => $gender,
				'work' => $work,
				'contact_no' => $contactNo,
				'present_address' => $presentAddress,
				'permanent_address' => $permanentAddress,
				'reference' => $reference,
				'is_outsourced' => isset($isOutsourced) ? 1 : 0,
				'society_id' => $this->session->get('society_id'),
				'staff_type' => $staffType,
				'is_active' => isset($isActive) ? 1 : 0,
				'is_login' => isset($isLogin) ? 1 : 0,
			);

			if(isset($isOutsourced)){
				$staffArray['vendor_id'] = $vendorId;
			} else {
				$staffArray['vendor_id'] = 0;
			}

			if(!empty($staffId)){
                $staffUpdateData = $this->staff_model->getStaffData(array(
                    'staff_id' => $staffId,
                ));
                $staffUpdateArray = compareArray($staffArray,$staffUpdateData);
            }

			$staffData = $this->staff_model->insertUpdateRecord($staffArray, 'staff_id', 'tbl_staff', 1,'',array(),array(),$staffUpdateArray);
			$lastStaffId = $staffData['lastInsertedId'];

			if($lastStaffId != ''){
                if(isset($staffImage) && count($staffImage) > 0){
                    $batchArray = array();
                    unset($staffImage['success']);
                    foreach ($staffImage as $key => $imageData) {
                        $dataArray = array(
                            'staff_image_id' =>   '',
                            'staff_id' => $lastStaffId,
                            'staff_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                        );
                        array_push($batchArray, $dataArray);
                    }

                    $staffImageExtraDataArray = array();
                    $staffImageExtraDataArray['module_id'] = $lastStaffId;
                    $staffImageExtraDataArray['module'] = 'Staff Image';
                    $staffImageExtraDataArray['type'] = 'Staff';
                    $staffImageExtraDataArray['old_data'] = array();
                    $staffImageExtraDataArray['user_id'] = $this->data['userId'];
                    $staffImageExtraDataArray['society_id'] = $this->session->get('society_id');

					// printArray($batchArray,1);
                    $this->staff_model->batchInsert($batchArray, 'tbl_staff_image',$staffImageExtraDataArray);
                }
			}

            $moduleDocumentUpdateArray = array();
            $documentIdArray = $this->request->getVar('document_id');
			$moduleDocumentIdArray = $this->request->getVar('module_document_id');
			$inputBoxArray = $this->request->getVar('input_box');
			$documentExpiryDateArray = $this->request->getVar('document_expiry_date');
			if (!empty($moduleDocumentIdArray)) {
				foreach ($moduleDocumentIdArray as $fkey => $moduleDocumentId) {
					$moduleDocumentsId = array_key_exists($fkey, $moduleDocumentIdArray) ? $moduleDocumentIdArray[$fkey] : 0;
					$documentId = array_key_exists($fkey, $documentIdArray) ? $documentIdArray[$fkey] : 0;
					$inputBox = array_key_exists($fkey, $inputBoxArray) ? $inputBoxArray[$fkey] : 0;
					$documentExpiryDate = (isset($documentExpiryDateArray) && array_key_exists($fkey, $documentExpiryDateArray)) ? $documentExpiryDateArray[$fkey] : 0;
					$moduleDocumentImage = array_key_exists($fkey, $imageResultArray) ? $imageResultArray[$fkey] : [];
					$moduleDocumentInsertArray = array(
						'module_document_id' => $moduleDocumentsId,
						'module_id' => $lastStaffId,
						'module' => 'staff',
						'document_id' => $documentId,
						'input_box' => $inputBox,
						'document_expiry_date' => DMYToYMD($documentExpiryDate),
						'created_by' => $this->data['userId'],
						'updated_by' => $this->data['userId'],
						'created_at' => date("Y-m-d H:i:s"),
						'updated_at' => date("Y-m-d H:i:s"),
					);
					if(!empty($moduleDocumentId)){
		                $documentUpdateData = $this->staff_model->getDocument(array(
		                    'module_document_id' => $moduleDocumentId,
		                ));
		                $moduleDocumentUpdateArray = compareArray($moduleDocumentInsertArray,$documentUpdateData);
                        $moduleDocumentUpdateArray['type'] = 'Staff';
                        $moduleDocumentUpdateArray['type_id']  = $lastStaffId;
		            }
					$moduleDocumentData = $this->staff_model->insertUpdate($moduleDocumentInsertArray, 'module_document_id', 'tbl_module_document', 1,$moduleDocumentUpdateArray);
					$lastModuleDocumentId = $moduleDocumentData['lastInsertedId'];


					// printArray($moduleDocumentImage);
					$imageDataArray = array();
					if(!empty($moduleDocumentImage)){
						unset($imageResultArray['success']);
						foreach ($moduleDocumentImage as  $mdImageElement){
							$imageDataArray[] = array(
								'module_document_image_id' =>   '',
								'module_id' => $lastStaffId,
								'module' => 'staff',
								'document_id' => $documentId,
								'module_document_id' => $lastModuleDocumentId,
								'document_image' => isset($mdImageElement['file_name']) ? $mdImageElement['file_name'] : "",
								'created_at' => date('Y-m-d H:i:s'),
								'updated_at' => date('Y-m-d H:i:s'),
								'created_by' => $this->data['userId'],
								'updated_by' => $this->data['userId']
							);
						}
                        $moduleImageExtraDataArray = array();
                        $moduleImageExtraDataArray['module_id'] = $lastStaffId;
                        $moduleImageExtraDataArray['module'] = 'Staff Document Image';
                        $moduleImageExtraDataArray['type'] = 'Staff';
                        $moduleImageExtraDataArray['old_data'] = array();
                        $moduleImageExtraDataArray['user_id'] = $this->data['userId'];
                        $moduleImageExtraDataArray['society_id'] = $this->session->get('society_id');
						$this->staff_model->batchInsert($imageDataArray, 'tbl_module_document_image',$moduleImageExtraDataArray);
					}

				}
				
			}

			$staffGuardData = array();
            if(!empty($staffId)) {
                $staffGuardData = $this->staff_model->getStaffGuardData(array(
                    'staff_id' => $staffId,
                    'is_multiple' => 1
                ));
            }

			$gateIdArray = $this->request->getVar('gate_id[]');
            if(isset($staffId) && $staffId != ''){
                $this->staff_model->deleteGuardRecord($staffId);
            }
            if(isset($gateIdArray)&& $gateIdArray != ''){
                $gateForArray = array();
                foreach($gateIdArray as $gateId){
                    $gateForArray[] = array(
                        'staff_guard_id' => '',
                        'staff_id' => $lastStaffId,
                        'gate_id' => $gateId,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId']
                    );
                }
                $staffSocietyExtraDataArray = array();
                $staffSocietyExtraDataArray['module_id'] = $lastStaffId;
                $staffSocietyExtraDataArray['module'] = 'Staff Guard';
                $staffSocietyExtraDataArray['type'] = 'Staff';
                $staffSocietyExtraDataArray['old_data'] = $staffGuardData;
                $staffSocietyExtraDataArray['user_id'] = $this->data['userId'];
                $staffSocietyExtraDataArray['society_id'] = $this->session->get('society_id');

                if(!empty($gateForArray)){
                    $this->staff_model->batchInsert($gateForArray,'tbl_staff_guard',$staffSocietyExtraDataArray);
                }
            }


            // if(isset($staffId) && $staffId == ''){
                if(isset($isLogin)  && $staffType == 'guard'){
                    $userDataFilter = $this->common_web_service_model->getUserData(array(
                        'phone' => $contactNo
                    ));

                    $groupData = $this->common_web_service_model->getGroupsData(array(
                        'name' => GUARD_GROUP,
                        'society_id' => $this->session->get('society_id'),
                    ));

                    $groupId = isset($groupData['id']) ? $groupData['id'] : '';

                    $permissions = isset($groupData['permissions']) ? $groupData['permissions'] :'';
                    $permissionArray = unserialize($permissions);
                    $permissionLabel = array();
                    $controllers_methods = $this->dt_ci_acl->getPermissableMethods();
                    foreach ($controllers_methods as $controller_name => $methods_arr) {
                        foreach ($methods_arr as $method) {
                            $methodDisplay = "";
                            $methodActual = "";
                            if (is_array($method)) {
                                reset($method);
                                $methodActual = key($method);
                                $methodDisplay = $method[$methodActual];

                            } else {
                                $methodDisplay = $method;
                                $methodActual = $method;
                            }
                            $inputName = $controller_name . "|" . $methodActual;
                            $checked = "";
                            $permissionLabel[] = $inputName . "|dt|" . $controller_name . "|dt|" . $methodDisplay;
                        }
                    }

                    if(empty($userDataFilter)){
                        $userArray = array(
                            'id' => '',
                            'username' => '',
                            'email' => '',
                            'first_name' => $staffName,
                            'phone' => $contactNo,
                            'user_type_id' => $lastStaffId,
                            'permissions' => $permissions,
                            'user_type' => 'gate_keeper',
                            'active' => 1
                        );

                        $userData = $this->staff_model->insertUpdateRecord($userArray, 'id', 'tbl_users', 1,'',array(),array(),array());
                        $lastUserId = $userData['lastInsertedId'];

                        $userGroupArray = array(
                            'id' => '',
                            'user_id' => $lastUserId,
                            'group_id' => $groupId,
                        );

                        $userGroupData = $this->staff_model->insertUpdate($userGroupArray, 'id', 'tbl_users_groups',1);

                        $userSocietyArray = array(
                            'user_society_id' => '',
                            'user_id' => $lastUserId,
                            'society_id' => $this->session->get('society_id'),
                            'group_id' => $groupId,
                            'permissions'=> $permissions,
                            'type' => 'gate_keeper',
                            'type_id' => $lastStaffId,
                        );

                        $userSocietyData = $this->staff_model->insertUpdate($userSocietyArray, 'user_society_id', 'tbl_user_society',1);
                        $lastUserSocietyId = $userSocietyData['lastInsertedId'];


                        if(is_array($permissionLabel) && count($permissionLabel) > 0){
                            $labelArray = array();
                            foreach ($permissionLabel as $labelData){
                                list($permissionValue,$controller,$label) = explode("|dt|",$labelData);

                                if(in_array($permissionValue,$permissionArray)) {
                                    $labelArray[] = array(
                                        'controller_name' => $controller,
                                        'permission_name' => $permissionValue,
                                        'permission_label' => $label,
                                        'user_id' =>    $lastUserId,
                                        'group_id' =>    $groupId,
                                        'user_society_id' =>    $lastUserSocietyId,
                                        'created_at' 		=> date('Y-m-d H:i:s'),
                                        'created_by' 		=> $this->session->get('user_id'),
                                        'updated_at' 		=> date('Y-m-d H:i:s'),
                                        'updated_by' 		=> $this->session->get('user_id'),
                                    );
                                }
                            }
                            $this->staff_model->batchInsert($labelArray,"tbl_user_permission");
                        }

                    }

                    if(!empty($userDataFilter)){

                    	$userGroupDataArray = $this->common_web_service_model->getUserGroupData(array(
                    		'user_id' => $userDataFilter['id'],
                    		'group_id' => $groupId,
                    	));
                    	if(empty($userGroupDataArray)){
	                        $userGroupArray = array(
	                            'id' => '',
	                            'user_id' => isset($userDataFilter['id']) ? $userDataFilter['id']: 0 ,
	                            'group_id' => $groupId,
	                        );

	                        $userGroupData = $this->staff_model->insertUpdate($userGroupArray, 'id', 'tbl_users_groups',1);
	                    }

	                    $userSocietyDataArray = $this->common_web_service_model->getUserSocietyData(array(
                    		'user_id' => $userDataFilter['id'],
                    		'group_id' => $groupId,
                    		'society_id' => $this->session->get('society_id'),
                    		'type' => 'gate_keeper',
                    		'type_id' => $lastStaffId,
                    	));

	                    if(empty($userSocietyDataArray)){
	                        $userSocietyArray = array(
	                            'user_society_id' => '',
	                            'user_id' => isset($userDataFilter['id']) ? $userDataFilter['id']: 0 ,
	                            'society_id' => $this->session->get('society_id'),
	                            'group_id' => $groupId,
	                            'permissions'=> $permissions,
	                            'type' => 'gate_keeper',
	                            'type_id' => $lastStaffId,
	                        );

	                        $userSocietyData = $this->staff_model->insertUpdate($userSocietyArray, 'user_society_id', 'tbl_user_society',1);
	                        $lastUserSocietyId = $userSocietyData['lastInsertedId'];
	                    }
	                    else{
	                    	$lastUserSocietyId = $userSocietyDataArray['user_society_id'];
	                    }


                        if(is_array($permissionLabel) && count($permissionLabel) > 0){
                            $labelArray = array();
                            foreach ($permissionLabel as $labelData){
                                list($permissionValue,$controller,$label) = explode("|dt|",$labelData);

                                if(in_array($permissionValue,$permissionArray)) {
                                    $labelArray[] = array(
                                        'controller_name' => $controller,
                                        'permission_name' => $permissionValue,
                                        'permission_label' => $label,
                                        'user_id' =>    isset($userDataFilter['id']) ? $userDataFilter['id']: 0 ,
                                        'group_id' =>    $groupId,
                                        'user_society_id' =>    $lastUserSocietyId,
                                        'created_at' 		=> date('Y-m-d H:i:s'),
                                        'created_by' 		=> $this->session->get('user_id'),
                                        'updated_at' 		=> date('Y-m-d H:i:s'),
                                        'updated_by' 		=> $this->session->get('user_id'),
                                    );
                                }
                            }
                            $this->staff_model->batchInsert($labelArray,"tbl_user_permission");
                        }
                    }
                }
            // }


			if (isset($staffId) && $staffId != '') {
				if ($staffData['success']) {
					$this->db->transCommit();
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Staff.staff"));
				} else {
					$this->db->transRollback();
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Staff.staff"));
				}
			} else {
				if ($staffData['success']) {
					$this->db->transCommit();
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Staff.staff"));
				} else {
					$this->db->transRollback();
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Staff.staff"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transBegin();
        $staffId = $this->request->getVar('staff_id');
         if( isReferenceInTable( 'staff_id','tbl_men_power_attendance', $staffId) ||
     		isReferenceInTable( 'staff_id','tbl_complain', $staffId) || 
     		isReferenceInTable( 'staff_id','tbl_complain_history', $staffId)){
			 if(!empty($staffId)){
			 	foreach($staffId as $documentElement){
			 		$deleteDataArray['module'] = 'Staff';
			 		$deleteDataArray['activity'] = "Tried to Delete Staff ";
			 		$deleteDataArray['module_id'] = $documentElement;
			 		logActivity('Tried to delete Staff [StaffID: ' . $documentElement . ']',$this->data['userId'],'Staff',$documentElement,json_encode($deleteDataArray),'','Staff',$documentElement);
			 	}
			 }
             $response['success'] = false;
             $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
             echo json_encode($response);
             exit;
         }

        $moduleDocumentImageData = $this->staff_model->getDocumentImage(array(
			"module_id" => $staffId,
			"module" => 'staff',
			"is_multiple" =>1,
		));
		if(is_array($moduleDocumentImageData) && !empty($moduleDocumentImageData)){
			foreach ($moduleDocumentImageData as $image){
				$FileUrl = '';
				if(isset($image['document_image']) && $image['document_image'] != '') {
					$FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
				}
				if (file_exists($FileUrl)) {
					unlink($FileUrl);
				}

				$thumbnailFileUrl = '';
				if(isset($image['document_image']) && $image['document_image'] != '') {
					$thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
				}
				if (file_exists($thumbnailFileUrl)) {
					unlink($thumbnailFileUrl);
				}
			}
		}

		$staffImageData = $this->staff_model->getStaffImageData(array(
			"staff_id" => $staffId,
			"is_multiple" => 1
		));
		if(is_array($staffImageData) && !empty($staffImageData)){
			foreach ($staffImageData as $image){
				$FileUrl = '';
				if(isset($image['staff_image']) && $image['staff_image'] != '') {
					$FileUrl = STAFF_IMAGE_PATH . $image['staff_image'];
				}
				if (file_exists($FileUrl)) {
					unlink($FileUrl);
				}

				$thumbnailFileUrl = '';
				if(isset($image['staff_image']) && $image['staff_image'] != '') {
					$thumbnailFileUrl = THUMBNAIL_STAFF_IMAGE_PATH . $image['staff_image'];
				}
				if (file_exists($thumbnailFileUrl)) {
					unlink($thumbnailFileUrl);
				}
			}
		}
        $staffData = $this->staff_model->deleteRecord($staffId);
        $staffGuardData = $this->staff_model->deleteGuardRecord($staffId);
        if ($staffData) {
            $this->db->transCommit();
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Staff.staff"));
        } else {
            $this->db->transRollback();
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Staff.staff"));
        }
        echo json_encode($response);
        exit;
    }

    public function deleteStaffImage()
    {
        $staffImageId = $this->request->getVar('staff_image_id');
        $staffId = $this->request->getVar('staff_id');
        $imageData = $this->staff_model->getStaffImageData(array(
            "staff_image_id" => $staffImageId,
            "is_multiple" => 1
        ));
        if(is_array($imageData) && !empty($imageData)){
            foreach ($imageData as $image){
                $FileUrl = '';
                if(isset($image['staff_image']) && $image['staff_image'] != '') {
                    $FileUrl = STAFF_IMAGE_PATH . $image['staff_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                } 

                $thumbnailFileUrl = '';
				if(isset($image['staff_image']) && $image['staff_image'] != '') {
					$thumbnailFileUrl = THUMBNAIL_STAFF_IMAGE_PATH . $image['staff_image'];
				}
				if (file_exists($thumbnailFileUrl)) {
					unlink($thumbnailFileUrl);
				}
            }
        }
        //delete setting location
        $imageData = $this->staff_model->deleteStaffImage($staffImageId);      
        if ($imageData) {
			$ids = is_array($staffImageId) ? implode(',',$staffImageId) : $staffImageId;
			$deleteDataArray['module'] = 'Staff Image';
			$deleteDataArray['activity'] = "Staff Image Deleted";
			$deleteDataArray['module_id'] = $staffImageId;
			logActivity('Staff Image Deleted [StaffImageID: ' . $ids . ']',$this->data['userId'],'Staff Image',$ids,json_encode($deleteDataArray),'','Staff',$staffId);
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Staff.staff_image'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Staff.staff_image'));
        }
        echo json_encode($response);
        exit();
    }

    public function deleteModuleImage()
    {
        $moduleDocumentImageId = $this->request->getVar('module_document_image_id');
        $module = $this->request->getVar('module');
        $moduleId = $this->request->getVar('module_id');
        $imageData = $this->staff_model->getDocumentImage(array(
            "module_document_image_id" => $moduleDocumentImageId,
            "is_multiple" => 1
        ));
        if(is_array($imageData) && !empty($imageData)){
            foreach ($imageData as $image){
                $FileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }

                $thumbnailFileUrl = '';
				if(isset($image['document_image']) && $image['document_image'] != '') {
					$thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
				}
				if (file_exists($thumbnailFileUrl)) {
					unlink($thumbnailFileUrl);
				} 
            }
        }
        //delete setting location
        $imageData = $this->staff_model->deleteModuleDocumentImage($moduleDocumentImageId,$module,$moduleId);
        if ($imageData) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Staff.document_image'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Staff.document_image'));
        }
        echo json_encode($response);
        exit();
    }

    public function getStaffDd(){
    	$filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $staffId = $this->request->getVar('staff_id');
        $societyId = $this->request->getVar('society_id');
        $filterData = array(
            'staff_id' => $staffId,
            'society_id' => $this->session->get('society_id'),
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'is_active' => 1,
            'limit' => DATA_LIMIT
        );

        echo $this->staff_model->getStaff($filterData);
    }

    public function view($id = null)
	{
		$staffId = $this->request->getVar("view_id");
		if($staffId == "" && $staffId == null){
            return redirect()->to('Admin/Staff');
		}
		else {
			$id = $staffId;
			$filterData = array(
				"staff_id" => $staffId
			);
			$data['staff_data'] = $this->staff_model->getStaffData($filterData);
			$data['image_data'] = $this->staff_model->getStaffImageData(array(
               "staff_id" => $staffId,
               "is_multiple" => 1
           ));

			$documentData = $this->document_model->getDocumentData(array(
				'document_for' => 'staff',
				'is_active' => 1,
				'is_multiple' => 1,

			));
			if(!empty($documentData)){
				foreach ($documentData as $key => $displayData) {

					$documentImageData = $this->staff_model->getDocumentImage(array(
						"document_id" => isset($displayData['document_id']) ? $displayData['document_id'] : "",
						'module_id' => $staffId,
						'module' => 'staff',
						"is_multiple" => 1,
					));
					$documentData[$key]['module_image_data'] = $documentImageData;
				}
			}
			$data['document_data'] = $documentData;
			$staffView = view("Admin/Staff/StaffModelView", $data);
			$response['view_title'] = "Staff Details";
			$response['view_detail'] = $staffView;
			$response['success'] = true;
			echo json_encode($response);
		}
	}

	public function excelExportStaff()
	{
		$fileName ='staff-' . DATETIMEFORMAT;
		$sheetName = 'Staff-' . DATEFORMAT;
		$excelHeaderName = 'Staff';
		$tableData = $this->getStaffListing(true, $_GET);
		$dataRows = array();
		$dataRows[] = array(
			lang('Staff.staff_type'),
			lang('Staff.staff_name'),
			lang('Staff.father_name'),
			lang('Staff.date_of_birth'),
			lang('Staff.gender'),
			lang('Staff.work'),
			lang('Staff.contact_no'),
			lang('Staff.present_address'),
			lang('Staff.permanent_address'),
			lang('Staff.reference'),
			lang('CommonMessage.common_updated_by'),
			lang('common_updated_at')
		);
		foreach ($tableData as $row) {
			$dataRows[] = array(
				$row["staff_type"],
				$row["staff_name"],
				$row["father_name"],
				$row["date_of_birth"],
				$row["gender"],
				$row["work"],
				$row["contact_no"],
				$row["present_address"],
				$row["permanent_address"],
				$row["reference"],
				$row["updated_by"],
				$row["updated_at"]
			);
		}
		$subTotalCellValueArray = [];
		$toColumn = 'L';
		$excelFilterData = array(
			'file_name' => $fileName,
			'sheet_name' => $sheetName,
			'excel_header_name' => $excelHeaderName,
			'data_row' => $dataRows,
			'sub_total_cell_value_array' => $subTotalCellValueArray,
			'to_column' => $toColumn,
			'skip_header' => false,
			'ignore_currency_symbols_sub_total_cell_value_array' => array(),
			'row_cell_currency_format' => array()
		);
		//excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
		excelExport($excelFilterData);
	}

	public function pdf($id = null, $view = null, $save_bufffer = null,$zipPdf = 0)
	{
		if(empty($id)){
			$response['success'] = false;
			$response['msg'] = lang('Staff.staff_data_required');
			echo json_encode($response);
			exit;
		}
		$filterData = array(
			"staff_id" => $id,
			// 'is_multiple' => 1
		);
		$staffData = $this->staff_model->getStaffData($filterData);
		$staffImageData = $this->staff_model->getStaffImageData(array(
			"staff_id" => $staffData['staff_id'],
			"is_multiple" => 1
		));
		// printArray($staffImageData,1);
		if(!empty($staffData)) {
				$data['staff_data'] = $staffData;
				$data['staff_image_data'] = $staffImageData;
				$data['name'] = lang("Staff.staff_pdf") . "_" . str_replace('/', '_', $data['staff_data']['staff_name']) . ".pdf";
				$printHeader = '';
				$printFooter = '';
				$html = view('Admin/Staff/Pdf/StaffPdfView', $data);

				generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
		}
	}

}
