<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\SinkingFundModel;
class SinkingFund extends BaseController
{
    protected $sinking_fund_model;
    public function __construct() {
        $this->sinking_fund_model = new SinkingFundModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/flatpickr/flatpickr.js",
        );
        $data['title'] = 'Sinking Fund';
        $data['v_investment_modal'] = view('Admin/SinkingFund/InvestmentModalView', array());
        $data['v_withdrawn_modal'] = view('Admin/SinkingFund/WithdrawnModalView', array());
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        return $this->dt_ci_template->load("Admin","SinkingFund/SinkingFundView",$data);
    }
    public function manage($sinkingFundId = '')
    {

        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/additional_methods.min.js"
        );

        if ($sinkingFundId != '') {
            $filterData = array(
                "sinking_fund_id" => $sinkingFundId
            );
            $data['sinking_fund_data'] = $this->sinking_fund_model->getSinkingFundData($filterData);
        }
        if ($sinkingFundId != '') {
            $data['title'] = 'Edit Sinking Fund';
        } else {
            $data['title'] = 'Add Sinking Fund';
        }
        if ((isset($data['sinking_fund_data']['society_id']) && $data['sinking_fund_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/SinkingFund');
        }
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        return $this->dt_ci_template->load("Admin","SinkingFund/SinkingFundManageView",$data);
    }

    public function getSinkingFundListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_sinking_fund as tsf");
        $this->datatables->select("tsf.sinking_fund_id,tsf.flat_id,tsf.on_date,COALESCE(tfy.financial_year_prefix,'') as financial_year_prefix,tsf.for_period,tsf.amount,tm.name");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tsf.updated_at");
        $this->datatables->select("concat(COALESCE(tto.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");

        $this->datatables->select("(select (COALESCE(SUM(tsfi.amount),0)) from tbl_sinking_fund_investment as tsfi where tsfi.sinking_fund_id = tsf.sinking_fund_id) as investment_amount");
        $this->datatables->select("(select (tsf.amount - (COALESCE(SUM(tsfi.amount),0))) from tbl_sinking_fund_investment as tsfi where tsfi.sinking_fund_id = tsf.sinking_fund_id) as remaining_amount");
        $this->datatables->select("(select (COALESCE(SUM(tsfw.amount),0)) from tbl_sinking_fund_withdrawn as tsfw where tsfw.sinking_fund_id = tsf.sinking_fund_id) as withdrawn_amount");


        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tsf.updated_by AND tupdate.society_id = tsf.society_id","left");
        $this->datatables->join("tbl_flat as tf","tf.flat_id = tsf.flat_id","left");
        $this->datatables->join("tbl_tower as tto","tto.tower_id = tf.tower_id","left");
        $this->datatables->join("tbl_financial_year as tfy","tfy.financial_year_id = tsf.financial_year_id","left");
        $this->datatables->join("tbl_ownership_flat_member as tofm","tofm.ownership_flat_member_id = tsf.ownership_flat_member_id","left");
        $this->datatables->join(MASTER_DB.".tbl_member as tm","tm.member_id = tofm.member_id","left");
        $this->datatables->groupBy("tsf.sinking_fund_id");
        accessFilter($this->datatables, array("society" => "tsf.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "sinking_fund_id" => isset($displayData['sinking_fund_id']) ? $displayData['sinking_fund_id'] : "",
                    "remaining_amount" => isset($displayData['remaining_amount']) ? $displayData['remaining_amount'] : 0,
                );
                $data[$key]['action_button'] = sinkingFundActionButton($actionButtonFilter);
                $data[$key]['on_date'] = isValidDate($displayData['on_date']) ? siteDateFormat($displayData['on_date']) : "";
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['excel_flat_no'] = isset($displayData['flat_no']) ?  $displayData['flat_no'] : "";
                $data[$key]['flat_no'] = isset($displayData['flat_no']) ?  flatDocumentToHtml($displayData['flat_no'],$displayData['flat_id']) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $sinkingFundId = $this->request->getVar('sinking_fund_id');
        $flatId = $this->request->getVar('flat_id');
        $financialYearId = $this->request->getVar('financial_year_id');
        $onDate = $this->request->getVar('on_date');
        $forPeriod = $this->request->getVar('for_period');
        $amount = $this->request->getVar('amount');
        $ownershipFlatMemberId = $this->request->getVar('ownership_flat_member_id');

        $validation->setRule('financial_year_id', lang('SinkingFund.financial_year'), 'required');
        $validation->setRule('flat_id', lang('SinkingFund.flat'), 'required');
        $validation->setRule('on_date', lang('SinkingFund.on_date'), 'required');
        $validation->setRule('for_period', lang('SinkingFund.for_period'), 'required');
        $validation->setRule('amount', lang('SinkingFund.amount'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $sinkingFundUpdateArray = array();
            $sinkingFundArray = array(
                'sinking_fund_id' => $sinkingFundId,
                'flat_id' => $flatId,
                'financial_year_id' => $financialYearId,
                'on_date' => DMYToYMD($onDate),
                'for_period' => $forPeriod,
                'amount' => $amount,
                'ownership_flat_member_id' => $ownershipFlatMemberId,
                'society_id' => $this->session->get('society_id'),
            );
            if(!empty($sinkingFundId)){
                $sinkingFundUpdateData = $this->sinking_fund_model->getSinkingFundData(array(
                    'sinking_fund_id' => $sinkingFundId,
                ));
                $sinkingFundUpdateArray = compareArray($sinkingFundArray,$sinkingFundUpdateData);
            }
            $sinkingFundData = $this->sinking_fund_model->insertUpdateRecord($sinkingFundArray, 'sinking_fund_id', 'tbl_sinking_fund', 1,'',array(),array(),$sinkingFundUpdateArray);
            $lastSinkingFundId = $sinkingFundData['lastInsertedId'];
            $transactionStatus = $this->db->transComplete();
            if (isset($sinkingFundId) && $sinkingFundId != '') {
                if (($sinkingFundData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('SinkingFund.sinking_fund'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('SinkingFund.sinking_fund'));
                }
            } else {
                if (($sinkingFundData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('SinkingFund.sinking_fund'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('SinkingFund.sinking_fund'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }


    public function delete()
    {
        $this->db->transStart();
        $sinkingFundId = $this->request->getVar('sinking_fund_id');
        $sinkingFundData = $this->sinking_fund_model->deleteRecord($sinkingFundId);
        $transactionStatus = $this->db->transComplete();
        if (($sinkingFundData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('SinkingFund.sinking_fund'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('SinkingFund.sinking_fund'));
        }
        echo json_encode($response);
        exit;
    }

    public function deleteInvestment()
    {
        $this->db->transStart();
        $sinkingFundInvestmentId = $this->request->getVar('sinking_fund_investment_id');
        $sinkingFundInvestmentData = $this->sinking_fund_model->deleteInvestmentRecord($sinkingFundInvestmentId);
        $transactionStatus = $this->db->transComplete();
        if (($sinkingFundInvestmentData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('SinkingFund.sinking_fund_investment'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('SinkingFund.sinking_fund_investment'));
        }
        echo json_encode($response);
        exit;
    }

    public function deleteWithdrawn()
    {
        $this->db->transStart();
        $sinkingFundWithdrawnId = $this->request->getVar('sinking_fund_withdrawn_id');
        $sinkingFundWithdrawnData = $this->sinking_fund_model->deleteWithdrawnRecord($sinkingFundWithdrawnId);
        $transactionStatus = $this->db->transComplete();
        if (($sinkingFundWithdrawnData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('SinkingFund.sinking_fund_withdrawn'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('SinkingFund.sinking_fund_withdrawn'));
        }
        echo json_encode($response);
        exit;
    }

    public function excelExportSinkingFund()
    {
        $fileName ='sinking-fund-' . DATETIMEFORMAT;
        $sheetName = 'Sinking-Fund-' . DATEFORMAT;
        $excelHeaderName = 'Sinking Fund';
        $tableData = $this->getSinkingFundListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('SinkingFund.flat'),
            lang('SinkingFund.member'),
            lang('SinkingFund.financial_year'),
            lang('SinkingFund.on_date'),
            lang('SinkingFund.for_period'),
            lang('SinkingFund.amount'),
            lang('SinkingFund.investment_amount'),
            lang('SinkingFund.withdrawn_amount'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["excel_flat_no"],
                $row["name"],
                $row["financial_year_prefix"],
                $row["on_date"],
                $row["for_period"],
                $row["amount"],
                $row["investment_amount"],
                $row["withdrawn_amount"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'J';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function addEditInvestment()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $sinkingFundInvestmentId = $this->request->getVar('sinking_fund_investment_id');
        $sinkingFundId = $this->request->getVar('sinking_fund_id');
        $bankId = $this->request->getVar('bank_id');
        $amount = $this->request->getVar('amount');
        $onDate = $this->request->getVar('on_date');

        $validation->setRule('bank_id', lang('SinkingFund.bank_id'), 'required');
        $validation->setRule('on_date', lang('SinkingFund.on_date'), 'required');
        $validation->setRule('amount', lang('SinkingFund.amount'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $sinkingFundData = $this->sinking_fund_model->getSinkingFundData(array(
                'sinking_fund_id' => $sinkingFundId,
                'sinking_fund_investment_id_not' => $sinkingFundInvestmentId,
            ));

            if (!empty($sinkingFundData)) {
                $sinkingAmount     = (float)$sinkingFundData['amount'];
                $investmentAmount  = (float)$sinkingFundData['investment_amount'];
                $amount     = (float)$amount;
                $invAmount = $investmentAmount + $amount;
                $remainingAmount = $sinkingAmount - $investmentAmount;

                if ($sinkingAmount < $invAmount) {
                    $response['success'] = false;
                    $response['msg'] = 'Amount should not be greater than remaining Investment Amount (' . number_format($remainingAmount, 2) . ').';
                    echo json_encode($response);
                    exit;
                }
            }


            $sinkingFundInvestmentUpdateArray = array();
            $sinkingFundInvestmentArray = array(
                'sinking_fund_investment_id' => $sinkingFundInvestmentId,
                'sinking_fund_id' => $sinkingFundId,
                'bank_id' => $bankId,
                'amount' => $amount,
                'on_date' => DMYToYMD($onDate),
                'society_id' => $this->session->get('society_id'),
            );
            if(!empty($sinkingFundInvestmentId)){
                $sinkingFundInvestmentUpdateData = $this->sinking_fund_model->getSinkingFundInvestmentData(array(
                    'sinking_fund_investment_id' => $sinkingFundInvestmentId,
                ));
                $sinkingFundInvestmentUpdateArray = compareArray($sinkingFundInvestmentArray,$sinkingFundInvestmentUpdateData);
            }
            $sinkingFundInvestmentData = $this->sinking_fund_model->insertUpdateRecord($sinkingFundInvestmentArray, 'sinking_fund_investment_id', 'tbl_sinking_fund_investment', 1,'',array(),$sinkingFundInvestmentUpdateArray);
            $lastsinkingFundInvestmentId = $sinkingFundInvestmentData['lastInsertedId'];
            
            $transactionStatus = $this->db->transComplete();
            if (isset($sinkingFundInvestmentId) && $sinkingFundInvestmentId != '') {
                if (($sinkingFundInvestmentData['success']) && ($transactionStatus == 1)) {
                    $response['success'] = true;
                    $response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("SinkingFund.sinking_fund"));
                } else {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("SinkingFund.sinking_fund"));
                }
            } else {
                if (($sinkingFundInvestmentData['success']) && ($transactionStatus == 1)) {
                    $response['success'] = true;
                    $response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("SinkingFund.sinking_fund"));
                } else {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("SinkingFund.sinking_fund"));
                }
            }
            echo json_encode($response);
            exit;
        }
    }

    public function addEditWithdrawn()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();
        $sinkingFundWithdrawnId = $this->request->getVar('sinking_fund_withdrawn_id');
        $sinkingFundId = $this->request->getVar('sinking_funds_id');
        $remarks = $this->request->getVar('remarks');
        $amount = $this->request->getVar('amounts');
        $withdrawnDate = $this->request->getVar('withdrawn_date');

        $validation->setRule('withdrawn_date', lang('SinkingFund.withdrawn_date'), 'required');
        $validation->setRule('amounts', lang('SinkingFund.amounts'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $sinkingFundWithdrawnUpdateArray = array();
            $sinkingFundWithdrawnArray = array(
                'sinking_fund_withdrawn_id' => $sinkingFundWithdrawnId,
                'sinking_fund_id' => $sinkingFundId,
                'remarks' => $remarks,
                'amount' => $amount,
                'withdrawn_date' => DMYToYMD($withdrawnDate),
                'society_id' => $this->session->get('society_id'),
            );
            if(!empty($sinkingFundWithdrawnId)){
                $sinkingFundWithdrawnUpdateData = $this->sinking_fund_model->getSinkingFundWithdrawnData(array(
                    'sinking_fund_withdrawn_id' => $sinkingFundWithdrawnId,
                ));
                $sinkingFundWithdrawnUpdateArray = compareArray($sinkingFundWithdrawnArray,$sinkingFundWithdrawnUpdateData);
            }
            $sinkingFundWithdrawnData = $this->sinking_fund_model->insertUpdateRecord($sinkingFundWithdrawnArray, 'sinking_fund_withdrawn_id', 'tbl_sinking_fund_withdrawn', 1,'',array(),$sinkingFundWithdrawnUpdateArray);
            $lastsinkingFundWithdrawnId = $sinkingFundWithdrawnData['lastInsertedId'];
            
            $transactionStatus = $this->db->transComplete();
            if (isset($sinkingFundWithdrawnId) && $sinkingFundWithdrawnId != '') {
                if (($sinkingFundWithdrawnData['success']) && ($transactionStatus == 1)) {
                    $response['success'] = true;
                    $response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("SinkingFund.sinking_fund"));
                } else {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("SinkingFund.sinking_fund"));
                }
            } else {
                if (($sinkingFundWithdrawnData['success']) && ($transactionStatus == 1)) {
                    $response['success'] = true;
                    $response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("SinkingFund.sinking_fund"));
                } else {
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("SinkingFund.sinking_fund"));
                }
            }
            echo json_encode($response);
            exit;
        }
    }

    public function investmentView($id = null)
    {
        $sinkingFundId = $this->request->getVar("view_id");
        if ($sinkingFundId == "" && $sinkingFundId == null) {
            return redirect()->to('Admin/SinkingFund');
        } else {
            $id = $sinkingFundId;
            $filterData = array(
                "sinking_fund_id" => $sinkingFundId,
                "is_multiple" => 1,
            );
            $sinkingFundInvestmentData = $this->sinking_fund_model->getSinkingFundInvestmentData($filterData);
            $data['sinking_fund_investment_data'] = $sinkingFundInvestmentData;
            $data['sinking_fund_id'] = $sinkingFundId;
            $investmentView = view("Admin/SinkingFund/InvestmentModelView", $data);
            $response['view_title'] = "Investment Details";
            $response['view_detail'] = $investmentView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function withdrawnView($id = null)
    {
        $sinkingFundId = $this->request->getVar("view_id");
        if ($sinkingFundId == "" && $sinkingFundId == null) {
            return redirect()->to('Admin/SinkingFund');
        } else {
            $id = $sinkingFundId;
            $filterData = array(
                "sinking_fund_id" => $sinkingFundId,
                "is_multiple" => 1,
            );
            $sinkingFundWithdrawnData = $this->sinking_fund_model->getSinkingFundWithdrawnData($filterData);
            $data['sinking_fund_withdrawn_data'] = $sinkingFundWithdrawnData;
            $data['sinking_fund_id'] = $sinkingFundId;
            $withdrawnView = view("Admin/SinkingFund/WithdrawnModelView", $data);
            $response['view_title'] = "Withdrawn Details";
            $response['view_detail'] = $withdrawnView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function getSinkingFundInvestmentData()
    {
        $sinkingFundInvestmentId = $this->request->getVar("sinking_fund_investment_id");
        if ($sinkingFundInvestmentId == "" && $sinkingFundInvestmentId == null) {
            return redirect()->to('Admin/SinkingFund');
        } else {
            $id = $sinkingFundInvestmentId;
            $filterData = array(
                "sinking_fund_investment_id" => $sinkingFundInvestmentId,
            );
            $sinkingFundInvestmentData = $this->sinking_fund_model->getSinkingFundInvestmentData($filterData);

            // printArray($sinkingFundInvestmentData,1);
            $response['success'] = true;
            $response['data'] = $sinkingFundInvestmentData;
            echo json_encode($response);
        }
    }

    public function getSinkingFundWithdrawnData()
    {
        $sinkingFundWithdrawnId = $this->request->getVar("sinking_fund_withdrawn_id");
        if ($sinkingFundWithdrawnId == "" && $sinkingFundWithdrawnId == null) {
            return redirect()->to('Admin/SinkingFund');
        } else {
            $id = $sinkingFundWithdrawnId;
            $filterData = array(
                "sinking_fund_withdrawn_id" => $sinkingFundWithdrawnId,
            );
            $sinkingFundWithdrawnData = $this->sinking_fund_model->getSinkingFundWithdrawnData($filterData);

            // printArray($sinkingFundWithdrawnData,1);
            $response['success'] = true;
            $response['data'] = $sinkingFundWithdrawnData;
            echo json_encode($response);
        }
    }
}
