<?php
namespace App\Controllers\Admin;
use App\Models\SettingModel;
use CodeIgniter\Controller;

class Setting extends BaseController
{

    protected $setting_model;
    public function __construct() {
        $this->setting_model = new SettingModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = lang('Setting.setting');
        return $this->dt_ci_template->load("Admin","Setting/SettingView",$data);
    }

    public function getSettingListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $this->datatables->table("tbl_setting as tp");
        $this->datatables->select("tp.setting_id,tp.inquiry_email,tp.phone_number,tp.site_title,tp.site_meta_description,tp.site_meta_keyword,tp.address,tp.privacy_policy, tp.terms_and_conditions,ts.society_name");

        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tp.updated_at");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tp.created_at");

        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tp.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tp.updated_by AND tupdate.society_id = tp.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tp.created_by AND tcreate.society_id = tp.society_id","left");

        accessFilter($this->datatables, array("society" => "tp.society_id"));
        $this->datatables->groupBy("tp.setting_id");
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "setting_id" => isset($displayData['setting_id']) ? $displayData['setting_id'] : "",
                );
                $data[$key]['action_button'] = settingActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($settingId = '',$view = '')
    {
        $request    = \Config\Services::request();
        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/ckeditor/ckeditor_classic.js",
        );
        if ($settingId != '') {
            $filterData = array(
                "setting_id" => $settingId
            );
            $data['setting_data'] = $this->setting_model->getSettingData($filterData);
            if (empty($data['setting_data'])) {
                return redirect()->to('Admin/Setting');
            }
        }

        if ($settingId != '') {
            $data['title'] = lang('Setting.edit_setting');
        } else {
            $data['title'] =  lang('Setting.add_setting');
        }

        $data['setting_data']['view'] = (isset($view) && $view != '' ? 1 : 0);

        if ((isset($data['setting_data']['society_id']) && $data['setting_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Setting');
        }

        $this->dt_ci_template->load("Admin","Setting/SettingManageView",$data);
    }

    public function save()
    {
        $validation = \Config\Services::validation();
        $this->db->transBegin();
        $settingId = $this->request->getVar('setting_id');
        $inquiryEmail = $this->request->getVar('inquiry_email');
        $phoneNumber = $this->request->getVar('phone_number');
        $siteTitle = $this->request->getVar('site_title');
        $siteMetaKeyword = $this->request->getVar('site_meta_keyword');
        $siteMetaDescription = $this->request->getVar('site_meta_description');
        $privacyPolicy = $this->request->getVar('privacy_policy');
        $termsAndCondition = $this->request->getVar('terms_and_conditions');

        $validation->setRule('inquiry_email', lang('Setting.inquiry_email'), 'required');
        $validation->setRule('phone_number', lang('Setting.phone_number'), 'required');
        $validation->setRule('site_title', lang('Setting.site_title'), 'required');
        $validation->setRule('site_meta_keyword', lang('Setting.site_meta_keyword'), 'required');
        $validation->setRule('site_meta_description', lang('Setting.site_meta_description'), 'required');
        // $validation->setRule('privacy_policy', lang('Setting.privacy_policy'), 'required');
        // $validation->setRule('terms_and_condition', lang('Setting.terms_and_condition'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $settingUpdateArray = array();
            $settingArray = array(
                'setting_id' => $settingId,
                'inquiry_email' => $inquiryEmail,
                'phone_number' => $phoneNumber,
                'site_title' => $siteTitle,
                'site_meta_keyword' => $siteMetaKeyword,
                'site_meta_description' => $siteMetaDescription,
                'privacy_policy' => $privacyPolicy,
                'terms_and_conditions' => $termsAndCondition,
                'society_id' => $this->session->get('society_id'),
            );

            if (!empty($settingId)) {
                $settingUpdateData = $this->setting_model->getSettingData(array(
                    "setting_id" => $settingId
                ));
                $settingUpdateArray = compareArray($settingArray, $settingUpdateData);
            }
            $settingData = $this->setting_model->insertUpdateRecord($settingArray, 'setting_id', 'tbl_setting', 1, '', array(), array(), $settingUpdateArray);
            $lastSettingId = $settingData['lastInsertedId'];

            if (isset($settingId) && $settingId != '') {
                if ($settingData['success']) {
                    $this->db->transCommit();
                    $response['success'] = true;
                    $response['msg'] = sprintf(lang('CommonMessage.update_record'), lang('Setting.setting'));
                } else {
                    $this->db->transRollback();
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang('Setting.setting'));
                }
            } else {
                if ($settingData['success']) {                    
                    $this->db->transCommit();
                    $response['success'] = true;
                    $response['msg'] = sprintf(lang('CommonMessage.create_record'), lang('Setting.setting'));
                } else {
                    $this->db->transRollback();
                    $response['success'] = false;
                    $response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang('Setting.setting'));
                }
            }
            echo json_encode($response);
            exit();
        }
    }

}
