<?php
namespace App\Controllers\Admin;

use App\Models\BookingModel;
use App\Models\CommonWebServiceModel;
use App\Models\PollModel;
use CodeIgniter\Controller;
use App\Models\VisitorModel;
use App\Models\ManagementCommitteeModel;
use App\Models\OwnershipFlatModel;
use App\Models\RentalsModel;
use App\Models\StatusModel;
use Firebase\JWT\JWT;
use CodeIgniter\HTTP\IncomingRequest;
helper('Dt_ci_site_helper');
class Schedular extends Controller
{
    protected $visitorModel;
    protected $pollModel;
    protected $bookingModel;
    protected $rentalsModel;
    protected $statusModel;
    protected $commonWebServiceModel;

    public function __construct() {

        $this->visitorModel = new VisitorModel();
        $this->ionAuth    = new \App\Libraries\IonAuth();
        $this->pollModel = new PollModel();
        $this->bookingModel = new BookingModel();
        $this->rentalsModel = new RentalsModel();
        $this->statusModel = new StatusModel();
        $this->commonWebServiceModel = new CommonWebServiceModel();
        $this->managementCommitteeModel = new ManagementCommitteeModel();
        $this->ownershipFlatModel = new OwnershipFlatModel();
    
    } 

    public function visitorExited(){
        $visitorData = $this->visitorModel->getVisitorData(array('is_multiple' => 1,'is_deleted' => 0));
        $currentDateTime = date('Y-m-d H:i:s');
        $visitorStatusUpdateData = array();
        if(!empty($visitorData)){
            foreach ($visitorData as $key => $visitor) {
                if ($visitor['status'] == 'entered'  && strtotime($visitor['start_date']) < strtotime($currentDateTime)) {
                    $visitorUpdateData[$key] = array(
                        'visitor_id' => $visitor['visitor_id'],
                        'status' => 'exited',
                    );
                    $notificationArray = array(
                        'ownership_flat_member_id' => $visitor['ownership_flat_member_id'],
                        'ownership_flat_id' => $visitor['ownership_flat_id'],
                        'status' => 'exited',
                        'type' => $visitor['type'],
                        'society_id' => $visitor['society_id'],
                        'user_id' => $visitor['created_at'],
                        'type_id' => $visitor['type_id'],
                        'visitor_name' => $visitor['visitor_name'],
                        'visitor_company_name' => $visitor['visitor_company_name'],
                        'collect_on_gate' => $visitor['collect_on_gate'],
                        'guard' => $visitor['updated_by_name'],
                        'vehicle_no' => $visitor['vehicle_no'],
                        'module' => 'visitor',
                        'app_type' => GATE_KEEPER,
                    );
                    $notificationArray['send_for_notification'] = 'admin';
                    $notificationArray['send_for_notification_id'] = $this->ionAuth->getUserId();
                    $notificationArray['receive_for_notification'] = MEMBER_APP;
                    $notificationArray['receive_for_notification_id'] = $visitor['ownership_flat_member_id'];
                    $extraDatajson = json_encode($notificationArray);
                    sendNotificationDataList($notificationArray,$extraDatajson);
                }
            }
        }
        // echo '<pre>';
        // print_r($visitorUpdateData);
        // echo '</pre>';
        // die();
        if(!empty($visitorStatusUpdateData)){
            $visitorStatusUpdateData = $this->visitorModel->batchUpdate($visitorUpdateData, "visitor_id", 'tbl_visitor',array());
        }
        return $visitorStatusUpdateData;
    }

    public function visitorFrequentlyEntered(){
        
        $dayName = date('l');
        $todayDayName = substr($dayName, 0, 3);
        $todayDate = date("Y-m-d");
        $visitorData = $this->visitorModel->getVisitorData(array(
            'is_multiple' => 1,
            'is_deleted' => 0,
            'visitor_duration' => 'frequent',
            'type' => 'delivery_boy',
            'today_date' => $todayDate,
        ));
        $visitorIdArray = array();
        foreach ($visitorData as $key => $visitor) {
            $visitorIdArray[] = $visitor['visitor_id'];
        }
        $visitorWorkingDayData = $this->visitorModel->getVisitorWorkingDayData(array(
            "visitor_id" => $visitorIdArray,
            "working_day_name" => $todayDayName,
            'is_multiple' => 1,
        ));
        if(!empty($visitorWorkingDayData)){
            foreach ($visitorWorkingDayData as $workingDay) {
                $visitorId = $workingDay['visitor_id'];
                $visitorData = $this->visitorModel->getVisitorData(array('visitor_id' => $visitorId));
                // printArray($visitorData,1);
                $currentExpStartDateTime = $visitorData['expected_start_date_time'];
                $currentExpEndDateTime = $visitorData['expected_end_date_time'];

                if (!empty($visitorData)) {
                    $currentDate = date('Y-m-d');
                    $startTime = date('H:i:s', strtotime($currentExpStartDateTime));
                    $endTime = date('H:i:s', strtotime($currentExpEndDateTime));
                    $newExpStartDateTime = $currentDate . ' ' . $startTime;
                    $newExpEndDateTime = $currentDate . ' ' . $endTime;
                    $newVisitorData = [
                        'visitor_id'           => '',
                        'visitor_name'           => $visitorData['visitor_name'],
                        'visitor_mobile_no'      => $visitorData['visitor_mobile_no'],
                        'visitor_purpose'        => $visitorData['visitor_purpose'],
                        'vehicle_type'           => $visitorData['vehicle_type'],
                        'vehicle_no'             => $visitorData['vehicle_no'],
                        'society_id'             => $visitorData['society_id'],
                        'type'                   => $visitorData['type'],
                        'resource_id'            => $visitorData['resource_id'],
                        'resource_flat_id'       => $visitorData['resource_flat_id'],
                        'is_deleted'             => 0,
                        'parking_slot_id'       => $visitorData['parking_slot_id'],
                        'ownership_flat_id'       => $visitorData['ownership_flat_id'],
                        'ownership_flat_member_id'       => $visitorData['ownership_flat_member_id'],
                        'ownership_flat_parking_id'       => $visitorData['ownership_flat_parking_id'],
                        'visitor_company_id'       => $visitorData['visitor_company_id'],
                        'no_of_parcel'       => $visitorData['no_of_parcel'],
                        'collect_on_gate'       => $visitorData['collect_on_gate'],
                        'status'       => 'entry_pre_approve',
                        'address'       => $visitorData['address'],
                        'expected_start_date_time'       => $newExpStartDateTime,
                        'expected_end_date_time'       => $newExpEndDateTime,
                        'no_of_visitor'       => $visitorData['no_of_visitor'],
                        'anytime_during_the_day'       => $visitorData['anytime_during_the_day'],
                        'qr_code_number'       => $visitorData['qr_code_number'],
                        'qr_code_image'       => $visitorData['qr_code_image'],
                        'category_id'       => $visitorData['category_id'],
                        // 'created_by'             => $this->Data[''],
                        // 'updated_by'             => $this->session->get('user_id'),
                    ];
                    $newVisitorId = $this->visitorModel->insertUpdate($newVisitorData,'visitor_id','tbl_visitor',1);

                    $notificationArray = array(
                        'ownership_flat_member_id' => $visitorData['ownership_flat_member_id'],
                        'ownership_flat_id' => $visitorData['ownership_flat_id'],
                        'status' => 'entry_pre_approve',
                        'type' => $visitorData['type'],
                        'society_id' => $visitorData['society_id'],
                        'user_id' => $visitorData['created_at'],
                        'type_id' => $visitorData['type_id'],
                        'visitor_name' => $visitorData['visitor_name'],
                        'visitor_company_name' => $visitorData['visitor_company_name'],
                        'collect_on_gate' => $visitorData['collect_on_gate'],
                        'guard' => $visitorData['updated_by_name'],
                        'vehicle_no' => $visitorData['vehicle_no'],
                        'module' => 'visitor',
                        'app_type' => MEMBER_APP,
                    );
                    $notificationArray['send_for_notification'] = 'admin';
                    $notificationArray['send_for_notification_id'] = $this->ionAuth->getUserId();
                    $notificationArray['receive_for_notification'] = GATE_KEEPER;
                    $notificationArray['receive_for_notification_id'] = $visitorData['user_id'];
                    $extraDatajson = json_encode($notificationArray);
                    sendNotificationDataList($notificationArray,$extraDatajson);
                }
            }
            return $newVisitorId;
        }
    }

    public function pollEndDate() {
        $pollData = $this->pollModel->getPollData(array('is_multiple' => 1));
        $currentDate = date('Y-m-d');
        $pollEndData = array();
        $memberIdArray = array();
        $notificationDataArray = array();
        foreach ($pollData as $poll) {
            $diff = (strtotime($currentDate) - strtotime($poll['end_date'])) / (60 * 60 * 24);
            if ($diff == 1) {
                $pollEndData[] = $poll;
            }
        }
        $sendNotificationDataArray = array();
        if(!empty($pollEndData)){
            foreach ($pollEndData as $key => $pollEnd) {
                $userIdArray = array();
                $customerDataArray = array();
                $batchNotificationDataArray = array();
                $notificationMergeArray = array();
                
                $notificationArray = array(
                    'notification_title' => 'Poll Results Are In!',
                    'description' => 'The poll on '.$pollEnd['poll_title'].' has ended. Check the app to see the final results and how the community voted.',
                );
                $playerIdArray = array();
                $iosPlayerIdArray = array();
                $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
                $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
                $memberIdArray = array();
                $notificationDataArray = array();
                $notificationMergeArray = array();
                $userDeviceUserIdArray = array();
                $userDeviceUserTypeIdArray = array();
                $userDeviceUserTypeArray = array();
                $managementCommitteeData = $this->managementCommitteeModel->getManagementCommitteeData(array(
                    'society_id' => $pollEnd['society_id'],
                    'is_multiple' => 1
                ));
                if (!empty($managementCommitteeData)) {
                    foreach ($managementCommitteeData as $managementCommitteeElement) {
                        $memberIdArray[] = $managementCommitteeElement['member_id'];
                    }
                }
                if (!empty($memberIdArray)) {
                    $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                        'resource_type_name' => RESOURCE_TYPE_MEMBER,
                        'society_id' => $this->session->get('society_id'),
                    ));
                    if(!empty($resourceTypeData)){
                        $userSocietyCommitteeData = $this->commonWebServiceModel->getUserSocietyData(array(
                            'society_id' => $pollEnd['society_id'],
                            'resource_type_id' => $resourceTypeData['resource_type_id'],
                            'type_id' => $memberIdArray,
                            'user_id_not' => $this->ionAuth->getUserId(),
                            //'is_management_committee' => 1,
                            // 'is_user_device_token_get' => 1,
                            'is_multiple' => 1
                        ));
                        if (!empty($userSocietyCommitteeData)) {
                            foreach ($userSocietyCommitteeData as $userSocietyCommitteeElement) {
                                $userDeviceUserIdArray[] = isset($userSocietyCommitteeElement['user_id']) ? $userSocietyCommitteeElement['user_id'] : 0;
                                $userDeviceUserTypeIdArray[] = isset($userSocietyCommitteeElement['type_id']) ? $userSocietyCommitteeElement['type_id'] : 0;
                                $userDeviceUserTypeArray[] = $resourceTypeData['resource_type_id'];
                            }
                        }
                        $userDeviceData = $this->commonWebServiceModel->deviceData(array(
                            "user_id" => $userDeviceUserIdArray,
                            "user_type_id" => $userDeviceUserTypeIdArray,
                            "resource_type_id" => $userDeviceUserTypeArray,
                            "is_latest" => 1,
                            "is_multiple" => 1
                        ));
                         // printArray($userDeviceData,1);
                        if(!empty($userDeviceData)){
                            foreach($userDeviceData as $userDevice){
                                $notificationOtherArray = array(
                                    'notification_id' => '',
                                    'society_id' => $pollEnd['society_id'],
                                    'notification_date' => TODAY_DATE_YMD,
                                    'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                    'type' => 'poll',
                                    'type_id' => $pollEnd['poll_id'],
                                    // 'module' => 'poll',
                                    'created_by' => $this->ionAuth->getUserId(),
                                    'updated_by' => $this->ionAuth->getUserId(),
                                    'created_at' => date("Y-m-d H:i:s"),
                                    'updated_at' => date("Y-m-d H:i:s"),
                                );
                                $notificationOtherArray['send_for_notification'] = 'admin';
                                $notificationOtherArray['send_for_notification_id'] = $this->ionAuth->getUserId();
                                $notificationOtherArray['receive_for_notification'] = $resourceTypeData['resource_type_id'];
                                $notificationOtherArray['receive_for_notification_id'] = $userDevice['user_type_id'];
                                if(!empty($notificationOtherArray)){
                                    // echo "df";
                                    $notificationMergeArray = array_merge($notificationArray,$notificationOtherArray);
                                    $extraDataJsonArray = $notificationMergeArray;
                                    $extraDataJsonArray['module'] = 'poll';
                                    $extraDataJsonArray['status'] = 'poll_ended';
                                    $extraDatajson = json_encode($extraDataJsonArray);
                                    $notificationMergeArray['extra_data'] = $extraDatajson;
                                    $customerData['extra_data'] = $extraDatajson;
                                    $customerData['app_url'] = MEMBER_URL .'poll/completed';
                                    //send notification data
                                    $deviceToken = $userDevice['one_signal_id'];
                                    $playerId = $userDevice['player_id'];
                                    $batchNotificationDataArray[] = $notificationMergeArray;

                                    $sendNotificationDataArray[] = array(
                                        'notification_title' => 'Poll Results Are In!',
                                        'description' => 'The poll on '.$pollEnd['poll_title'].' has ended. Check the app to see the final results and how the community voted.',
                                        'extra_data_json' => $extraDatajson,
                                        'app_url' => MEMBER_URL .'poll/completed',
                                        'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                        'device_id' => $userDevice['device_id'],
                                        'type' => 'poll',
                                    );

                                    // if(strtolower($userDevice['device_type']) == 'android'){
                                    //     if (!empty($playerId)) {
                                    //         array_push($playerIdArray,$playerId);
                                    //     }
                                    // } else {
                                    //     if (!empty($playerId)) {
                                    //         array_push($iosPlayerIdArray,$playerId);
                                    //     }
                                    // }
                                }
                            }
                        }
                        if(!empty($batchNotificationDataArray)){
                            $this->ownershipFlatModel->batchInsert($batchNotificationDataArray,'tbl_notification');
                        }
                        // echo "ffd";
                        // printArray($playerIdArray,1);
                        // $sendNotificationData = array();
                        // if(!empty($playerIdArray)){
                        //     $customerData['player_id'] = $playerIdArray;
                        //     $sendNotificationData = $customerData;
                        //     sendNotificationAndroid($sendNotificationData);
                        // }
                        // $sendNotificationIOSData = array();
                        // if(!empty($iosPlayerIdArray)){
                        //     $customerData['player_id'] = $iosPlayerIdArray;
                        //     $sendNotificationIOSData = $customerData;
                        //     sendNotificationIOS($sendNotificationIOSData);
                        // }
                    }
                }
            }
        }

        if(!empty($sendNotificationDataArray)){
            sendNotification($sendNotificationDataArray);
        }
        return $pollEndData;
    }
    
    public function cancelAmenitiesBooking() {
        $currentDateTime = date('Y-m-d H:i:s');

        $pendingBookingData = $this->bookingModel->getBookingData(array(
            'is_multiple' => 1,
            'status' => "pending",
            'current_date_time' => $currentDateTime,
        ));
        
        $bookingUpdateArray = array();
        if(!empty($pendingBookingData)){
            foreach ($pendingBookingData as $bkey => $booking) {
                $bookingUpdateArray[$bkey]['booking_id'] = $booking['booking_id'];
                $bookingUpdateArray[$bkey]['status'] = 'cancelled';
                $bookingUpdateArray[$bkey]['cancel_at'] = date('Y-m-d H:i:s');
                $bookingUpdateArray[$bkey]['cancel_by'] = -9 ;
            }
        }
        
        if(!empty($bookingUpdateArray)){
            $bookingUpdateData = $this->bookingModel->batchUpdate($bookingUpdateArray, "booking_id", 'tbl_booking',array());
        }
        return $bookingUpdateData;
    }

    public function closeRentalsAggrement(){

        $statusData = $this->statusModel->getStatusData(array(
            "status_for" => "rentals",
            "is_close" => 1,
        ));
        if(!empty($statusData)){
            $statusClosedId = $statusData['status_id'];
        }
        $rentalsAggrementNotClosedData = $this->rentalsModel->getAggrementNotClosed(array(
            "is_multiple" => 1,
        ));

        if(!empty($rentalsAggrementNotClosedData)){
            $rentalsUpdateArray = array();
            foreach ($rentalsAggrementNotClosedData as $rkey => $rentals) {
                $rentalsUpdateArray[$rkey]['rentals_id'] = $rentals['rentals_id'];
                $rentalsUpdateArray[$rkey]['status_id'] = $statusClosedId;
                $rentalsUpdateArray[$rkey]['rental_closing_date'] = $rentals['rent_agreement_period_to'];
                $rentalsUpdateArray[$rkey]['rental_closing_reason'] = "Aggrement Over";
            }
        }

        if(!empty($rentalsUpdateArray)){
            $rentalsUpdateData = $this->rentalsModel->batchUpdate($rentalsUpdateArray, "rentals_id", 'tbl_rentals',array());
        }
        return $rentalsUpdateData;
    }


}
