<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\ParkingPlaceModel;
use App\Models\AreaModel;
use App\Models\OwnershipFlatModel;
class ParkingPlace extends BaseController
{
    protected $parking_place_model;
    protected $area_model;
    protected $ownership_flat_model;
    public function __construct() {
        $this->area_model = new AreaModel();
        $this->parking_place_model = new ParkingPlaceModel();
        $this->ownership_flat_model = new OwnershipFlatModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            //"js/vendor/tables/datatables/datatables.min.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Parking Place';
        $data['v_parking_place_modal'] = view('Admin/ParkingPlace/ParkingPlaceModalView', $data);
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", array());
        return $this->dt_ci_template->load("Admin","ParkingPlace/ParkingPlaceView",$data);
    }

    public function getParkingPlaceListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_parking_place as tpp");
        $this->datatables->select("tpp.parking_place_id,tpp.flat_id,tpp.area_id,tpp.number,COALESCE(ta.vehicle_type,'') as vehicle_type, tpp.is_active,tpp.society_id,ts.society_name,tpp.is_visitor_parking,concat(COALESCE(ta.area_name,''),'-',ConvertToTitleCase(ta.vehicle_type)) as area_vehicle_type_name,tm.name");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tpp.updated_at");
        $this->datatables->select("if(tpp.is_visitor_parking = 1,'Yes','No') as is_visitor_parking_display");
        $this->datatables->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");
        $this->datatables->select("COALESCE(ta.area_name,'') as area_name");
        $this->datatables->join("tbl_flat as tf","tf.flat_id = tpp.flat_id","left");
        $this->datatables->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tpp.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tpp.updated_by AND tupdate.society_id = tpp.society_id","left");
        $this->datatables->join("tbl_area as ta","ta.area_id = tpp.area_id","left");
        $this->datatables->join("tbl_ownership_flat_parking as tofp","tofp.parking_place_id = tpp.parking_place_id AND tofp.is_delete = 0","left");
        $this->datatables->join("tbl_ownership_flat_member as tofm", "tofm.ownership_flat_id = tofp.ownership_flat_id AND tofp.type = tofm.type ",  "left");
        $this->datatables->join(MASTER_DB.".tbl_member as tm", "tm.member_id = tofm.member_id",  "left");
        $this->datatables->groupBy("tpp.parking_place_id");
        accessFilter($this->datatables, array("society" => "tpp.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "parking_place_id" => isset($displayData['parking_place_id']) ? $displayData['parking_place_id'] : "",
                );
                $data[$key]['action_button'] = parkingPlaceActionButton($actionButtonFilter);
                $data[$key]['excel_flat_no'] = isset($displayData['flat_no']) ?  $displayData['flat_no'] : "";
                $data[$key]['display_flat_no'] = isset($displayData['flat_no']) ?  flatDocumentToHtml($displayData['flat_no'],$displayData['flat_id']) : "";
                $data[$key]['vehicle_type'] = isset($displayData['vehicle_type']) ?  underscoreToUcWord($displayData['vehicle_type']) : "";
                // $data[$key]['is_visitor_parking_display'] = (isset($displayData['is_visitor_parking']) && $displayData['is_visitor_parking'] != 0) ?  "Yes" : "No";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function addEdit()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $parkingPlaceId = $this->request->getVar('parking_place_id');
        $areaId = $this->request->getVar('area_id');
        $number = $this->request->getVar('number');
        $flatId = $this->request->getVar('flat_id');
        $isActive = $this->request->getVar('is_active');
        $isVisitorParking = $this->request->getVar('is_visitor_parking');

        $areaData =  $this->area_model->getAreaData(array('area_id' => $areaId));

        $filterData = array(
            "flat_id" => $flatId,
            "area_id" => $areaId,
            "number" => $number,
            "vehicle_type" => $areaData['vehicle_type'],
            "society_id" => $this->session->get('society_id'),
            'parking_place_id_not' => $parkingPlaceId,
            "is_multiple" => 1
        );
        $parkingPlaceData = $this->parking_place_model->getParkingPlaceData($filterData);
        if(!empty($parkingPlaceData)){
            $response['success'] = false;
            //$response['msg'] = "Can/t Select Same Area For Same Flat";
            $response['msg'] = "Can/t Enter Same Parking number from Same Area And Same Flat";
            echo json_encode($response);
            die();
        }
        $areaSlot = 0;
        $areaSlot = isset($areaData['slot']) ? $areaData['slot'] : 0;

//        $totalAreaWiseSlotData = $this->parking_place_model->getTotalAreaParkingData(array(
//            "area_id" => $areaId,
//            "society_id" => $this->session->get('society_id'),
//            'parking_place_id_not' => $parkingPlaceId,
//        ));
//        $areaWiseAssignSlot =  isset($totalAreaWiseSlotData['total_assign_slot']) ? $totalAreaWiseSlotData['total_assign_slot'] : 0;
//
//        if($areaSlot < $areaWiseAssignSlot){
//            $response['success'] = false;
//            $response['msg'] = "Area Already Assign " . $areaSlot ." Slot For Other Flat";
//            echo json_encode($response);
//            die();
//        }
        $validation->setRule('area_id', lang('ParkingPlace.area'), 'required');
        $validation->setRule('number', lang('ParkingPlace.number'), 'required');
        if(!isset($isVisitorParking)){
            $validation->setRule('flat_id', lang('ParkingPlace.flat_no'), 'required');
        }

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            if(!empty($parkingPlaceId)){
                $filterData = array(
                    'parking_place_id' => $parkingPlaceId,
                );
                $parkingPlaceDataArray = $this->parking_place_model->getParkingPlaceData($filterData);
                if($parkingPlaceDataArray['flat_id'] != $flatId){
                    $ownershipFlatParkingData = $this->ownership_flat_model->getOwnershipFlatParkingData(array(
                        'parking_place_id' => $parkingPlaceId,
                    ));
                    if(!empty($ownershipFlatParkingData)){
                        $response['success'] = false;
                        $response['msg'] = "This Parking is already assign to " . underscoreToUcWord($ownershipFlatParkingData['type']) . ' ' . $ownershipFlatParkingData['flat_no'];
                        echo json_encode($response);
                        die();
                    }
                }
            }
            $parkingPlaceUpdateArray = array();
            $parkingPlaceArray = array(
                'parking_place_id' => $parkingPlaceId,
                'area_id' => $areaId,
                'number' => $number,
                'society_id' => $this->session->get('society_id'),
                'flat_id' => $flatId,
                'is_active' => isset($isActive) ? 1 : 0,
                'is_visitor_parking' => isset($isVisitorParking) ? 1 : 0,
            );
            if(!empty($parkingPlaceId)){
                $parkingPlaceUpdateData = $this->parking_place_model->getParkingPlaceData(array(
                    'parking_place_id' => $parkingPlaceId,
                ));
                $parkingPlaceUpdateArray = compareArray($parkingPlaceArray,$parkingPlaceUpdateData);
            }
            $parkingPlaceData = $this->parking_place_model->insertUpdateRecord($parkingPlaceArray,'parking_place_id','tbl_parking_place', 1,'',array(),array(),$parkingPlaceUpdateArray);
            $transactionStatus = $this->db->transComplete();
            if (isset($parkingPlaceId) && $parkingPlaceId != '') {
                if (($parkingPlaceData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('ParkingPlace.parking_place'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('ParkingPlace.parking_place'));
                }
            } else {
                if (($parkingPlaceData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('ParkingPlace.parking_place'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('ParkingPlace.parking_place'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $parkingPlaceId = $this->request->getVar('parking_place_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->parking_place_model->statusChange($parkingPlaceId,$status,'parking_place_id','tbl_parking_place');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('ParkingPlace.parking_place'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('ParkingPlace.parking_place'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $parkingPlaceId = $this->request->getVar('parking_place_id');
         if( isReferenceInTable( 'parking_place_id','tbl_rentals_parking', $parkingPlaceId) ||
             isReferenceInTable( 'parking_place_id','tbl_visitor', $parkingPlaceId) ||
             isReferenceInTable( 'parking_place_id','tbl_ownership_flat_parking', $parkingPlaceId)){

             if(!empty($parkingPlaceId)){
                 foreach($parkingPlaceId as $parkingPlace){
                     $deleteDataArray['module'] = 'Parking Place';
                     $deleteDataArray['activity'] = "Tried to delete Parking Place ";
                     $deleteDataArray['module_id'] = $parkingPlace;
                     logActivity('Tried to delete Parking Place [ParkingPlaceID: ' . $parkingPlace . ']',$this->data['userId'],'Parking Place',$parkingPlace,json_encode($deleteDataArray),'','Parking Place',$parkingPlace);
                 }
             }
             $response['success'] = false;
             $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
             echo json_encode($response);
             exit;
         }
        $parkingPlaceData = $this->parking_place_model->deleteRecord($parkingPlaceId);
        $transactionStatus = $this->db->transComplete();
        if (($parkingPlaceData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('ParkingPlace.parking_place'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('ParkingPlace.parking_place'));
        }
        echo json_encode($response);
        exit;
    }

    public function getParkingPlaceDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $parkingPlaceId = $this->request->getVar('parking_place_id');
        $vehicleType = $this->request->getVar('vehicle_type');
        $flatId = $this->request->getVar('flat_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'parking_place_id' => $parkingPlaceId,
            'vehicle_type' => $vehicleType,
            'flat_id' => $flatId,

        );
        echo $this->parking_place_model->getParkingPlace($filterData);
    }

    public function excelExportParkingPlace()
    {
        $fileName ='pp-' . DATETIMEFORMAT;
        $sheetName = 'PP-' . DATEFORMAT;
        $excelHeaderName = 'Parking Place';
        $tableData = $this->getParkingPlaceListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('ParkingPlace.society'),
            lang('ParkingPlace.flat_no'),
            lang('ParkingPlace.area'),
            lang('ParkingPlace.number'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["excel_flat_no"],
                $row["area_name"],
                $row["number"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
