<?php
namespace App\Controllers\Admin;

use App\Libraries\Dt_mpdf;
use App\Models\CommonWebServiceModel;
use CodeIgniter\Controller;
use App\Models\OrganicWasteRecordModel;
use App\Models\DocumentModel;
use App\Models\SocietyModel;

class OrganicWasteRecord extends BaseController
{
    protected $organic_waste_record_model;
    public function __construct() {
        $this->organic_waste_record_model = new OrganicWasteRecordModel();
        $this->society_model = new SocietyModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
		$data['title'] = 'Organic Waste Record';
		$dataFilters['filters'] = array(
			array(
				"type" => "daterange",
				"id" => "filter_record_date",
				"name" => "filter_record_date",
				"title" => "OrganicWasteRecord.record_date",
				"selected" => LAST_MONTH
			),
			array(
				"type" => "daterange",
				"id" => "filter_updated_at",
				"name" => "filter_updated_at",
				"title" => "CommonMessage.common_updated_at",
			),
		);
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
		$this->dt_ci_template->load("Admin","OrganicWasteRecord/OrganicWasteRecordView",$data);
	}

	public function manage($organicWasteRecordId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
        );

        if ($organicWasteRecordId != '') {
			$filterData = array(
				"organic_waste_record_id" => $organicWasteRecordId
			);
			$data['organic_waste_record_data'] = $this->organic_waste_record_model->getOrganicWasteRecordData($filterData);

			if (empty($data['organic_waste_record_data'])) {
                return redirect()->to('Admin/OrganicWasteRecord');
            }

		}
		
		if ($organicWasteRecordId != '') {
			$data['title'] = 'Edit Organic Waste Record';
		} else {
			$data['title'] = 'Add Organic Waste Record';
		}

		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
		if ((isset($data['organic_waste_record_data']['society_id']) && $data['organic_waste_record_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/OrganicWasteRecord');
        }
		$this->dt_ci_template->load("Admin","OrganicWasteRecord/OrganicWasteRecordManageView",$data);
	}

    public function getOrganicWasteRecordListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}

		$recordDate = $this->request->getVar("filter_record_date");
		$updatedAt = $this->request->getVar("filter_updated_at");

        $this->datatables->table("tbl_organic_waste_record as towr");
		$this->datatables->select("towr.organic_waste_record_id,towr.record_date,towr.kitchen_waste,towr.sawdust,towr.bacteria,towr.processed_compost, towr.ready_compost");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,towr.updated_at");
		$this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = towr.updated_by AND tupdate.society_id = towr.society_id","left");
		$this->datatables->groupBy("towr.organic_waste_record_id");
		accessFilter($this->datatables, array("society" => "towr.society_id"));
		
		if($recordDate != ''){
			list($fromDate,$toDate) = explode(" - ",$recordDate);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(towr.record_date,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(towr.record_date,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(towr.record_date,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

		if($updatedAt != ''){
			list($fromDate,$toDate) = explode(" - ",$updatedAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(towr.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(towr.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(towr.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

		
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"organic_waste_record_id" => isset($data[$key]['organic_waste_record_id']) ? $data[$key]['organic_waste_record_id'] : ""
				);
				$data[$key]['action_button'] = organicWasteRecordActionButton($actionButtonFilter);
				$data[$key]['record_date'] = siteDateFormat($displayData['record_date']);
				$data[$key]['updated_at'] = isValidDate($data[$key]['updated_at']) ? siteDateFormat($data[$key]['updated_at'],true) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function save()
	{
		$this->db->transStart();
		$validation = \Config\Services::validation();
		$organicWasteRecordId = $this->request->getVar('organic_waste_record_id');
		$recordDate = $this->request->getVar('record_date');
		$kitchenWaste = $this->request->getVar('kitchen_waste');
		$processedCompost = $this->request->getVar('processed_compost');
		$sawdust = $this->request->getVar('sawdust');
		$bacteria = $this->request->getVar('bacteria');
		$readyCompost = $this->request->getVar('ready_compost');
		
		$validation->setRule('record_date', lang('OrganicWasteRecord.record_date'), 'required');
		$validation->setRule('kitchen_waste', lang('OrganicWasteRecord.kitchen_waste'), 'required');
		$validation->setRule('processed_compost', lang('OrganicWasteRecord.processed_compost'), 'required');
		$validation->setRule('sawdust', lang('OrganicWasteRecord.sawdust'), 'required');
		$validation->setRule('bacteria', lang('OrganicWasteRecord.bacteria'), 'required');
		$validation->setRule('ready_compost', lang('OrganicWasteRecord.ready_compost'), 'required');
		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

			$existsOrganicWasteRecordData = $this->organic_waste_record_model->getOrganicWasteRecordData(array(
				'record_date' => DMYToYMD($recordDate),
				'organic_waste_record_id_not' => $organicWasteRecordId,
            ));

            if(!empty($existsOrganicWasteRecordData)){
				$response['success'] = false;
            	$response['msg'] = lang("OrganicWasteRecord.record_exists");
            	echo json_encode($response);
            	exit;
            }

			$organicWasteRecordUpdateArray = array();
			$organicWasteRecordArray = array(
				'organic_waste_record_id' => $organicWasteRecordId,
				'record_date' => DMYToYMD($recordDate),
				'kitchen_waste' => $kitchenWaste,
				'processed_compost' => $processedCompost,
				'sawdust' => $sawdust,
				'bacteria' => $bacteria,
				'ready_compost' => $readyCompost,
				'society_id' => $this->session->get('society_id'),
			);

			if(!empty($organicWasteRecordId)){
                $organicWasteRecordUpdateData = $this->organic_waste_record_model->getOrganicWasteRecordData(array(
                    'organic_waste_record_id' => $organicWasteRecordId,
                ));
                $organicWasteRecordUpdateArray = compareArray($organicWasteRecordArray,$organicWasteRecordUpdateData);
            }

			$organicWasteRecordData = $this->organic_waste_record_model->insertUpdateRecord($organicWasteRecordArray, 'organic_waste_record_id', 'tbl_organic_waste_record', 1,'',array(),array(),$organicWasteRecordUpdateArray);
			$lastOrganicWasteRecordId = $organicWasteRecordData['lastInsertedId'];

			$transactionStatus = $this->db->transComplete();
			if (isset($organicWasteRecordId) && $organicWasteRecordId != '') {
				if (($organicWasteRecordData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("OrganicWasteRecord.organic_waste_record"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("OrganicWasteRecord.organic_waste_record"));
				}
			} else {
				if (($organicWasteRecordData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("OrganicWasteRecord.organic_waste_record"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("OrganicWasteRecord.organic_waste_record"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
        $organicWasteRecordId = $this->request->getVar('organic_waste_record_id');
        // if( isReferenceInTable( 'organic_waste_record_id','tbl_men_power_attendance', $organicWasteRecordId)){
		// if(!empty($organicWasteRecordId)){
		// 	foreach($organicWasteRecordId as $documentElement){
		// 		$deleteDataArray['module'] = 'OrganicWasteRecord';
		// 		$deleteDataArray['activity'] = "Tried to Delete OrganicWasteRecord ";
		// 		$deleteDataArray['module_id'] = $documentElement;
		// 		logActivity('Tried to delete OrganicWasteRecord [OrganicWasteRecordID: ' . $documentElement . ']',$this->data['userId'],'OrganicWasteRecord',$documentElement,json_encode($deleteDataArray),'','OrganicWasteRecord',$documentElement);
		// 	}
		// }
        //     $response['success'] = false;
        //     $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
        //     echo json_encode($response);
        //     exit;
        // }
        $organicWasteRecordData = $this->organic_waste_record_model->deleteRecord($organicWasteRecordId);
        $transactionStatus = $this->db->transComplete();
        if (($organicWasteRecordData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("OrganicWasteRecord.organic_waste_record"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("OrganicWasteRecord.organic_waste_record"));
        }
        echo json_encode($response);
        exit;
    }


	public function excelExportOrganicWasteRecord()
	{
		$fileName ='OrganicWasteRecord-' . DATETIMEFORMAT;
		$sheetName = 'OrganicWasteRec-' . DATEFORMAT;
		$excelHeaderName = 'OrganicWasteRecord';
		$tableData = $this->getOrganicWasteRecordListing(true, $_GET);
		$dataRows = array();
		$dataRows[] = array(
			lang('OrganicWasteRecord.record_date'),
			lang('OrganicWasteRecord.kitchen_waste'),
			lang('OrganicWasteRecord.processed_compost'),
			lang('OrganicWasteRecord.sawdust'),
			lang('OrganicWasteRecord.bacteria'),
			lang('OrganicWasteRecord.ready_compost'),
			lang('CommonMessage.common_updated_by'),
			lang('CommonMessage.common_updated_at')
		);
		foreach ($tableData as $row) {
			$dataRows[] = array(
				$row["record_date"],
				$row["kitchen_waste"],
				$row["processed_compost"],
				$row["sawdust"],
				$row["bacteria"],
				$row["ready_compost"],
				$row["updated_by"],
				$row["updated_at"]
			);
		}
		$subTotalCellValueArray = [];
		$toColumn = 'H';
		$excelFilterData = array(
			'file_name' => $fileName,
			'sheet_name' => $sheetName,
			'excel_header_name' => $excelHeaderName,
			'data_row' => $dataRows,
			'sub_total_cell_value_array' => $subTotalCellValueArray,
			'to_column' => $toColumn,
			'skip_header' => false,
			'ignore_currency_symbols_sub_total_cell_value_array' => array(),
			'row_cell_currency_format' => array()
		);
		//excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
		excelExport($excelFilterData);
	}

public function organicWasteRecordPdf()
{
	if(!$this->dt_ci_acl->checkAccess('OrganicWasteRecord|pdf')){
		return show_error(NO_ACCESS_SECTION);
	} else {
		$societyData = $this->society_model->getSocietyData(array(
			"society_id" => $this->session->get('society_id'),
		));
		$data['society_data'] = $societyData;
		$filterData = array(
			'is_multiple' => 1,
			'society_id' => $this->session->get('society_id'),
		);
		$dateArray = explode(" - ",$_GET['filter_record_date']);
		$startDate = $dateArray[0];
		$endDate = $dateArray[1];
		// if(!empty($_GET['filter_record_date'])){
		// } else {
		// 	$dateArray = explode(" - ",LAST_MONTH_DMY);
		// }
		// printArray($_GET,1);
		// printArray($dateArray,1);
		if (!empty($startDate)) {
			$filterData['start_date'] = DMYToYMD($startDate);
		}
		if (!empty($endDate)) {
			$filterData['end_date'] = DMYToYMD($endDate);
		}
		// $recordData = $this->getOrganicWasteRecordListing(true, $_GET);
		$recordData = $this->organic_waste_record_model->getOrganicWasteRecordData($filterData);
		
		$data['organic_waste_record_data'] = $recordData;
		$data['start_date'] = $startDate;
		$data['end_date'] = $endDate;
		$data['name'] = lang("OrganicWasteRecord.organic_waste_record"). ".pdf";
		$printHeader = '';
		$printFooter = '';
		$printFooter = pdfFooter( 0, array());
		$html = view('Admin/OrganicWasteRecord/Pdf/OrganicWasteRecordPdfView', $data);
		generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
	}
}

}
