<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\ManagementCommitteeResponsibilitiesModel;
class ManagementCommitteeResponsibilities extends BaseController
{
    protected $management_committee_responsibilities_model;
    public function __construct() {
        $this->management_committee_responsibilities_model = new ManagementCommitteeResponsibilitiesModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/ckeditor/ckeditor_classic.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",          
        );
        $data['title'] = 'Management Committee Responsibilities';
        $data['management_committee_responsibilities_modal_view'] = view('Admin/ManagementCommitteeResponsibilities/ManagementCommitteeResponsibilitiesModalView', $data);
        return $this->dt_ci_template->load("Admin","ManagementCommitteeResponsibilities/ManagementCommitteeResponsibilitiesView",$data);
    }

    public function getManagementCommitteeResponsibilitiesListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_management_committee_responsibilities	 as tm");
        $this->datatables->select("tm.management_committee_responsibilities_id, tm.management_committee_responsibilities_name, tm.is_active,tm.description");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tm.created_at,tm.updated_at");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tm.updated_by AND tupdate.society_id = tm.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tm.created_by AND tcreate.society_id = tm.society_id","left");
        $this->datatables->groupBy("tm.management_committee_responsibilities_id");

        accessFilter($this->datatables, array("society" => "tm.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "management_committee_responsibilities_id" => isset($displayData['management_committee_responsibilities_id']) ? $displayData['management_committee_responsibilities_id'] : "",
                );
                $data[$key]['action_button'] = managementCommitteeResponsibilitiesActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function addEdit()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $managementCommitteeResponsibilitiesId = $this->request->getVar('management_committee_responsibilities_id');
        $managementCommitteeResponsibilitiesName = $this->request->getVar('management_committee_responsibilities_name');
        $description = $this->request->getVar('description');
        $isActive = $this->request->getVar('is_active');

        if (isset($managementCommitteeResponsibilitiesId) && $managementCommitteeResponsibilitiesId == '') {
			$validation->setRule('management_committee_responsibilities_name', lang('ManagementCommitteeResponsibilities.responsibilities_name'), 'required|combination_unique[tbl_management_committee_responsibilities.management_committee_responsibilities_name.'.$this->session->get('society_id').'.]',array('combination_unique' => 'This {field} Already Exists'));
        } else {
			$validation->setRule('management_committee_responsibilities_name', lang('ManagementCommitteeResponsibilities.responsibilities_name'), 'required|edit_unique[tbl_management_committee_responsibilities.management_committee_responsibilities_name.' . $managementCommitteeResponsibilitiesId . '.'. $this->session->get('society_id').']',array('edit_unique' => 'This {field} Already Exists'));
        }

        // $validation->setRule('management_committee_responsibilities_name', lang('ManagementCommitteeResponsibilities.management_committee_responsibilities_name'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
            $managementCommitteeResponsibilitiesNameUpdateArray = array();
            $managementCommitteeResponsibilitiesNameArray = array(
                'management_committee_responsibilities_id' => $managementCommitteeResponsibilitiesId,
                'management_committee_responsibilities_name' => $managementCommitteeResponsibilitiesName,
                'description' => $description,
                'society_id' => $this->session->get('society_id'),
                'is_active' => isset($isActive) ? 1 : 0,
            );
            if(!empty($managementCommitteeResponsibilitiesId)){
                $managementCommitteeResponsibilitiesNameUpdateData = $this->management_committee_responsibilities_model->getManagementCommitteeResponsibilitiesData(array(
                    'management_committee_responsibilities_id' => $managementCommitteeResponsibilitiesId,
                ));
                $managementCommitteeResponsibilitiesNameUpdateArray = compareArray($managementCommitteeResponsibilitiesNameArray,$managementCommitteeResponsibilitiesNameUpdateData);
            }
            $managementCommitteeResponsibilitiesNameData = $this->management_committee_responsibilities_model->insertUpdateRecord($managementCommitteeResponsibilitiesNameArray,'management_committee_responsibilities_id','tbl_management_committee_responsibilities', 1,'',array(),array(),$managementCommitteeResponsibilitiesNameUpdateArray);
            $transactionStatus = $this->db->transComplete();
            if (isset($managementCommitteeResponsibilitiesId) && $managementCommitteeResponsibilitiesId != '') {
                if (($managementCommitteeResponsibilitiesNameData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('ManagementCommitteeResponsibilities.mcr'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('ManagementCommitteeResponsibilities.mcr'));
                }
            } else {
                if (($managementCommitteeResponsibilitiesNameData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('ManagementCommitteeResponsibilities.mcr'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('ManagementCommitteeResponsibilities.mcr'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $managementCommitteeResponsibilitiesId = $this->request->getVar('management_committee_responsibilities_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->management_committee_responsibilities_model->statusChange($managementCommitteeResponsibilitiesId,$status,'management_committee_responsibilities_id','tbl_management_committee_responsibilities');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('ManagementCommitteeResponsibilities.mcr'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('ManagementCommitteeResponsibilities.mcr'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $managementCommitteeResponsibilitiesId = $this->request->getVar('management_committee_responsibilities_id');
        if( isReferenceInTable('management_committee_responsibilities_id', 'tbl_management_committee', $managementCommitteeResponsibilitiesId)   
        ) {

            if (!empty($managementCommitteeResponsibilitiesId)) {
                foreach ($managementCommitteeResponsibilitiesId as $mcr) {
                    $deleteDataArray['module'] = 'Management Committee Responsibilities';
                    $deleteDataArray['activity'] = "Tried to delete Management Committee Responsibilities";
                    $deleteDataArray['module_id'] = $mcr;
                    logActivity('Tried to delete Management Committee Responsibilities [ManagementCommitteeResponsibilitiesID: ' . $mcr . ']', $this->data['userId'], 'ManagementCommitteeResponsibilities', $mcr, json_encode($deleteDataArray), '', 'ManagementCommitteeResponsibilities', $mcr);
                }
            }

            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }
        $managementCommitteeResponsibilitiesNameData = $this->management_committee_responsibilities_model->deleteRecord($managementCommitteeResponsibilitiesId);
        $transactionStatus = $this->db->transComplete();
        if (($managementCommitteeResponsibilitiesNameData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('ManagementCommitteeResponsibilities.mcr'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('ManagementCommitteeResponsibilities.mcr'));
        }
        echo json_encode($response);
        exit;
    }

    public function getManagementCommitteeResponsibilitiesDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $managementCommitteeResponsibilitiesId = $this->request->getVar('management_committee_responsibilities_id');
        $societyId = $this->request->getVar('society_id');
        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'management_committee_responsibilities_id' => $managementCommitteeResponsibilitiesId,
            'society_id' => $this->session->get('society_id'),

        );
        echo $this->management_committee_responsibilities_model->getManagementCommitteeResponsibilities($filterData);
    }

    public function excelExportManagementCommitteeResponsibilities()
    {
        $fileName ='Responsibilities-' . DATETIMEFORMAT;
        $sheetName = 'MCR-' . DATEFORMAT;
        $excelHeaderName = 'Responsibilities';
        $tableData = $this->getManagementCommitteeResponsibilitiesListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('ManagementCommitteeResponsibilities.mcr_name'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["management_committee_responsibilities_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'C';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }
}
