<?php
namespace App\Controllers\Admin;
use App\Models\CommonWebServiceModel;
use CodeIgniter\Controller;
use App\Models\LedgerModel;
use App\Models\DocumentModel;
class Ledger extends BaseController
{
    protected $ledger_model;
    public function __construct() {
        $this->ledger_model = new LedgerModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
		$data['title'] = 'Ledger';
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
		$this->dt_ci_template->load("Admin","Ledger/LedgerView",$data);
	}

	public function manage($ledgerId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
        );

        if ($ledgerId != '') {
			$filterData = array(
				"ledger_id" => $ledgerId
			);
			$data['ledger_data'] = $this->ledger_model->getLedgerData($filterData);

			if (empty($data['ledger_data'])) {
                return redirect()->to('Admin/Ledger');
            }

		   	$ledgerSubLedgerData = $this->ledger_model->getLedgerSubLedgerData(array(
				'ledger_id' => $ledgerId,
				'is_multiple' => 1
			));
			$data['ledger_sub_data'] = $ledgerSubLedgerData;
		}
		if ($ledgerId != '') {
			$data['title'] = 'Edit Ledger';
		} else {
			$data['title'] = 'Add Ledger';
		}

		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
		if ((isset($data['ledger_data']['society_id']) && $data['ledger_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Ledger');
        }
		$this->dt_ci_template->load("Admin","Ledger/LedgerManageView",$data);
	}

    public function getLedgerListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}

        $this->datatables->table("tbl_ledger as ts");
		$this->datatables->select("ts.ledger_id,ts.ledger_name,ts.ledger_code,tsoc.society_name");
		$this->datatables->select("ts.is_active,concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,ts.updated_at");
		$this->datatables->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = ts.society_id","left");
		$this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = ts.updated_by AND tupdate.society_id = ts.society_id","left");
		$this->datatables->groupBy("ts.ledger_id");
		accessFilter($this->datatables, array("society" => "ts.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"ledger_id" => isset($data[$key]['ledger_id']) ? $data[$key]['ledger_id'] : ""
				);
				$data[$key]['action_button'] = ledgerActionButton($actionButtonFilter);
				$data[$key]['updated_at'] = isValidDate($data[$key]['updated_at']) ? siteDateFormat($data[$key]['updated_at'],true) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $ledgerId = $this->request->getVar('ledger_id');
        $status = $this->request->getVar('status');
        $return = $this->ledger_model->statusChange($ledgerId,$status,'ledger_id','tbl_ledger');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Ledger.ledger'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Ledger.ledger'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
//        printArray($_POST,1);
		$this->db->transBegin();
		$validation = \Config\Services::validation();
		$ledgerId = $this->request->getVar('ledger_id');
		$ledgerCode = $this->request->getVar('ledger_code');
		$ledgerName = $this->request->getVar('ledger_name');
		$ledgerType = $this->request->getVar('ledger_type');
		$isActive = $this->request->getVar('is_active');

		if (isset($ledgerId) && $ledgerId == '') {
			$validation->setRule('ledger_code', lang('Ledger.ledger_code'), 'required|combination_unique[tbl_ledger.ledger_code.'.$this->session->get('society_id').'.]',array('combination_unique' => 'This {field} Already Exists'));
        } else {
			$validation->setRule('ledger_code', lang('Ledger.ledger_code'), 'required|edit_unique[tbl_ledger.ledger_code.' . $ledgerId . '.'. $this->session->get('society_id').']',array('edit_unique' => 'This {field} Already Exists'));
        }
		
		// $validation->setRule('ledger_code', lang('Ledger.ledger_code'), 'required');
		$validation->setRule('ledger_name', lang('Ledger.ledger_name'), 'required');
		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

			$ledgerUpdateArray = array();
			$ledgerArray = array(
				'ledger_id' => $ledgerId,
				'ledger_code' => $ledgerCode,
				'ledger_name' => $ledgerName,
				'ledger_type' => $ledgerType,
				'society_id' => $this->session->get('society_id'),
				'is_active' => isset($isActive) ? 1 : 0,
			);

			if(!empty($ledgerId)){
                $ledgerUpdateData = $this->ledger_model->getLedgerData(array(
                    'ledger_id' => $ledgerId,
                ));
                $ledgerUpdateArray = compareArray($ledgerArray,$ledgerUpdateData);
            }

			$ledgerData = $this->ledger_model->insertUpdateRecord($ledgerArray, 'ledger_id', 'tbl_ledger', 1,'',array(),array(),$ledgerUpdateArray);
			$lastLedgerId = $ledgerData['lastInsertedId'];

			$ledgerSubLedgerData = array();
            if(!empty($ledgerId)) {
                $ledgerSubLedgerData = $this->ledger_model->getLedgerSubLedgerData(array(
                    'ledger_id' => $ledgerId,
                    'is_multiple' => 1
                ));
            }

			$subLedgerIdArray = $this->request->getVar('sub_ledger_id[]');
            if(isset($ledgerId) && $ledgerId != ''){
                $this->ledger_model->deleteSubLedgerRecord($ledgerId);
            }
            if(isset($subLedgerIdArray)&& $subLedgerIdArray != ''){
                $ledgerSubLedgerArray = array();
                foreach($subLedgerIdArray as $subLedgerId){
                    $ledgerSubLedgerArray[] = array(
                        'ledger_sub_ledger_id' => '',
                        'ledger_id' => $lastLedgerId,
                        'sub_ledger_id' => $subLedgerId,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId']
                    );
                }
                $ledgerSocietyExtraDataArray = array();
                $ledgerSocietyExtraDataArray['module_id'] = $lastLedgerId;
                $ledgerSocietyExtraDataArray['module'] = 'Ledger Sub Ledger';
                $ledgerSocietyExtraDataArray['type'] = 'Ledger';
                $ledgerSocietyExtraDataArray['old_data'] = $ledgerSubLedgerData;
                $ledgerSocietyExtraDataArray['user_id'] = $this->data['userId'];
                $ledgerSocietyExtraDataArray['society_id'] = $this->session->get('society_id');

                if(!empty($ledgerSubLedgerArray)){
                    $this->ledger_model->batchInsert($ledgerSubLedgerArray,'tbl_ledger_sub_ledger',$ledgerSocietyExtraDataArray);
                }
            }

			if (isset($ledgerId) && $ledgerId != '') {
				if ($ledgerData['success']) {
					$this->db->transCommit();
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Ledger.ledger"));
				} else {
					$this->db->transRollback();
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Ledger.ledger"));
				}
			} else {
				if ($ledgerData['success']) {
					$this->db->transCommit();
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Ledger.ledger"));
				} else {
					$this->db->transRollback();
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Ledger.ledger"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
        $ledgerId = $this->request->getVar('ledger_id');
         if( isReferenceInTable( 'ledger_id','tbl_ledger_sub_ledger', $ledgerId) ||
         	isReferenceInTable( 'ledger_id','tbl_budget_sub_ledger', $ledgerId)){
			 if(!empty($ledgerId)){
			 	foreach($ledgerId as $documentElement){
			 		$deleteDataArray['module'] = 'Ledger';
			 		$deleteDataArray['activity'] = "Tried to Delete Ledger ";
			 		$deleteDataArray['module_id'] = $documentElement;
			 		logActivity('Tried to delete Ledger [LedgerID: ' . $documentElement . ']',$this->data['userId'],'Ledger',$documentElement,json_encode($deleteDataArray),'','Ledger',$documentElement);
			 	}
			 }
             $response['success'] = false;
             $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
             echo json_encode($response);
             exit;
         }

        $ledgerData = $this->ledger_model->deleteRecord($ledgerId);
        $ledgerGuardData = $this->ledger_model->deleteSubLedgerRecord($ledgerId);
        $transactionStatus = $this->db->transComplete();
        if (($ledgerData) && ($transactionStatus == 1)) {
            $this->db->transCommit();
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Ledger.ledger"));
        } else {
            $this->db->transRollback();
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Ledger.ledger"));
        }
        echo json_encode($response);
        exit;
    }

    public function getLedgerDd(){
    	$filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $ledgerId = $this->request->getVar('ledger_id');
        $societyId = $this->request->getVar('society_id');
        $filterData = array(
            'ledger_id' => $ledgerId,
            'society_id' => $this->session->get('society_id'),
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'is_active' => 1,
            'limit' => DATA_LIMIT
        );

        echo $this->ledger_model->getLedger($filterData);
    }

	public function excelExportLedger()
	{
		$fileName ='ledger-' . DATETIMEFORMAT;
		$sheetName = 'Ledger-' . DATEFORMAT;
		$excelHeaderName = 'Ledger';
		$tableData = $this->getLedgerListing(true, $_GET);
		$dataRows = array();
		$dataRows[] = array(
			lang('Ledger.ledger_type'),
			lang('Ledger.ledger_name'),
			lang('Ledger.father_name'),
			lang('Ledger.date_of_birth'),
			lang('Ledger.gender'),
			lang('Ledger.work'),
			lang('Ledger.contact_no'),
			lang('Ledger.present_address'),
			lang('Ledger.permanent_address'),
			lang('Ledger.reference'),
			lang('CommonMessage.common_updated_by'),
			lang('common_updated_at')
		);
		foreach ($tableData as $row) {
			$dataRows[] = array(
				$row["ledger_type"],
				$row["ledger_name"],
				$row["father_name"],
				$row["date_of_birth"],
				$row["gender"],
				$row["work"],
				$row["contact_no"],
				$row["present_address"],
				$row["permanent_address"],
				$row["reference"],
				$row["updated_by"],
				$row["updated_at"]
			);
		}
		$subTotalCellValueArray = [];
		$toColumn = 'L';
		$excelFilterData = array(
			'file_name' => $fileName,
			'sheet_name' => $sheetName,
			'excel_header_name' => $excelHeaderName,
			'data_row' => $dataRows,
			'sub_total_cell_value_array' => $subTotalCellValueArray,
			'to_column' => $toColumn,
			'skip_header' => false,
			'ignore_currency_symbols_sub_total_cell_value_array' => array(),
			'row_cell_currency_format' => array()
		);
		//excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
		excelExport($excelFilterData);
	}


}
