<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\ItemModel;
class Item extends BaseController
{
    protected $item_model;
    public function __construct() {
        $this->item_model = new ItemModel();
        // checkAndCreatePath(THUMBNAIL_ITEM_IMAGE_PATH);
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Item';
        $dataFilters['filters'] = array(
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "itemDd",
                "id" => "filter_item_id",
                "name" => "filter_item_id",
                "title" => "Item.item",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "commonAreaDd",
                "id" => "filter_common_area_id",
                "name" => "filter_common_area_id",
                "title" => "Item.common_area",
            ),
            array(
                "type" => "multi_select",
                "dynamic" => true,
                "class" => "manufacturerDd",
                "id" => "filter_manufacturer_id",
                "name" => "filter_manufacturer_id",
                "title" => "Item.manufacturer",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );

        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());    
        return $this->dt_ci_template->load("Admin","Item/ItemView",$data);
    }

    public function getItemListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");
        $commonAreaId = $this->request->getVar("filter_common_area_id");
        $manufacturerId = $this->request->getVar("filter_manufacturer_id");
        $itemId = $this->request->getVar("filter_item_id");
        
        $this->datatables->table("tbl_item as ti");
        $this->datatables->select("ti.item_id,ti.item_name,ti.is_active,ti.item_description,ti.batch_no,ti.serial_no,ti.warranty_period_from,ti.warranty_period_to");
        $this->datatables->select("ts.society_name,COALESCE(tm.manufacturer_name,'') as manufacturer_name,COALESCE(tca.common_area_name,'') as common_area_name");
        $this->datatables->select("ti.updated_at,concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");

        $this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = ti.society_id","left");
        $this->datatables->join("tbl_manufacturer as tm","tm.manufacturer_id = ti.manufacturer_id","left");
        $this->datatables->join("tbl_common_area as tca","tca.common_area_id = ti.common_area_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = ti.updated_by AND tupdate.society_id = ti.society_id","left");
        $this->datatables->groupBy("ti.item_id");

        if(isset($commonAreaId)) {
            if(is_array($commonAreaId)){
                $this->datatables->whereIn("ti.common_area_id",$commonAreaId);
            } else {
                $this->datatables->where("ti.common_area_id",$commonAreaId);
            }
        }

        if(isset($itemId)) {
            if(is_array($itemId)){
                $this->datatables->whereIn("ti.item_id",$itemId);
            } else {
                $this->datatables->where("ti.item_id",$itemId);
            }
        }

        if(isset($manufacturerId)) {
            if(is_array($manufacturerId)){
                $this->datatables->whereIn("ti.manufacturer_id",$manufacturerId);
            } else {
                $this->datatables->where("ti.manufacturer_id",$manufacturerId);
            }
        }

        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(ti.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(ti.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(ti.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(ti.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(ti.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(ti.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

        accessFilter($this->datatables, array("society" => "ti.society_id"));

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "item_id" => isset($displayData['item_id']) ? $displayData['item_id'] : ""
                );
                $data[$key]['action_button'] = itemActionButton($actionButtonFilter);
                $data[$key]['warranty_period_from'] = siteDateFormat($displayData['warranty_period_from']);
                $data[$key]['warranty_period_to'] = siteDateFormat($displayData['warranty_period_to']);
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }

    public function manage($itemId = '')
    {

        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );

        if ($itemId != '') {
            $filterData = array(
                "item_id" => $itemId
            );
            $data['item_data'] = $this->item_model->getItemData($filterData);

            if (empty($data['item_data'])) {
                return redirect()->to('Admin/Item');
            }

            $data['image_data'] = $this->item_model->getItemImageData(array(
               "item_id" => $itemId,
               "is_multiple" => 1
           ));
        }
        if ($itemId != '') {
            $data['title'] = 'Edit Item';
        } else {
            $data['title'] = 'Add Item';
        }
        if ((isset($data['item_data']['society_id']) && $data['item_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Item');
        }
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $this->dt_ci_template->load("Admin","Item/ItemManageView",$data);
    }
    public function save()
    {
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $itemId = $this->request->getVar('item_id');
        $itemName = $this->request->getVar('item_name');
        $itemDescription = $this->request->getVar('item_description');
        $batchNo = $this->request->getVar('batch_no');
        $serialNo = $this->request->getVar('serial_no');
        $commonAreaId = $this->request->getVar('common_area_id');
        $manufacturerId = $this->request->getVar('manufacturer_id');
        $warrantyPeriodFrom = $this->request->getVar('warranty_period_from');
        $warrantyPeriodTo = $this->request->getVar('warranty_period_to');
        $remarks = $this->request->getVar('remarks');
        $isActive = $this->request->getVar('is_active');

        if (isset($itemId) && $itemId == '') {
            $validation->setRule('item_name', lang('Item.item_name'), 'required|combination_unique[tbl_item.item_name.'.$this->session->get('society_id').'.]',array('combination_unique' => 'This {field} Already Exists'));
        } else {
            $validation->setRule('item_name', lang('Item.item_name'), 'required|edit_unique[tbl_item.item_name.' . $itemId . '.'. $this->session->get('society_id').']',array('edit_unique' => 'This {field} Already Exists'));
        }
       $validation->setRule('item_description', lang('Item.item_description'), 'required');
       $validation->setRule('common_area_id', lang('Item.common_area'), 'required');
       $validation->setRule('manufacturer_id', lang('Item.mak'), 'required');
       $validation->setRule('warranty_period_from', lang('Item.warranty_period_from'), 'required');
       $validation->setRule('warranty_period_to', lang('Item.warranty_period_to'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            if (strtotime($warrantyPeriodFrom) > strtotime($warrantyPeriodTo)){
                $response['success'] = false;
                $response['msg'] = lang('Item.item_warranty_period_from_date_to_date_message');
                echo json_encode($response);
                exit;
            }

            $itemImage = array();
            if (isset($_FILES["item_image"])) {
                $itemImagePath = ITEM_IMAGE_PATH;
                $itemImage = $this->dt_ci_file_upload->UploadMultipleFile('item_image', MAX_IMAGE_SIZE_LIMIT, $itemImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
                if ($itemImage['success'] == false) {
                    $response['success'] = false;
                    $response['msg'] = strip_tags($itemImage['message']);
                    echo json_encode($response);
                    die();
                }
                else{
                    unset($itemImage['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($itemImage, ITEM_IMAGE_PATH, THUMBNAIL_ITEM_IMAGE_PATH);
                }
            }

            $itemUpdateArray = array();
            $itemArray = array(
                'item_id' => $itemId,
                'item_name' => $itemName,
                'item_description' => $itemDescription,
                'society_id' => $this->session->get('society_id'),
                'batch_no' => $batchNo,
                'serial_no' => $serialNo,
                'common_area_id' => $commonAreaId,
                'manufacturer_id' => $manufacturerId,
                'warranty_period_from' => DMYToYMD($warrantyPeriodFrom),
                'warranty_period_to' => DMYToYMD($warrantyPeriodTo),
                'remarks' => $remarks,
                'is_active' => isset($isActive) ? 1 : 0,
            );

            if(!empty($itemId)){
                $itemUpdateData = $this->item_model->getItemData(array(
                    'item_id' => $itemId,
                ));
                $itemUpdateArray = compareArray($itemArray,$itemUpdateData);
            }

            $itemData = $this->item_model->insertUpdateRecord($itemArray,'item_id','tbl_item', 1,'',array(),array(),$itemUpdateArray);

            $lastItemId = $itemData['lastInsertedId'];

            if($lastItemId != ''){
                if(isset($itemImage) && count($itemImage) > 0){
                    $batchArray = array();
                    unset($itemImage['success']);
                    foreach ($itemImage as $key => $imageData) {
                        $dataArray = array(
                            'item_image_id' =>   '',
                            'item_id' => $lastItemId,
                            'item_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                        );
                        array_push($batchArray, $dataArray);
                    }

                    $itemImageExtraDataArray = array();
                    $itemImageExtraDataArray['module_id'] = $lastItemId;
                    $itemImageExtraDataArray['module'] = 'Item Image';
                    $itemImageExtraDataArray['type'] = 'Item';
                    $itemImageExtraDataArray['old_data'] = array();
                    $itemImageExtraDataArray['user_id'] = $this->data['userId'];
                    $itemImageExtraDataArray['society_id'] = $this->session->get('society_id');

                    $this->item_model->batchInsert($batchArray, 'tbl_item_image',$itemImageExtraDataArray);
                }
            }
            $transactionStatus = $this->db->transComplete();
            if (isset($itemId) && $itemId != '') {
                if (($itemData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Item.item'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Item.item'));
                }
            } else {
                if (($itemData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Item.item'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Item.item'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $itemId = $this->request->getVar('item_id');
        $status = $this->request->getVar('status');

        $return = $this->item_model->statusChange($itemId,$status,'item_id','tbl_item');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Item.item'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Item.item'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
        $this->db->transStart();
        $itemId = $this->request->getVar('item_id');
       if( isReferenceInTable( 'item_id','tbl_material_item', $itemId) ||
           isReferenceInTable( 'item_id','tbl_warranty', $itemId)){
           if(!empty($itemId)){
               foreach($itemId as $item){
                   $deleteDataArray['module'] = 'Item';
                   $deleteDataArray['activity'] = "Tried to delete Item ";
                   $deleteDataArray['module_id'] = $item;
                   logActivity('Tried to delete Item [ItemID: ' . $item . ']',$this->data['userId'],'Item',$item,json_encode($deleteDataArray),'','Item',$item);
               }
           }
           $response['success'] = false;
           $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
           echo json_encode($response);
           exit;
       }

        $itemImageData = $this->item_model->getItemImageData(array(
            "item_id" => $itemId,
            "is_multiple" => 1
        ));
        if(is_array($itemImageData) && !empty($itemImageData)){
            foreach ($itemImageData as $image){
                $FileUrl = '';
                if(isset($image['item_image']) && $image['item_image'] != '') {
                    $FileUrl = ITEM_IMAGE_PATH . $image['item_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }

                $thumbnailFileUrl = '';
                if(isset($image['item_image']) && $image['item_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_ITEM_IMAGE_PATH . $image['item_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                }
            }
        }
        $itemData  = $this->item_model->deleteRecord($itemId);
        $transactionStatus = $this->db->transComplete();
        if (($itemData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Item.item'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Item.item'));
        }
        echo json_encode($response);
        exit;
    }

    public function getItemDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $itemId = $this->request->getVar('item_id');


        $filterData = array(
            'item_id' => $itemId,
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,

        );
        echo $this->item_model->getItem($filterData);
    }

    public function view($id = null)
    {
        $itemId = $this->request->getVar("view_id");
        if($itemId == "" && $itemId == null){
            return redirect()->to('Admin/Item');
        }
        else {
            $id = $itemId;
            $filterData = array(
                "item_id" => $itemId
            );
            $data['item_data'] = $this->item_model->getItemData($filterData);
            $data['image_data'] = $this->item_model->getItemImageData(array(
               "item_id" => $itemId,
               "is_multiple" => 1
           ));
            $flatView = view("Admin/Item/ItemModelView", $data);
            $response['view_title'] = "Item Details";
            $response['view_detail'] = $flatView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function excelExportItem()
    {
        $fileName ='item-' . DATETIMEFORMAT;
        $sheetName = 'Item-' . DATEFORMAT;
        $excelHeaderName = 'Item';
        $tableData = $this->getItemListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Item.item_name'),
            lang('Item.manufacturer'),
            lang('Item.common_area'),
            lang('Item.batch_no'),
            lang('Item.serial_no'),
            lang('Item.warranty_period_from'),
            lang('Item.warranty_period_to'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["item_name"],
                $row["manufacturer_name"],
                $row["common_area_name"],
                $row["batch_no"],
                $row["serial_no"],
                $row["warranty_period_from"],
                $row["warranty_period_to"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'I';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function deleteItemImage()
    {
        $this->db->transStart();
        $itemImageId = $this->request->getVar('item_image_id');
        $itemId = $this->request->getVar('item_id');
        $imageData = $this->item_model->getItemImageData(array(
            "item_image_id" => $itemImageId,
            "is_multiple" => 1
        ));
        if(is_array($imageData) && !empty($imageData)){
            foreach ($imageData as $image){
                $FileUrl = '';
                if(isset($image['item_image']) && $image['item_image'] != '') {
                    $FileUrl = ITEM_IMAGE_PATH . $image['item_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                }

                $thumbnailFileUrl = '';
                if(isset($image['item_image']) && $image['item_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_ITEM_IMAGE_PATH . $image['item_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                } 
            }
        }
        //delete setting location
        $imageData = $this->item_model->deleteItemImage($itemImageId);      
        if ($imageData) {
            $ids = is_array($itemImageId) ? implode(',',$itemImageId) : $itemImageId;
            $deleteDataArray['module'] = 'Item Image';
            $deleteDataArray['activity'] = "Item Image Deleted";
            $deleteDataArray['module_id'] = $itemImageId;
            logActivity('Item Image Deleted [ItemImageID: ' . $ids . ']',$this->data['userId'],'Item Image',$ids,json_encode($deleteDataArray),'','Item',$itemId);
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Item.item_image'));
            }
            else{
                $response['success'] = false;
                $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Item.item_image'));  
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Item.item_image'));
        }
        echo json_encode($response);
        exit();
    }
}
