<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\InvoiceModel;
use App\Models\CommonWebServiceModel;
use App\Models\OwnershipFlatModel;
use App\Models\RentalsModel;
use App\Models\SocietyModel;
use App\Models\TaxModel;

class Invoice extends BaseController
{
    protected $invoice_model;
    public function __construct() {
        $this->invoice_model = new InvoiceModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        $this->ownership_flat_model = new OwnershipFlatModel();
        $this->rentals_model = new RentalsModel();
        $this->society_model = new SocietyModel();
        $this->tax_model = new TaxModel();
    }

    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Invoice';
        $dataFilters['filters'] = array(
            array(
                "type" => "daterange",
                "id" => "filter_created_at",
                "name" => "filter_created_at",
                "title" => "CommonMessage.common_created_at",
            ),
            array(
                "type" => "daterange",
                "id" => "filter_updated_at",
                "name" => "filter_updated_at",
                "title" => "CommonMessage.common_updated_at",
            ),
        );
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Invoice/InvoiceView",$data);
    }

    public function manage($invoiceId = '',$view = '')
    {
        $data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "vendor/libs/flatpickr/flatpickr.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
            "vendor/libs/jquery-timepicker/jquery-timepicker.js",
            "vendor/libs/moment/moment.js",
            "vendor/libs/ckeditor/ckeditor_classic.js",
        );

        if ($invoiceId != '') {
            $filterData = array(
                "invoice_id" => $invoiceId
            );
            $data['invoice_data'] = $this->invoice_model->getInvoiceData($filterData);

            $invoiceParticularData = $this->invoice_model->getInvoiceParticularData(array(
                "invoice_id" => $invoiceId,
                "is_multiple" => 1,
            ));
            
            $invoiceParticularTaxData = $this->invoice_model->getInvoiceParticularTaxData(array(
                "invoice_id" => $invoiceId,
                "is_multiple" => 1,
            ));

            // printArray($invoiceParticularData);
            // printArray($invoiceParticularTaxData,1);

            $finalInvoiceParticularData = array();
            if(!empty($invoiceParticularData)){
                foreach ($invoiceParticularData as $pKey => $pValue) {
                    foreach ($invoiceParticularTaxData as $tKey => $tValue) {
                        if($tValue['invoice_particular_id'] == $pValue['invoice_particular_id']){
                            $invoiceParticularData[$pKey]['tax_data'][] = $tValue;
                        }
                    }
                }
            }

            $data['invoice_particular_data'] = $invoiceParticularData;

            // printArray($invoiceParticularData,1);

            if (empty($data['invoice_data'])) {
                return redirect()->to('Admin/Invoice');
            }
        }

        if ($invoiceId != '') {
            $data['title'] = 'Edit Invoice';
        } else {
            $data['title'] = 'Add Invoice';
        }
        if ((isset($data['invoice_data']['society_id']) && $data['invoice_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Invoice');
        }

        $data['invoice_data']['view'] = (isset($view) && $view != '' ? 1 : 0);
        $data['invoice_particular_table'] = view('Admin/Invoice/InvoiceParticularView', isset($data) ? $data : array());
        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $this->dt_ci_template->load("Admin","Invoice/InvoiceManageView",$data);
    }

    public function getInvoiceListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }

        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");

        $societyId = $this->session->get('society_id');

        $this->datatables->table("tbl_invoice as ti");
        $this->datatables->select("ti.invoice_id, ti.prefix,ti.series,ti.invoice_date,ti.due_date,tsoc.society_name,ti.society_id");
        $this->datatables->select("concat(ti.prefix,ti.series) as document_number");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,ti.updated_at");
        $this->datatables->select("concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') ) as flat_no");

        $this->datatables->join("tbl_ownership_flat as towf","towf.ownership_flat_id = ti.ownership_flat_id","left");
        $this->datatables->join("tbl_flat as tf","tf.flat_id = towf.flat_id","left");
        $this->datatables->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = ti.updated_by AND tupdate.society_id = ti.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = ti.society_id","left");
        accessFilter($this->datatables, array("society" => "ti.society_id"));

        if(isset($societyId) && !empty($societyId)) {
            if (is_array($societyId)) {
                $this->datatables->whereIn('ti.society_id', $societyId);
            } else {
                $this->datatables->where('ti.society_id', $societyId);
            }
        }

        if($createdAt != ''){
            list($fromDate,$toDate) = explode(" - ",$createdAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(ti.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(ti.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(ti.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }
        if($updatedAt != ''){
            list($fromDate,$toDate) = explode(" - ",$updatedAt);
            $fromDate = DMYToYMD($fromDate);
            $toDate = DMYToYMD($toDate);
            if(strtotime($fromDate) != strtotime($toDate)){
                $this->datatables->where("date_format(ti.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
                $this->datatables->where("date_format(ti.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
            } else {
                $this->datatables->where("date_format(ti.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
            }
        }

        $this->datatables->groupBy("ti.invoice_id");

        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "invoice_id" => isset($displayData['invoice_id']) ? $displayData['invoice_id'] : "",
                );
                $data[$key]['action_button'] = invoiceActionButton($actionButtonFilter);
                $data[$key]['invoice_date'] = siteDateFormat($displayData['invoice_date']);
                $data[$key]['due_date'] = siteDateFormat($displayData['due_date']);
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function save()
    {
        // printArray($_POST,1);
        $this->db->transStart();
        $validation = \Config\Services::validation();

        $invoiceId = $this->request->getVar('invoice_id');
        $prefix = $this->request->getVar('prefix');
        $series = $this->request->getVar('series');
        $invoiceDate = $this->request->getVar('invoice_date');
        $dueDate = $this->request->getVar('due_date');
        $flatId = $this->request->getVar('ownership_flat_id');
        $name = $this->request->getVar('name');
        $contact = $this->request->getVar('contact');
        $bankAccountId = $this->request->getVar('bank_account_id');
        $bank = $this->request->getVar('bank');
        $branch = $this->request->getVar('branch');
        $ifscCode = $this->request->getVar('ifsc_code');
        $latePaymentCharges = $this->request->getVar('late_payment_charges');
        $taxedLatePaymentCharges = $this->request->getVar('taxed_late_payment_charges');
        $advances = $this->request->getVar('advances');
        $taxedAdvances = $this->request->getVar('taxed_advances');
        $subTotal = $this->request->getVar('sub_total');
        $netPayableAmount = $this->request->getVar('net_payable_amount');
        $totalTaxAmount = $this->request->getVar('total_tax_amount');
        
        // particular
        $invoiceParticularIdArr = $this->request->getVar('invoice_particular_id');
        $particularTaxJsonArr = $this->request->getVar('particular_tax_json');
        $particularArr = $this->request->getVar('particular');
        $periodFromArr = $this->request->getVar('period_from');
        $periodToArr = $this->request->getVar('period_to');
        $sqFtArr = $this->request->getVar('sq_ft');
        $rateArr = $this->request->getVar('rate');
        $amountArr = $this->request->getVar('amount');
        $totalAmountArr = $this->request->getVar('total_amount');

        // tax
        $taxIdArr = $this->request->getVar('tax_id');
        // printArray($taxIdArr,1);

        $validation->setRule('prefix', lang('Invoice.prefix'), 'required');
        $validation->setRule('series', lang('Invoice.series'), 'required');
        $validation->setRule('invoice_date', lang('Invoice.invoice_date'), 'required');
        $validation->setRule('due_date', lang('Invoice.due_date'), 'required');
        $validation->setRule('ownership_flat_id', lang('Invoice.flat_no'), 'required');

        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $invoiceTimeStamp = strtotime($invoiceDate);
            $dueDateTimeStamp = strtotime($dueDate);

            if ($dueDateTimeStamp < $invoiceTimeStamp) {
                $response['success'] = false;
                $response['msg'] = "Due date Can/t Be Earlier Than Or Equal To invoice date ";
                echo json_encode($response);
                exit;
            }
            $societyId = $this->session->get('society_id');
            $nextSeries = 'getNextSeries("invoice", "' . $prefix . '", "' . $societyId . '")';
            $invoiceUpdateArray = array();
            $invoiceArray = array(
                'invoice_id' => $invoiceId,
                'invoice_date' => DMYToYMD($invoiceDate),
                'due_date' => DMYToYMD($dueDate),
                'ownership_flat_id' => $flatId,
                'name' => $name,
                'contact' => $contact,
                'bank_account_id' => $bankAccountId,
                'bank' => $bank,
                'branch' => $branch,
                'ifsc_code' => $ifscCode,
                'late_payment_charges' => $latePaymentCharges,
                'advances' => $advances,
                'taxed_late_payment_charges' => $taxedLatePaymentCharges,
                'taxed_advances' => $taxedAdvances,
                'sub_total' => $subTotal,
                'net_payable_amount' => $netPayableAmount,
                'total_tax_amount' => $totalTaxAmount,
                'society_id' => $societyId,
            );
            if (isset($invoiceId) && $invoiceId == '') {
                $invoiceArray['prefix'] = $prefix;
                $invoiceArray['series'] = $series;
            }

            if(!empty($invoiceId)){
                $invoiceUpdateData = $this->invoice_model->getInvoiceData(array(
                    'invoice_id' => $invoiceId,
                ));
                $invoiceUpdateArray = compareArray($invoiceArray,$invoiceUpdateData);
            }

            $invoiceData = $this->invoice_model->insertUpdateRecord($invoiceArray,'invoice_id','tbl_invoice', 1,'',array("series"),array(),$invoiceUpdateArray);
            $lastInvoiceId = $invoiceData['lastInsertedId'];
            $taxInsertUpdateArr = array();
            if (!empty($invoiceParticularIdArr)) {
                foreach ($invoiceParticularIdArr as $iPkey => $invoiceParticularId) {
                    $particular = array_key_exists($iPkey, $particularArr) ? $particularArr[$iPkey] : '';
                    $particularTaxJson = array_key_exists($iPkey, $particularTaxJsonArr) ? $particularTaxJsonArr[$iPkey] : '';
                    $periodFrom = array_key_exists($iPkey, $periodFromArr) ? $periodFromArr[$iPkey] : '';
                    $periodTo = array_key_exists($iPkey, $periodToArr) ? $periodToArr[$iPkey] : '';
                    $sqFt = array_key_exists($iPkey, $sqFtArr) ? $sqFtArr[$iPkey] : '';
                    $rate = array_key_exists($iPkey, $rateArr) ? $rateArr[$iPkey] : '';
                    $amount = array_key_exists($iPkey, $amountArr) ? $amountArr[$iPkey] : '';
                    $totalAmount = array_key_exists($iPkey, $totalAmountArr) ? $totalAmountArr[$iPkey] : '';

                    $particularTaxArr = array_key_exists($iPkey, $taxIdArr) ? $taxIdArr[$iPkey] : '';
                        
                    $particularInsertUpdateArray = array(
                        'invoice_particular_id' => $invoiceParticularId,
                        'invoice_id' => $lastInvoiceId,
                        'particular' => $particular,
                        'particular_tax_json' => $particularTaxJson,
                        'period_from' => DMYToYMD($periodFrom),
                        'period_to' => DMYToYMD($periodTo),
                        'sq_ft' => $sqFt,
                        'rate' => $rate,
                        'amount' => $amount,
                        'total_amount' => $totalAmount,
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId'],
                        'created_at' => date("Y-m-d H:i:s"),
                        'updated_at' => date("Y-m-d H:i:s"),
                    );
                    $particularUnitInsertUpdateData = $this->invoice_model->insertUpdateRecord($particularInsertUpdateArray, 'invoice_particular_id', 'tbl_invoice_particular', 1,'',array(),array());
                    $invoiceParticularId = $particularUnitInsertUpdateData['lastInsertedId'];

                    
                    if(empty($invoiceId)){
                        $this->invoice_model->deleteParticularTaXId($lastInvoiceId);
                        foreach ($particularTaxArr as $key => $taxId) {
                            $taxInsertUpdateArr[] = array(
                                "invoice_id" => $lastInvoiceId,
                                "invoice_particular_id" => $invoiceParticularId,
                                "tax_id" => $taxId,
                                'created_by' => $this->data['userId'],
                                'updated_by' => $this->data['userId'],
                                'created_at' => date("Y-m-d H:i:s"),
                                'updated_at' => date("Y-m-d H:i:s"),
                            );
                        }
                    }
                }

                // printArray($taxInsertUpdateArr,1);
                if(!empty($taxInsertUpdateArr)){
                    $this->invoice_model->batchInsert($taxInsertUpdateArr,'tbl_invoice_particular_tax',array());
                }
                
            }

            $transactionStatus = $this->db->transComplete();
            if (isset($invoiceId) && $invoiceId != '') {
                if (($invoiceData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Invoice.invoice'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Invoice.invoice'));
                }
            } else {
                if (($invoiceData['success']) && ($transactionStatus == 1)) {

                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Invoice.invoice'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Invoice.invoice'));
                }
            }
            echo json_encode($response);
            exit();
        }

    }

    public function changeStatus()
    {
        $invoiceId = $this->request->getVar('invoice_id');
        $status = $this->request->getVar('status');
        $return = $this->invoice_model->statusChange($invoiceId,$status,'invoice_id','tbl_invoice');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Invoice.amenities'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Invoice.amenities'));
        }
        echo json_encode($response);
        exit();
    }

    public function addInvoiceParticularRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $transactionRow = view('Admin/Invoice/InvoiceParticularRowView', $data);
        echo $transactionRow;
    }

    public function delete()
    {
        $this->db->transStart();
        $invoiceId = $this->request->getVar('invoice_id');
        $ids = is_array($invoiceId) ? implode(',', $invoiceId) : $invoiceId;


        $invoiceData = $this->invoice_model->deleteRecord($invoiceId);
        $transactionStatus = $this->db->transComplete();
        if (($invoiceData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Invoice.invoice'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Invoice.invoice'));
        }
        echo json_encode($response);
        exit;
    }

    public function addAmenitiesUnitRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $unitRow = view('Admin/Invoice/AmenitiesUnitRowView', $data);
        echo $unitRow;
    }

    public function deleteAmenitiesUnitRow()
    {
        $this->db->transStart();

        $amenitiesUnitId  = $this->request->getVar('amenities_unit_id');
        $invoiceId = $this->request->getVar('invoice_id');

        $amenitiesUnitData = $this->invoice_model->deleteAmenitiesUnitRecord($amenitiesUnitId);
        
        if (($amenitiesUnitData)) {
            if(!empty($amenitiesUnitId)){
                foreach($amenitiesUnitId as $documentElement){
                    $deleteDataArray['module'] = 'Invoice Unit';
                    $deleteDataArray['activity'] = "Invoice Unit Deleted";
                    $deleteDataArray['module_id'] = $documentElement;
                    logActivity('Invoice Unit Deleted [AmenitiesUnitID: ' . $documentElement . ']',$this->data['userId'],'Invoice Unit',$documentElement,json_encode($deleteDataArray),'','Invoice',$invoiceId);
                }
            }
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Invoice.amenities_unit'));
            }
            else{
                $response['success'] = false;
                $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Invoice.amenities_unit'));
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Invoice.amenities_unit'));
        }
        echo json_encode($response);
        exit();
    }

    public function getInvoiceDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $invoiceId = $this->request->getVar('invoice_id');

        $filterData = array(
            'invoice_id' => $invoiceId,
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT
        );
        echo $this->invoice_model->getInvoice($filterData);
    }

    public function excelExportInvoice()
    {
        $fileName ='invoice-' . DATETIMEFORMAT;
        $sheetName = 'Invoice-' . DATEFORMAT;
        $excelHeaderName = 'Invoice';
        $tableData = $this->getInvoiceListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Invoice.invoice_number'),
            lang('Invoice.invoice_date'),
            lang('Invoice.due_date'),
            lang('Invoice.flat_no'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                $row["document_number"],
                YMDToDMY($row["invoice_date"]),
                YMDToDMY($row["due_date"]),
                $row["flat_no"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'F';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function view($id = null)
    {
        $invoiceId = $this->request->getVar("view_id");
        if($invoiceId == "" && $invoiceId == null){
            return redirect()->to('Admin/Invoice');
        }
        else {
            $id = $invoiceId;
            $filterData = array(
                "invoice_id" => $invoiceId
            );
            $data['invoice_data'] = $this->invoice_model->getInvoiceData($filterData);

            if (empty($data['invoice_data'])) {
                return redirect()->to('Admin/Invoice');
            }
            
            $invoiceView = view("Admin/Invoice/InvoiceModelView", $data);
            $response['view_title'] = "Invoice Details";
            $response['view_detail'] = $invoiceView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }

    public function getFlatOwnerTableRow()
    {
        $flatId = $this->request->getVar('flat_id');
        $flatOwnerData = $this->rentals_model->getFlatOwnerData(array(
            'flat_id' => $flatId,
            'is_owner' => 1,
            'is_latest' => 1,
            'is_active' => 1,
        ));

        $response['data'] = $flatOwnerData;
        $response['success'] = true;

        echo json_encode($response);
    }

    public function getTaxData()
    {
        $value = $this->request->getVar('value');
        $taxData = $this->tax_model->getTaxData(array(
            'tax_rate' => '18'
        ));

        $value = 0.18 * $value;
        $response['data'] = $taxData;
        if(!empty($taxData)){
            $response['success'] = true;
            $response['taxed_value'] = $value;
        } else {
            $response['success'] = false;
            $response['taxed_value'] = $value;
        }

        echo json_encode($response);
    }

    public function pdf($id = null, $view = null,$save_bufffer = null,$zipPdf = 0){
        $invoiceId = $id;
        $societyId = $this->session->get('society_id');

        $societyData = $this->society_model->getSocietyData(array(
            "society_id" => $societyId
        ));

        $filterData = array(
            "invoice_id" => $invoiceId
        );
        $data['invoice_data'] = $this->invoice_model->getInvoiceData($filterData);

        $invoiceParticularData = $this->invoice_model->getInvoiceParticularData(array(
            "invoice_id" => $invoiceId,
            "is_multiple" => 1,
        ));
            
        $invoiceParticularTaxData = $this->invoice_model->getInvoiceParticularTaxData(array(
            "invoice_id" => $invoiceId,
            "is_multiple" => 1,
        ));

        foreach ($invoiceParticularData as $pKey => $pValue) {
            foreach ($invoiceParticularTaxData as $tKey => $tValue) {
                if($tValue['invoice_particular_id'] == $pValue['invoice_particular_id']){
                    $invoiceParticularData[$pKey]['tax_data'][] = $tValue;
                }
            }
        }


        $data['society_data'] = $societyData;
        $data['invoice_particular_data'] = $invoiceParticularData;

        $data['name'] = lang("Invoice.invoice_pdf_name") . "_" . ".pdf";
        $printHeader = '';
        $printFooter = '';
        // $signatureDetails = array(
        //     "created_by" => isset($voucher['created_by']) ? $voucher['created_by'] : "",
        //     "approved_by" =>  "",
        //     "document_number" => isset($voucher['flat_no'])  ? lang("Voucher.voucher")."# ".$voucher['flat_no']  : "",
        //     "document_date" => isset($voucher['created_at']) ? siteDateFormat($voucher['created_at']) : "",
        //     "print_for" => "Voucher",
        // );
        // if (isset($voucher['voucher_id'])) {
        //     $printFooter = pdfFooter( 1, $signatureDetails);
        // }
        $html = view('Admin/Invoice/pdf/InvoicePdfView', $data);
        
        // echo($html);
        // die();
        generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
    }
}
