<?php
namespace App\Controllers\Admin;
use App\Models\SocietyModel;
use CodeIgniter\Controller;
use App\Models\IntercomModel;
use App\Models\TowerModel;
class Intercom extends BaseController
{
    protected $intercom_model;
    protected $society_model;
    public function __construct() {
        $this->intercom_model = new IntercomModel();
        $this->society_model = new SocietyModel();
        $this->tower_model = new TowerModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
        $data['title'] = 'Intercom';
        $dataFilters['filters'] = array(
			array(
				"type" => "intercom_type",
				"id" => "intercom_type",
				"name" => "intercom_type",
				"title" => "Intercom.intercom_type",
			),
			array(
				"type" => "multi_select",
				"dynamic" => true,
				"class" => "intercomTypeDd",
				"id" => "filter_intercom_type_id",
				"name" => "filter_intercom_type_id",
				"title" => "Intercom.intercom_type_name",
			),
			array(
				"type" => "daterange",
				"id" => "filter_created_at",
				"name" => "filter_created_at",
				"title" => "CommonMessage.common_created_at",
			),
			array(
				"type" => "daterange",
				"id" => "filter_updated_at",
				"name" => "filter_updated_at",
				"title" => "CommonMessage.common_updated_at",
			),
		);
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
        $data['advance_filter'] = view('Admin/CommonMaster/FilterModalView', isset($dataFilters) ? $dataFilters : array());
        return $this->dt_ci_template->load("Admin","Intercom/IntercomView",$data);
    }

    public function getIntercomListing($return = false ,$filterData = array())
    {
        if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        
        $intercomType = $this->request->getVar("intercom_type");
        $intercomTypeId = $this->request->getVar("filter_intercom_type_id");
        $createdAt = $this->request->getVar("filter_created_at");
        $updatedAt = $this->request->getVar("filter_updated_at");

        $this->datatables->table("tbl_intercom as ti");

        $this->datatables->select("ti.intercom_id,ts.society_name,ts.society_name,ti.is_active,ti.intercom_type,ti.number");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,ti.updated_at,ti.flat_id,ti.particulares");
		$this->datatables->select("(CASE 
								WHEN  
									ti.intercom_type ='flat' THEN concat(COALESCE(tt.tower_name,''),'-',COALESCE(tf.flat_no,'') )
								WHEN
									ti.intercom_type ='common_area' THEN tca.common_area_name	
							END) as intercom_type_name");
		
		$this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = ti.society_id","left");
		$this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = ti.updated_by AND tupdate.society_id = ti.society_id","left");
        $this->datatables->join("tbl_flat as tf","tf.flat_id = ti.flat_id AND ti.intercom_type='flat'","left");
		$this->datatables->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		
		$this->datatables->join("tbl_common_area as tca","tca.common_area_id = ti.common_area_id AND ti.intercom_type='common_area'","left");

		if (isset($intercomType) && !empty($intercomType)) {
			$this->datatables->where("ti.intercom_type", $intercomType);
		}

		if($intercomType == 'flat'){
			if (isset($intercomTypeId) && !empty($intercomTypeId)) {
				if (is_array($intercomTypeId)) {
					$this->datatables->whereIn("ti.flat_id", $intercomTypeId);
				} else {
					$this->datatables->where("ti.flat_id", $intercomTypeId);
				}
			}
		}
		else{
			if (isset($intercomTypeId) && !empty($intercomTypeId)) {
				if (is_array($intercomTypeId)) {
					$this->datatables->whereIn("ti.common_area_id", $intercomTypeId);
				} else {
					$this->datatables->where("ti.common_area_id", $intercomTypeId);
				}
			}
		}
		

		if($createdAt != ''){
			list($fromDate,$toDate) = explode(" - ",$createdAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(ti.created_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(ti.created_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(ti.created_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

		if($updatedAt != ''){
			list($fromDate,$toDate) = explode(" - ",$updatedAt);
			$fromDate = DMYToYMD($fromDate);
			$toDate = DMYToYMD($toDate);
			if(strtotime($fromDate) != strtotime($toDate)){
				$this->datatables->where("date_format(ts.updated_at,'".DATE_FORMATE_MYSQL_YMD."') >= ",$fromDate);
				$this->datatables->where("date_format(ts.updated_at,'".DATE_FORMATE_MYSQL_YMD."') <= ",$toDate);
			} else {
				$this->datatables->where("date_format(ts.updated_at,'".DATE_FORMATE_MYSQL_YMD."') = ",$toDate);
			}
		}

		$this->datatables->groupBy("ti.intercom_id");
		
		accessFilter($this->datatables, array("society" => "ti.society_id"));
		
        $dataReport =  $this->datatables->generate();
        $dataReport = json_decode($dataReport, true);
        $data       = $dataReport['data'];
        if(count($data) > 0){
            foreach($data as $key => $displayData){
                $actionButtonFilter = array(
                    "intercom_id" => isset($displayData['intercom_id']) ? $displayData['intercom_id'] : "",
                );
                $data[$key]['action_button'] = intercomActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
				$data[$key]['excel_intercom_type_name'] = isset($displayData['intercom_type_name']) ?  $displayData['intercom_type_name'] : "";
				if($displayData['intercom_type'] == 'flat' ){
					$data[$key]['intercom_type_name'] = isset($displayData['intercom_type_name']) ?  flatDocumentToHtml($displayData['intercom_type_name'],$displayData['flat_id']) : "";
				}
				
				$data[$key]['intercom_type'] = underscoreToUcWord($displayData['intercom_type']);
            }
        }
        if($return){
            return $data;
        }else{
            $dataReport['data'] = $data;
            echo json_encode($dataReport);
            exit;
        }
    }
    public function manage($intercomId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );

        if ($intercomId != '') {
			$filterData = array(
				"intercom_id" => $intercomId
			);
			$data['intercom_data'] = $this->intercom_model->getIntercomData($filterData);

			if (empty($data['intercom_data'])) {
                return redirect()->to('Admin/Intercom');
            }
		}
		if ($intercomId != '') {
			$data['title'] = 'Edit Intercom';
		} else {
			$data['title'] = 'Add Intercom';
		}

		$select2Condition = array(
			'isIntercomFlat' => true,
			'isInterComCommonArea' => true,
		);

        $data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition)? $select2Condition : array());
		if ((isset($data['intercom_data']['society_id']) && $data['intercom_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Intercom');
        }
		return $this->dt_ci_template->load("Admin","Intercom/IntercomManageView",$data);
	}

    public function save()
	{
		$this->db->transStart();
        $validation = \Config\Services::validation();

		$intercomId = $this->request->getVar('intercom_id');
		$intercomType = $this->request->getVar("intercom_type");
		$flatId = $this->request->getVar("flat_id");
		$commonAreaId = $this->request->getVar("common_area_id");
		$number = $this->request->getVar("number");
		$particulares = $this->request->getVar("particulares");
		$isActive = $this->request->getVar("is_active");

		if($intercomType == 'flat'){
			$validation->setRule('flat_id', lang('Intercom.flat'), 'required');
		}
		else{
			$validation->setRule('common_area_id', lang('Intercom.common_area'), 'required');
			$validation->setRule('particulares', lang('Intercom.particulares'), 'required');
		}

		$validation->setRule('intercom_type', lang('Intercom.intercom_type'), 'required');
		$validation->setRule('number', lang('Intercom.number'), 'required');
	

		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
			$filterData = array('intercom_id' => $intercomId, 'flat_id' => $flatId,'common_area_id' => $commonAreaId,'intercom_type' => $intercomType,'society_id' =>$this->session->get('society_id'));
			$checkFlatIntercomNumberData = $this->intercom_model->checkFlatIntercomNumberData($filterData);
			// lastQuery();
			// printArray($checkFlatIntercomNumberData,1);

			if (!empty($checkFlatIntercomNumberData)) {
				$response['success'] = false;
				$response['msg'] = underscoreToUcWord($intercomType) . " " .$checkFlatIntercomNumberData['intercom_type_name']." Already Assign Intercom";
				echo json_encode($response);
				exit;
			}


			//$filterUniqueData = array('intercom_id' => $intercomId, 'number'=> $number,'intercom_type' => $intercomType,'society_id' =>$this->session->userdata('society_id'));
			$filterUniqueData = array('intercom_id' => $intercomId, 'number'=> $number,'society_id' =>$this->session->get('society_id'));
			$checkNumberUniqueData = $this->intercom_model->checkFlatIntercomNumberData($filterUniqueData);

			
			if (!empty($checkNumberUniqueData)) {
				$response['success'] = false;
				$response['msg'] = 'Intercom number '.$number.'  Already Assign To Another ';
				echo json_encode($response);
				exit;
			}

	

			$intercomUpdateArray = array();
			$intercomArray = array(
				'intercom_id' => $intercomId,
				'intercom_type' => $intercomType,
				'society_id' => $this->session->get('society_id'),
				'flat_id' => $flatId,
				'common_area_id' => $commonAreaId,
				'number' => $number,
				'particulares' => $particulares,
				'is_active' => isset($isActive) ? 1 : 0,
			);

			if(!empty($intercomId)){
                $intercomUpdateData = $this->intercom_model->getIntercomData(array(
                    'intercom_id' => $intercomId,
                ));
                $intercomUpdateArray = compareArray($intercomArray,$intercomUpdateData);
            }
			$intercomData = $this->intercom_model->insertUpdateRecord($intercomArray, 'intercom_id', 'tbl_intercom', 1,'',array(),array(),$intercomUpdateArray);
			$lastIntercomId = $intercomData['lastInsertedId'];
			$transactionStatus = $this->db->transComplete();
			if (isset($intercomId) && $intercomId != '') {
				if (($intercomData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Intercom.intercom"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Intercom.intercom"));
				}
			} else {
				if (($intercomData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Intercom.intercom"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Intercom.intercom"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}
    public function changeStatus()
    {
        $intercomId = $this->request->getVar('intercom_id');
        $status = $this->request->getVar('status');

        //$status         = ($status == 0) ? 1 : 0;
        $return = $this->intercom_model->statusChange($intercomId,$status,'intercom_id','tbl_intercom');
        if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Intercom.intercom'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Intercom.intercom'));
        }
        echo json_encode($response);
        exit();
    }


    public function delete()
    {
    	$this->db->transStart();
        $intercomId = $this->request->getVar('intercom_id');
        $ids = is_array($intercomId) ? implode(',', $intercomId) : $intercomId;
//        if( isReferenceInTable( 'society_id','tbl_amc_detail', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_amenities', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_booking', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_broker', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_common_area', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_complain', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_flat', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_flat_square_feet_area', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_intercom', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_investments', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_management_committee', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_men_power_attendance', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_ownership_flat', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_rentals', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_service', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_staff', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_time_slot', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_tower', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_vendor', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_water_meter_reading', $societyId) ||
//            isReferenceInTable( 'society_id','tbl_parking_place', $societyId)
//        ){
//
//            if(!empty($societyId)){
//                foreach($societyId as $society){
//                    $deleteDataArray['module'] = 'Society';
//                    $deleteDataArray['activity'] = "Tried to delete Society ";
//                    $deleteDataArray['module_id'] = $society;
//                    logActivity('Tried to delete Society [SocietyID: ' . $society . ']',$this->data['userId'],'Society',$society,json_encode($deleteDataArray),'','Society',$society);
//                }
//            }
//
//            $response['success'] = false;
//            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
//            echo json_encode($response);
//            exit;
//        }
        $intercomData = $this->intercom_model->deleteRecord($intercomId);
        $transactionStatus = $this->db->transComplete();
        if (($intercomData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Intercom.intercom'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'),lang('Intercom.intercom'));
        }
        echo json_encode($response);
        exit;
    }

    public function view($id = null)
	{
		$intercomId = $this->request->getVar("view_id");
		if($intercomId == "" && $intercomId == null){
            return redirect()->to('Admin/Intercom');
		}
		else {
			$id = $intercomId;
			$filterData = array(
				"intercom_id" => $intercomId
			);
			$data['intercom_data'] = $this->intercom_model->getIntercomData($filterData);
			$intercomView = view("Admin/Intercom/IntercomModelView",$data);
			$response['view_title'] = "Intercom Details";
			$response['view_detail'] = $intercomView;
			$response['success'] = true;
			echo json_encode($response);
		}
	}

    public function excelExportIntercom()
	{
		$fileName ='intercom-' . DATETIMEFORMAT;
		$sheetName = 'Intercom-' . DATEFORMAT;
		$excelHeaderName = 'Intercom';
		$tableData = $this->getIntercomListing(true, $_GET);
		$dataRows = array();
		$dataRows[] = array(
			// lang('Intercom.society'),
			lang('Intercom.intercom_type'),
			lang('Intercom.intercom_type_name'),
			lang('Intercom.particulares'),
			lang('Intercom.number'),
			lang('CommonMessage.common_updated_by'),
			lang('CommonMessage.common_updated_at')
		);
		foreach ($tableData as $row) {
			$dataRows[] = array(
				// $row["society_name"],
				$row["intercom_type"],
				$row["excel_intercom_type_name"],
				$row["particulares"],
				$row["number"],
				$row["updated_by"],
				$row["updated_at"]
			);
		}
		$subTotalCellValueArray = [];
		$toColumn = 'F';
		$excelFilterData = array(
			'file_name' => $fileName,
			'sheet_name' => $sheetName,
			'excel_header_name' => $excelHeaderName,
			'data_row' => $dataRows,
			'sub_total_cell_value_array' => $subTotalCellValueArray,
			'to_column' => $toColumn,
			'skip_header' => false,
			'ignore_currency_symbols_sub_total_cell_value_array' => array(),
			'row_cell_currency_format' => array()
		);
		//excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
		excelExport($excelFilterData);
	}

    public function intercomPdf()
	{
		if(!$this->dt_ci_acl->checkAccess('Intercom|pdf')){
			return NO_ACCESS_SECTION;
		} else {

			$filterData = array(
				'is_multiple' => 1
			);
			$intercomData = $this->intercom_model->getIntercomData($filterData);

            $itercomCommonAreaData = array();
            $towerIdArray = array();
            if(!empty($intercomData)){
                foreach($intercomData as $intercomElement){
                    if($intercomElement['intercom_type'] == 'flat'){
                        array_push($towerIdArray,$intercomElement['tower_id']);
                    }
                    if($intercomElement['intercom_type'] == 'common_area') {
                        array_push($itercomCommonAreaData, $intercomElement);
                    }
                }
            }
            if(!empty($towerIdArray)){
                $towerIdArray = array_unique($towerIdArray);
            }

            $towerData = $this->tower_model->getTowerData(array(
                'tower_id' => $towerIdArray,
                'is_multiple' => 1
            ));

            $data['tower_data'] = $towerData;

            $towerWiseFlatData = [];
            foreach ($towerData as $towerElement) {
                $towerId = $towerElement['tower_id'];
                $towerWiseFlatData[] = [
                    'flat_no' => 'FLAT NO.',
                    'tower_name' => $towerElement['tower_name'],
                    'flats' => [],
                ];
                foreach ($intercomData as $intercomDataElement) {
                    if ($intercomDataElement['tower_id'] == $towerId) {
                        $towerWiseFlatData[count($towerWiseFlatData) - 1]['flats'][] = [
                            'flat_id' => $intercomDataElement['flat_id'],
                            'flat_no' => $intercomDataElement['flat_no'],
                            'number' => $intercomDataElement['number'],
                        ];
                    }
                }
            }
            $data['tower_wise_flat_data'] = $towerWiseFlatData;

			$societyData = $this->society_model->getSocietyData(array(
				"society_id" => $this->session->get('society_id'),
			));
			$data['society_data'] = $societyData;
			$data['intercom_data'] = $intercomData;
            $data['common_area_data'] = $itercomCommonAreaData;
			$data['name'] = lang("Intercom.intercom_pdf") . ".pdf";
			$printHeader = '';
			$printFooter = '';
			$html = view('Admin/Intercom/pdf/IntercomPdfView', $data);
			generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');

		}


	}
}
