<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\FaqModel;
use App\Models\MediaModel;
class Faq extends BaseController
{
    protected $faq_model;
    protected $society_model;
    protected $financial_year_model;
    public function __construct() {
        $this->faq_model = new FaqModel();
        $this->media_model = new MediaModel();
        // checkAndCreatePath(THUMBNAIL_MEDIA_IMAGE_PATH);
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
		$data['title'] = 'Faq';
		$this->dt_ci_template->load("Admin","Faq/FaqView",$data);
	}
	public function manage($faqId = '')
	{
		$data['extra_js'] = array(
			"js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
		);
        if ($faqId != '') {
			$filterData = array(
				"faq_id" => $faqId
			);
			$data['faq_data'] = $this->faq_model->getFaqData($filterData);
			$data['media_data'] = $this->media_model->getMediaData(array(
                "media_for" => 'faq',
                "media_for_id" => $faqId,
                'is_multiple' => 1
            ));
			if (empty($data['faq_data'])) {
                return redirect()->to('Admin/Faq');
            }
		}
		if ($faqId != '') {
			$data['title'] = 'Edit Faq';
		} else {
			$data['title'] = 'Add Faq';
		}
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
        $data['media_table'] = view('Admin/Media/MediaTableView', isset($data) ? $data : array());
		if ((isset($data['faq_data']['society_id']) && $data['faq_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Faq');
        }
		$this->dt_ci_template->load("Admin","Faq/FaqManageView",$data);
	}
    public function getFaqListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}
        $this->datatables->table("tbl_faq as tf");
		$this->datatables->select("tf.faq_id,tf.faq_title,tf.faq_answer,tf.sort_order,tc.category_name,tf.society_id");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tf.updated_at");
		$this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tf.society_id","left");
		$this->datatables->join("tbl_category as tc","tc.category_id = tf.category_id","left");
		$this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tf.updated_by AND tupdate.society_id = tf.society_id","left");
        accessFilter($this->datatables, array("society" => "tf.society_id"));
		$this->datatables->groupBy("tf.faq_id");
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"faq_id" => isset($displayData['faq_id']) ? $displayData['faq_id'] : ""
				);
				$data[$key]['action_button'] = faqActionButton($actionButtonFilter);
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function save()
	{
		$this->db->transStart();
		$validation = \Config\Services::validation();
		$faqId = $this->request->getVar('faq_id');
		$faqTitle = $this->request->getVar('faq_title');
		$faqAnswer = $this->request->getVar('faq_answer');
		$sortOrder = $this->request->getVar('faq_sort_order');
		$categoryId = $this->request->getVar('category_id');
		
		$validation->setRule('faq_title', lang('Faq.faq_title'), 'required');
		$validation->setRule('faq_answer', lang('Faq.faq_answer'), 'required');
		$validation->setRule('category_id', lang('Faq.category_id'), 'required');
		$validation->setRule('faq_sort_order', lang('Faq.faq_sort_order'), 'required|integer');
		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

        	$mediaTitleArray = $this->request->getVar('media_title');
            $mediaSortOrderArray =$this->request->getVar('sort_order');
            $mediaIdArray = $this->request->getVar('media_id');
            $mediaTypeArray = $this->request->getVar('media_type');
            $mediaFileArray = $this->request->getVar('media_file');
            $commonMediaArray = $this->request->getVar('common_media');
            $mediaValidationArray = array(
                'media_file' => $mediaFileArray,
                'common_media' => $commonMediaArray,
                'media_type' => $mediaTypeArray,
                'media_id' => $mediaIdArray,
            );
            mediaValidation($_FILES,$mediaValidationArray);

            $imageFormatsForThumbnail = array('jpg', 'jpeg', 'png', 'JPG'); // Only these formats will have thumbnails
			$imageFormat = array_merge($imageFormatsForThumbnail, array('pdf', 'mp4','mp3'));
            $imageExtension = imageExtension($imageFormat);
            $mediaResult = array();
            if (isset($_FILES["media_file"])) {
                $mediaPath = MEDIA_IMAGE_PATH;
                $mediaResult = $this->dt_ci_file_upload->UploadMultipleFile('media_file', MAX_IMAGE_SIZE_LIMIT, $mediaPath, true, true, $imageExtension, true);
                if ($mediaResult['success'] == false) {
                    $response['success'] = false;
                    $response['msg'] = strip_tags($mediaResult['message']);
                    echo json_encode($response);
                    die();
                }
                else{
                    unset($mediaResult['success']);
                    foreach ($mediaResult as $file) {
			            $extension = pathinfo($file['file_name'], PATHINFO_EXTENSION);
			            if (in_array(strtolower($extension), $imageFormatsForThumbnail)) {
			                $thumbnailResult = $this->dt_ci_file_upload->ThumbnailUploadFile($file, MEDIA_IMAGE_PATH, THUMBNAIL_MEDIA_IMAGE_PATH);
			            }
			        }
                }
            }
			
			$faqUpdateArray = array();
			$faqArray = array(
				'faq_id' => $faqId,
				'faq_title' => $faqTitle,
				'faq_answer' => $faqAnswer,
				'category_id' => $categoryId,
				'sort_order' => $sortOrder,
				'society_id' => $this->session->get('society_id'),
			);
			if(!empty($faqId)){
                $faqUpdateData = $this->faq_model->getFaqData(array(
                    'faq_id' => $faqId,
                ));
                $faqUpdateArray = compareArray($faqArray,$faqUpdateData);
            }
			$faqData = $this->faq_model->insertUpdateRecord($faqArray, 'faq_id', 'tbl_faq', 1,'',array(),array(),$faqUpdateArray);
			$lastFaqId = $faqData['lastInsertedId'];

			$mediaFor = 'faq';
            $mediaForId = $lastFaqId;

            include_once (APPPATH."Views/Admin/Media/v_media_insert_update.php");
			$transactionStatus = $this->db->transComplete();
			if (isset($faqId) && $faqId != '') {
				if (($faqData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Faq.faq"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Faq.faq"));
				}
			} else {
				if (($faqData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Faq.faq"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Faq.faq"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
    	$this->db->transStart();
		$faqId = $this->request->getVar('faq_id');

		$faqImageData = $this->media_model->getMediaData(array(
            "media_for" => 'faq',
            "media_for_id" => $faqId,
            'is_multiple' => 1
        ));

        if(is_array($faqImageData) && !empty($faqImageData)){
			foreach ($faqImageData as $image){
				$fileUrl = '';
				if(isset($image['media_file']) && $image['media_file'] != '') {
					$fileUrl = MEDIA_IMAGE_PATH . $image['media_file'];
				}
				if (file_exists($fileUrl)) {
					unlink($fileUrl);
				}

				$thumbnailFileUrl = '';
				if(isset($image['media_file']) && $image['media_file'] != '') {
					$thumbnailFileUrl = THUMBNAIL_MEDIA_IMAGE_PATH . $image['media_file'];
				}
				if (file_exists($thumbnailFileUrl)) {
					unlink($thumbnailFileUrl);
				}
			}
		}

		$filterData = array(
            "media_for" => "faq",
            "media_for_id" => $faqId
        );
        $deleteMedia = $this->media_model->deleteRecordMedia($filterData);
		
		$faqData = $this->faq_model->deleteRecord($faqId);
		$transactionStatus = $this->db->transComplete();
        if (($faqData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Faq.faq"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Faq.faq"));
        }
        echo json_encode($response);
        exit;
    }
}
