<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\DocumentModel;
class Document extends BaseController
{
    protected $document_model;
    public function __construct() {
        $this->document_model = new DocumentModel();
        // helper('tenant');
        // $tenantDB = getTenantDB();
    }
    public function index()
    {
        // printArray($this->session->get(),1);
        $data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Document';
        return $this->dt_ci_template->load("Admin","Document/DocumentView",$data);
    }

	public function manage($documentId = '')
	{

		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );

        if ($documentId != '') {
			$filterData = array(
				"document_id" => $documentId
			);
			$data['document_data'] = $this->document_model->getDocumentData($filterData);

            $data['document_for_data'] = $this->document_model->getDocumentForData(array(
                'document_id' => $documentId,
                'is_multiple' => 1
            ));
		}
		if ($documentId != '') {
			$data['title'] = 'Edit Document';
		} else {
			$data['title'] = 'Add Document';
		}
        if ((isset($data['document_data']['society_id']) && $data['document_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Document');
        }
		
		return $this->dt_ci_template->load("Admin","Document/DocumentManageView",$data);
	}

    public function getDocumentListing($return = false)
    {
        // $this->datatables = new \App\Libraries\Datatables($tenantDB);
       	$this->datatables->table("tbl_document td");
		$this->datatables->select("td.document_id, td.document_name,td.sort_order,td.is_active, td.has_expired_date,td.is_required,td.created_at,td.updated_at");
		$this->datatables->select("GROUP_CONCAT(REPLACE(CONCAT(UPPER(LEFT(tdf.document_for, 1)), SUBSTRING(tdf.document_for, 2)), '_', ' ') SEPARATOR ', ') as document_for,tdf.document_for as search_document_for");
        $this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,");
		$this->datatables->join("tbl_document_for as tdf","tdf.document_id = td.document_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = td.updated_by AND tupdate.society_id = td.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = td.created_by AND tcreate.society_id = td.society_id","left");
		$this->datatables->groupBy("td.document_id");
        accessFilter($this->datatables, array("society" => "td.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"document_id" => isset($data[$key]['document_id']) ? $data[$key]['document_id'] : ""
				);
				$data[$key]['action_button'] = documentActionButton($actionButtonFilter);
                $data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";
			}
		}
		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		} 
    }

    public function changeStatus(){
        $documentId = $this->request->getVar('document_id');
        $status = $this->request->getVar('status');
        $return = $this->document_model->statusChange($documentId,$status,'document_id','tbl_document');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Document.document'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Document.document'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
        $this->db->transStart();
		$validation = \Config\Services::validation();
		$documentId = $this->request->getVar('document_id');
		$documentName = $this->request->getVar('document_name');
		$sortOrder = $this->request->getVar('sort_order');
		$isActive = $this->request->getVar('is_active');
		$isRequired = $this->request->getVar('is_required');
		$hasExpiredDate = $this->request->getVar('has_expired_date');

		if (isset($documentId) && $documentId == '') {
            $validation->setRule('document_name', lang('Document.document_name'), 'required|checkTenantUnique[tbl_document.document_name]',array('checkTenantUnique' => 'This {field} Already Exists'));
        } else {
            $validation->setRule('document_name', lang('Document.document_name'), 'required|checkTenantUnique[tbl_document.document_name,document_id,'.$documentId.']',array('checkTenantUnique' => 'This {field} Already Exists'));
        }
		
		$validation->setRule('document_for.*', lang('Document.document_for'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
			$oldDocumentForData = array();
			if(!empty($documentId)) {
				$oldDocumentForData = $this->document_model->getDocumentForData(array(
					'document_id' => $documentId,
					'is_multiple' => 1
				));
			}
			//printArray($oldDocumentForData);
			//printArray($_POST);
			$documentUpdateArray = array();
			$documentArray = array(
				'document_id' => $documentId,
				'document_name' => $documentName,
				'sort_order' => $sortOrder,
                'society_id' => $this->session->get('society_id'),
				'is_active' => isset($isActive) ? 1 : 0,
				'is_required' => isset($isRequired) ? 1 : 0,
				'has_expired_date' => isset($hasExpiredDate) ? 1 : 0,
			);
			if(!empty($documentId)){
                $documentUpdateData = $this->document_model->getDocumentData(array(
                    'document_id' => $documentId,
                ));
				$documentUpdateArray = compareArray($documentArray,$documentUpdateData);
            }
             // printArray($documentArray,1);
			$documentData = $this->document_model->insertUpdateRecord($documentArray, 'document_id', 'tbl_document', 1,'',array(),array(),$documentUpdateArray);
			$lastDocumentId = $documentData['lastInsertedId'];
            $documentForIdArray = $this->request->getVar('document_for[]');
             if(isset($documentId) && $documentId != ''){
                $this->document_model->deleteDocumentForRecord($documentId);
            }
            if(isset($documentForIdArray)&& $documentForIdArray != ''){
                $documentForArray = array();
                foreach($documentForIdArray as $documentForId){
                    $documentForArray[] = array(
                        'document_for_id' => '',
                        'document_id' => $lastDocumentId,
                        'document_for' => $documentForId,
                        'created_at' => date('Y-m-d H:i:s'),
                        'updated_at' => date('Y-m-d H:i:s'),
                        'created_by' => $this->data['userId'],
                        'updated_by' => $this->data['userId']
                    );
                }
				//printArray($documentForArray);
                if(!empty($documentForArray)){
                    $documentForExtraDataArray = array();
                    $documentForExtraDataArray['module_id'] = $lastDocumentId;
                    $documentForExtraDataArray['module'] = 'Document For';
                    $documentForExtraDataArray['type'] = 'Document';
                    $documentForExtraDataArray['old_data'] = $oldDocumentForData;
                    $documentForExtraDataArray['user_id'] = $this->data['userId'];
                    $documentForExtraDataArray['society_id'] = $this->session->get('society_id');
                     $this->document_model->batchInsert($documentForArray,'tbl_document_for',$documentForExtraDataArray);
                }
            }
            $transactionStatus = $this->db->transComplete();
			if (isset($documentId) && $documentId != '') {
                if (($documentData['success'])  && $transactionStatus == 1) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('Document.document'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('Document.document'));
                }
            } else {
                if (($documentData['success'])  && $transactionStatus == 1) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('Document.document'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('Document.document'));
                }
            }
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
        $documentId = $this->request->getVar('document_id');
        $ids = is_array($documentId) ? implode(',', $documentId) : $documentId;
         if( isReferenceInTable( 'document_id','tbl_module_document', $documentId)
         ){
			 if(!empty($documentId)){
			 	foreach($documentId as $documentElement){
			 		$deleteDataArray['module'] = 'Document';
			 		$deleteDataArray['activity'] = "Tried to delete Document ";
			 		$deleteDataArray['module_id'] = $documentElement;
			 		logActivity('Tried to delete Document [DocumentID: ' . $documentElement . ']',$this->data['userId'],'Document',$documentElement,json_encode($deleteDataArray),'','Document',$documentElement);
			 	}
			 }
             $response['success'] = false;
             $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
             echo json_encode($response);
             exit;
         }
        $this->document_model->deleteDocumentForRecord($documentId);
        $documentData = $this->document_model->deleteRecord($documentId);
        $transactionStatus = $this->db->transComplete();
        if (($documentData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Document.document"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Document.document"));
        }
        echo json_encode($response);
        exit;
    }

    public function getDocumentDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $documentId            = $this->request->getVar('document_id');
        $documentFor		= $this->request->getVar('document_for');
        $societyId = $this->request->getVar('society_id');
        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'document_id' => $documentId,
            'document_for' => $documentFor,
            'is_active' => 1,
            'society_id' => $societyId,
        );
        echo $this->document_model->getDocument($filterData);
    }

    public function view($id = null)
    {
        $documentId = $this->request->getVar("view_id");
        if($documentId == "" && $documentId == null){
            return redirect()->to('Admin/Document');
        }
        else {
            $id = $documentId;
            $filterData = array(
                "document_id" => $documentId
            );
            $data['document_data'] = $this->document_model->getDocumentData($filterData);
            $data['document_for_data'] = $this->document_model->getDocumentForData(array(
                'document_id' => $documentId,
                'is_multiple' => 1
            ));
            $documentView = view("Admin/Document/DocumentModelView", $data);
            $response['view_title'] = "Document Details";
            $response['view_detail'] = $documentView;
            $response['success'] = true;
            echo json_encode($response);
        }
    }
}
