<?php

namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\ComplainModel;
use App\Models\MediaModel;
use App\Models\StatusModel;
use App\Models\ManagementCommitteeModel;
use App\Models\OwnershipFlatModel;
use App\Models\CommonWebServiceModel;
use App\Models\ResourceTypeModel;
class Complain extends BaseController
{
    protected $complain_model;
    public function __construct() {
        $this->complain_model = new ComplainModel();
        $this->status_model = new StatusModel();
        $this->media_model = new MediaModel();
        $this->management_committee_model = new ManagementCommitteeModel();
        $this->ownership_flat_model = new OwnershipFlatModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        $this->resource_type_model = new ResourceTypeModel();
        // checkAndCreatePath(THUMBNAIL_MEDIA_IMAGE_PATH);
        // checkAndCreatePath(THUMBNAIL_COMPLAIN_IMAGE_PATH);
    }
	public function index()
	{

		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
		$data['title'] = 'Complain';
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
		$data['complain_change_status_modal'] = view('Admin/Complain/ComplainChangeStatusModalView', array());
		return $this->dt_ci_template->load("Admin","Complain/ComplainView",$data);
	}

	public function manage($complainId = '',$view = '')
	{

		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );

        if ($complainId != '') {
			$filterData = array(
				"complain_id" => $complainId
			);
			$data['complain_data'] = $this->complain_model->getComplainData($filterData);

			// printArray($data['complain_data'],1);

			// $data['image_data'] = $this->complain_model->getComplainImageData(array(
	        //     "complain_id" => $complainId,
	        //     "is_multiple" => 1
	        // ));

	        $complainHistoryData = $this->complain_model->getComplainHistoryData(array(
	            "complain_id" => $complainId,
	            "is_multiple" => 1
	        ));

	        $complainHistoryImageData = $this->complain_model->getComplainHistoryImageData(array(
	            "complain_id" => $complainId,
	            "is_multiple" => 1
	        ));

			$data['media_data'] = $this->media_model->getMediaData(array(
                "media_for" => 'complain',
                "media_for_id" => $complainId,
                'is_multiple' => 1
            ));


	        $complainHistoryImageDataArray = [];
			if (isset($complainHistoryImageData) && !empty($complainHistoryImageData)) {
				foreach ($complainHistoryImageData as  $icomplain) {
					$complainHistoryImageDataArray[$icomplain['complain_history_id']][] = $icomplain;
				}
			}

			if (!empty($complainHistoryData)) {
				foreach ($complainHistoryData as $key => $displayData) {
					$complainHistoryData[$key]['complain_history_image_data'] = array_key_exists($displayData['complain_history_id'], $complainHistoryImageDataArray) ? $complainHistoryImageDataArray[$displayData['complain_history_id']] : array();
				}
			}

			$data['complain_history_data'] = $complainHistoryData;
			if (empty($data['complain_data'])) {
                return redirect()->to('Admin/Complain');
            }
		}
		if ($complainId != '') {
			$data['title'] = 'Edit Complain';
		} else {
			$data['title'] = 'Add Complain';
		}
		$data['complain_data']['view'] = (isset($view) && $view != '' ? 1 : 0);
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View",  array());
		if ((isset($data['complain_data']['society_id']) && $data['complain_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Complain');
        }
        if ((isset($data['complain_data']['is_close'])) && ($data['complain_data']['is_close'] == 1 )  && $data['complain_data']['view'] != 1 ) {
            return redirect()->to('Admin/Complain');
		}
		$data['media_table'] = view('Admin/Media/MediaTableView', isset($data) ? $data : array());
		$this->dt_ci_template->load("Admin","Complain/ComplainManageView",$data);
	}

    public function getComplainListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_complain as tc");
		$this->datatables->select("tc.complain_id, tc.complain_title,tsoc.society_name,tc.is_active,concat(tt.tower_name,' - ',tf.flat_no) as tower_flat_name,tc.flat_id,tstatus.is_close");
		$this->datatables->select("concat(tc.prefix,tc.series) as complain_number");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tc.updated_at,tc.description,COALESCE(tstatus.status_name,'') as status_name");
		$this->datatables->join(MASTER_DB.".tbl_society as tsoc","tsoc.society_id = tc.society_id","left");
		$this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tc.updated_by AND tupdate.society_id = tc.society_id","left");
        $this->datatables->join("tbl_flat as tf","tf.flat_id = tc.flat_id","left");
		$this->datatables->join("tbl_tower as tt","tt.tower_id = tf.tower_id","left");
		$this->datatables->join("tbl_status as tstatus","tstatus.status_id = tc.status_id","left");
		$this->datatables->groupBy("tc.complain_id");
		accessFilter($this->datatables, array("society" => "tc.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"complain_id" => isset($data[$key]['complain_id']) ? $data[$key]['complain_id'] : "",
					"is_close" => isset($displayData['is_close']) ? $displayData['is_close'] : "",
				);
				$data[$key]['action_button'] = complainActionButton($actionButtonFilter);
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
				$data[$key]['excel_flat_no'] = isset($displayData['tower_flat_name']) ?  $displayData['tower_flat_name'] : "";
				$data[$key]['tower_flat_name'] = isset($displayData['tower_flat_name']) ?  flatDocumentToHtml($displayData['tower_flat_name'],$displayData['flat_id']) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $complainId = $this->request->getVar('complain_id');
        $status = $this->request->getVar('status');
        $return = $this->complain_model->statusChange($complainId,$status,'complain_id','tbl_complain');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Complain.complain'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Complain.complain'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
		$this->db->transStart();
		$validation = \Config\Services::validation();
		$complainId = $this->request->getVar('complain_id');
		$complainTitle = $this->request->getVar('complain_title');
		$complainType = $this->request->getVar('complain_type');
		$complainant = $this->request->getVar('complainant');
		$description = $this->request->getVar('description');
		$flatId = $this->request->getVar('flat_id');
		$towerId = $this->request->getVar('tower_id');
		$categoryId = $this->request->getVar('category_id');
		$isActive = $this->request->getVar('is_active');
		$isUrgent = $this->request->getVar('is_urgent');
		$series = $this->request->getVar('series');

		// if (isset($complainId) && $complainId == '') {
        //     $validation->setRule('complain_title', lang('Complain.complain_title'), 'required|combination_unique[tbl_complain.complain_title.'.$this->session->get('society_id').'.]',array('combination_unique' => 'This {field} Already Exists'));
        // } else {
        //     $validation->setRule('complain_title', lang('Complain.complain_title'), 'required|edit_unique[tbl_complain.complain_title.'.$complainId. '.'. $this->session->get('society_id').']',array('edit_unique' => 'This {field} Already Exists'));
        // }

        $validation->setRule('description', lang('Complain.description'), 'required');
        $validation->setRule('complain_title', lang('Complain.complain_title'), 'required');
        $validation->setRule('complain_type', lang('Complain.complain_type'), 'required');
        $validation->setRule('complainant', lang('Complain.complainant'), 'required');
        // $validation->setRule('flat_id', lang('Complain.flat_id'), 'required');
        // $validation->setRule('tower_id', lang('Complain.tower_id'), 'required');
        $validation->setRule('category_id', lang('Complain.category_id'), 'required');
		
		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

			$nextSeries = 'getNextSeries("complaint", "'.COMPLAIN_PREFIX.'", "'.$this->session->get('society_id').'")';
			// $complainImage = array();
			// if (isset($_FILES["complain_image"])) {
			// 	$complainImagePath = COMPLAIN_IMAGE_PATH;
			// 	$complainImage = $this->dt_ci_file_upload->UploadMultipleFile('complain_image', MAX_IMAGE_SIZE_LIMIT, $complainImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
			// 	if ($complainImage['success'] == false) {
			// 		$response['success'] = false;
			// 		$response['msg'] = strip_tags($complainImage['message']);
			// 		echo json_encode($response);
			// 		die();
			// 	}
			// }

			// mediaValidation($_FILES);
            $mediaTitleArray = $this->request->getVar('media_title');
            $mediaSortOrderArray =$this->request->getVar('sort_order');
            $mediaIdArray = $this->request->getVar('media_id');
            $mediaTypeArray = $this->request->getVar('media_type');
            $mediaFileArray = $this->request->getVar('media_file');
            $commonMediaArray = $this->request->getVar('common_media');
            $mediaValidationArray = array(
                'media_file' => $mediaFileArray,
                'common_media' => $commonMediaArray,
                'media_type' => $mediaTypeArray,
                'media_id' => $mediaIdArray,
            );
            mediaValidation($_FILES,$mediaValidationArray);

            $imageFormatsForThumbnail = array('jpg', 'jpeg', 'png', 'JPG'); // Only these formats will have thumbnails
			$imageFormat = array_merge($imageFormatsForThumbnail, array('pdf', 'mp4'));
            $imageExtension = imageExtension($imageFormat);
            $mediaResult = array();
            if (isset($_FILES["media_file"])) {
                $mediaPath = MEDIA_IMAGE_PATH;
                $mediaResult = $this->dt_ci_file_upload->UploadMultipleFile('media_file', MAX_IMAGE_SIZE_LIMIT, $mediaPath, true, true, $imageExtension, true);
                if ($mediaResult['success'] == false) {
                    $response['success'] = false;
                    $response['msg'] = strip_tags($mediaResult['message']);
                    echo json_encode($response);
                    die();
                }
                else{
                    unset($mediaResult['success']);
                    foreach ($mediaResult as $file) {
			            $extension = pathinfo($file['file_name'], PATHINFO_EXTENSION);
			            if (in_array(strtolower($extension), $imageFormatsForThumbnail)) {
			                $thumbnailResult = $this->dt_ci_file_upload->ThumbnailUploadFile($file, MEDIA_IMAGE_PATH, THUMBNAIL_MEDIA_IMAGE_PATH);
			            }
			        }
                }
            }
            // die();
			if (isset($complainId) && $complainId == '') {
				$statusId = 0;
				$statusData = $this->status_model->getStatusData(array(
					'is_default' => 1,
					'status_for' => 'complain',
					'is_active' => 1,
				));
				if(empty($statusData)){
					$response['success'] = false;
					$response['msg'] = 'Status Master Complain Is Default Status Not Defined';
					echo json_encode($response);
					exit();
				}
				if(!empty($statusData)){
					$statusId = isset($statusData['status_id']) ? $statusData['status_id'] : 0;
				}
			}

			$complainUpdateArray = array();
			$complainArray = array(
				'complain_id' => $complainId,
				'complain_title' => $complainTitle,
				'complain_type' => $complainType,
				'complainant' => $complainant,
				'description' => $description,
				'flat_id' => $flatId,
				'tower_id' => $towerId,
				'category_id' => $categoryId,
				'society_id' => $this->session->get('society_id'),
				'is_active' => isset($isActive) ? 1 : 0,
				'is_urgent' => isset($isUrgent) ? 1 : 0,
			);

			if (isset($complainId) && $complainId == '') {
				$complainArray['prefix'] = COMPLAIN_PREFIX;
				$complainArray['series'] = $series;
				$complainArray['status_id'] = $statusId;
			}

			if(isset($complainant) && $complainant == 'owner_flat_member'){
				$complainantId = $this->request->getVar('owner_flat_id');
				$complainArray['complainant_id'] = $complainantId;
			} else {
				$complainantId = $this->request->getVar('user_id');
				$complainArray['complainant_id'] = $complainantId;
			}

			// printArray($complainArray,1);
			if(!empty($complainId)){
                $complainUpdateData = $this->complain_model->getComplainData(array(
                    'complain_id' => $complainId,
                ));
                $complainUpdateArray = compareArray($complainArray,$complainUpdateData);
            }
			$complainData = $this->complain_model->insertUpdateRecord($complainArray, 'complain_id', 'tbl_complain', 1,'',array('series'),array(),$complainUpdateArray);
			$lastComplainId = $complainData['lastInsertedId'];

			$mediaFor = 'complain';
            $mediaForId = $lastComplainId;

            include_once (APPPATH."Views/Admin/Media/v_media_insert_update.php");



			
			// if($lastComplainId != ''){
            //     if(isset($complainImage) && count($complainImage) > 0){
            //         $batchArray = array();
            //         unset($complainImage['success']);
            //         foreach ($complainImage as $key => $imageData) {
            //             $dataArray = array(
            //                 'complain_image_id' =>   '',
            //                 'complain_id' => $lastComplainId,
            //                 'complain_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
            //                 'created_by' => $this->data['userId'],
			// 				'updated_by' => $this->data['userId'],
			// 				'created_at' => date("Y-m-d h:i:s"),
			// 				'updated_at' => date("Y-m-d h:i:s"),
            //             );
            //             array_push($batchArray, $dataArray);
            //         }


            //         $imageExtraDataArray = array();
            //         $imageExtraDataArray['module_id'] = $lastComplainId;
            //         $imageExtraDataArray['module'] = 'Complain Image';
            //         $imageExtraDataArray['type'] = 'Complain';
            //         $imageExtraDataArray['old_data'] = array();
            //         $imageExtraDataArray['user_id'] = $this->data['userId'];
            //         $imageExtraDataArray['society_id'] = $this->session->get('society_id');
            //         $this->complain_model->batchInsert($batchArray, 'tbl_complain_image',$imageExtraDataArray);
            //     }
            // }
            $transactionStatus = $this->db->transComplete();
			if (isset($complainId) && $complainId != '') {
				if (($complainData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Complain.complain"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Complain.complain"));
				}
			} else {
				if (($complainData['success']) && ($transactionStatus == 1)) {
					$complainRecord = $this->complain_model->getComplainData(array(
		                'complain_id' => $lastComplainId,
		            ));
					$memberIdArray = array();
					$notificationDataArray = array();
					$notificationMergeArray = array();
					$userDeviceUserIdArray = array();
	                $userDeviceUserTypeIdArray = array();
	                $userDeviceUserTypeArray = array();
	                $userManagerDevice = array();
	                $userDeviceManagerIdArray = array();
	                $userDeviceManagerTypeIdArray = array();
	                $ownershipFlatMemberIdArray = array();
	                $userDeviceManagerTypeArray = array();
	                $managementCommitteeData = $this->management_committee_model->getManagementCommitteeData(array(
	                    'society_id' => $this->session->get('society_id'),
	                    'is_active' => 1,
	                    'is_multiple' => 1
	                ));
	                if (!empty($managementCommitteeData)) {
	                    foreach ($managementCommitteeData as $managementCommitteeElement) {
	                        $memberIdArray[] = $managementCommitteeElement['user_member_id'];
	                        $ownershipFlatMemberIdArray[] = $managementCommitteeElement['member_id'];
	                    }
	                }

	                if(!empty($ownershipFlatMemberIdArray)){
	                	$ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                            'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
                            'is_show_all_member' => 1,
                            'is_multiple' => 1,
                            'is_active' => 1
                        ));

	                
                        if(!empty($ownershipFlatMemberData)){
                            foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                                $memberIdArray[] = $ownershipFlatMember['member_id'];
                            }
                        }

		                $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
			                'resource_type_name' => RESOURCE_TYPE_MEMBER,
			                'society_id' => $this->session->get('society_id'),
			            ));

	                    $userSocietyCommitteeData = $this->common_web_service_model->getUserSocietyData(array(
	                        'society_id' => $this->session->get('society_id'),
	                        'resource_type_id' => $resourceTypeData['resource_type_id'],
	                        'type_id' => $memberIdArray,
	                        'user_id_not' => $this->data['userId'],
	                        'is_multiple' => 1
	                    ));

	                    if (!empty($userSocietyCommitteeData)) {
	                        foreach ($userSocietyCommitteeData as $userSocietyCommitteeElement) {
	                            $userDeviceUserIdArray[] = isset($userSocietyCommitteeElement['user_society_id']) ? $userSocietyCommitteeElement['user_society_id'] : 0;
	                        }
	                        $userMemberDevice = $this->common_web_service_model->deviceData(array(
	                            "user_society_id" => $userDeviceUserIdArray,
	                            "user_type" => MEMBER_APP,
	                            "is_latest" => 1,
	                            "is_multiple" => 1
	                        ));

	                        $resourceTypeManagerData = $this->resource_type_model->getResourceTypeData(array(
				                'resource_type_name' => RESOURCE_TYPE_MANAGER,
				                'society_id' => $this->session->get('society_id'),
				            ));

	                        $userManagerData = $this->common_web_service_model->getUserSocietyData(array(
	                            'society_id' => $this->session->get('society_id'),
	                            'user_id_not' => $this->data['userId'],
	                            'resource_type_id' => $resourceTypeManagerData['resource_type_id'],
	                            'is_active' => 1,
	                            'is_multiple' => 1
	                        ));

	                        if (!empty($userManagerData)) {
	                            foreach ($userManagerData as $userManagerCommittee) {
	                                $userDeviceManagerIdArray[] = isset($userManagerCommittee['user_society_id']) ? $userManagerCommittee['user_society_id'] : 0;
	                            }

	                            $userManagerDevice = $this->common_web_service_model->deviceData(array(
	                                "user_society_id" => $userDeviceManagerIdArray,
	                                "user_type" => MANAGER_APP,
	                                "is_latest" => 1,
	                                "is_multiple" => 1
	                            ));
	                        }

	                        $userMergeArray = array_merge($userMemberDevice,$userManagerDevice);
	                        if (!empty($userMergeArray)) {
	                            foreach ($userMergeArray as $userDeviceElement) {
	                                if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
	                                    $notificationArray = array(
	                                        'ownership_flat_id' => 0,
	                                        'ownership_flat_member_id' => isset($userDeviceElement['type_id']) ? $userDeviceElement['type_id'] : 0,
	                                        'type' => 'complain',
	                                        'status' => 'complain',
	                                        'type_id' => $lastComplainId,
	                                        'user_id' => $this->data['userId'],
	                                        'complain_title' => $complainRecord['complain_title'],
	                                        'complain_number' => $complainRecord['complain_number'],
	                                        'description' => $complainRecord['description'],
	                                        'member_name' => $complainRecord['complainant_name'],
	                                        'society_id' => $this->session->get('society_id'),
	                                        'notification_title' => 'New Complain Registered',
	                                        'description' => 'A new complain has been registered by '.$complainRecord['complainant_name'].' regarding '.$complainTitle.'. Please review the details and take appropriate action.',
	                                        'module' => 'complain',
	                                        'action_type' => 'sent',
	                                        'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
	                                        'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
	                                        'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
	                                        'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
	                                        // 'app_url' => MEMBER_URL .'ticket_detail_page/' . $lastComplainId,
	                                    );

	                                    
                                        $notificationArray['send_for_notification'] = 'manager';
                                        $notificationArray['send_for_notification_id'] = $this->data['userId'];
                                        $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
                                        $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
	                                    
	                                    $notificationArray['extra_data_json'] = json_encode($notificationArray);
	                                    array_push($notificationDataArray, $notificationArray);
	                                }
	                            }
	                        }
                    	}

	                    if (isset($notificationDataArray) && !empty($notificationDataArray)) {
	                        sendNotificationComplainAndroid($notificationDataArray);
	                    }
	                }
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Complain.complain"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Complain.complain"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
    	$this->db->transStart();
        $complainId = $this->request->getVar('complain_id');

        $complainData = $this->complain_model->getComplainData(array(
			'complain_id' =>$complainId,
			'is_multiple' => 1
		));

		$isCloseComplainArray = array();
		
		$commonMessage = '';
		if (!empty($complainData)) {
			foreach ($complainData as $complainElement) {
				$documentNumber =  $complainElement['complain_number'];
				$statusData = $this->status_model->getStatusData(array(
					'status_id' => $complainElement['status_id'],
				));
				if ($statusData['is_close'] == 1) {
					$isCloseComplainArray[]= $documentNumber;
				} 
			}
		}

		//printArray($rentAgreementPeriodToArray,1);

		if (!empty($isCloseComplainArray)) {

			if (!empty($isCloseComplainArray)) {

				$complainNo = implode(",", $isCloseComplainArray);

				$commonMessage .= 'For Complain '. $complainNo . " Already Closed So Can't Deleted." ;

			}
			
			$response['success'] = false;
			$response['msg'] = $commonMessage ;
			echo json_encode($response);
			exit;
		}

		$complainHistoryImageData = $this->complain_model->getComplainHistoryImageData(array(
            "complain_id" => $complainId,
            "is_multiple" => 1
        ));

		$complainImageData = $this->media_model->getMediaData(array(
            "media_for" => 'complain',
            "media_for_id" => $complainId,
            'is_multiple' => 1
        ));

		
		if(is_array($complainImageData) && !empty($complainImageData)){
			foreach ($complainImageData as $image){
				$fileUrl = '';
				if(isset($image['media_file']) && $image['media_file'] != '') {
					$fileUrl = MEDIA_IMAGE_PATH . $image['media_file'];
				}
				if (file_exists($fileUrl)) {
					unlink($fileUrl);
				}

				$thumbnailFileUrl = '';
				if(isset($image['media_file']) && $image['media_file'] != '') {
					$thumbnailFileUrl = THUMBNAIL_MEDIA_IMAGE_PATH . $image['media_file'];
				}
				if (file_exists($thumbnailFileUrl)) {
					unlink($thumbnailFileUrl);
				}
			}
		}

		if(is_array($complainHistoryImageData) && !empty($complainHistoryImageData)){
			foreach ($complainHistoryImageData as $image){
				$fileUrl = '';
				if(isset($image['complain_image']) && $image['complain_image'] != '') {
					$fileUrl = MEDIA_IMAGE_PATH . $image['complain_image'];
				}
				if (file_exists($fileUrl)) {
					unlink($fileUrl);
				}

				$thumbnailFileUrl = '';
				if(isset($image['complain_image']) && $image['complain_image'] != '') {
					$thumbnailFileUrl = THUMBNAIL_MEDIA_IMAGE_PATH . $image['complain_image'];
				}
				if (file_exists($thumbnailFileUrl)) {
					unlink($thumbnailFileUrl);
				}
			}
		}
		$filterData = array(
            "media_for" => "complain",
            "media_for_id" => $complainId
        );
        $deleteMedia = $this->media_model->deleteRecordMedia($filterData);
        $complainData = $this->complain_model->deleteRecord($complainId);
        $transactionStatus = $this->db->transComplete();
        if (($complainData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Complain.complain"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Complain.complain"));
        }
        echo json_encode($response);
        exit;
    }

    public function deleteComplainImage()
    {
    	$this->db->transStart();
        $complainImageId = $this->request->getVar('complain_image_id');
        $complainId = $this->request->getVar('complain_id');
        $imageData = $this->complain_model->getComplainImageData(array(
            "complain_image_id" => $complainImageId,
            "is_multiple" => 1
        ));
        if(is_array($imageData) && !empty($imageData)){
            foreach ($imageData as $image){
                $FileUrl = '';
                if(isset($image['complain_image']) && $image['complain_image'] != '') {
                    $FileUrl = MEDIA_IMAGE_PATH . $image['complain_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                } 

                $thumbnailFileUrl = '';
                if(isset($image['complain_image']) && $image['complain_image'] != '') {
                    $thumbnailFileUrl = THUMBNAIL_MEDIA_IMAGE_PATH . $image['complain_image'];
                }
                if (file_exists($thumbnailFileUrl)) {
                    unlink($thumbnailFileUrl);
                } 
            }
        }
        //delete setting location
        $imageData = $this->complain_model->deleteComplainImage($complainImageId);      
        if ($imageData) {
        	$ids = is_array($complainImageId) ? implode(',',$complainImageId) : $complainImageId;
			$deleteDataArray['module'] = 'Complain Image';
			$deleteDataArray['activity'] = "Complain Image Deleted";
			$deleteDataArray['module_id'] = $complainImageId;
			logActivity('Complain Image Deleted [ComplainImageID: ' . $ids . ']',$this->data['userId'],'Complain Image',$ids,json_encode($deleteDataArray),'','Complain',$complainId);
			$transactionStatus = $this->db->transComplete();
			if($transactionStatus == 1){
				$response['success'] = true;
            	$response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Complain.complain_image'));
			}
			else{
				$response['success'] = false;
            	$response['msg']     = sprintf(lang('CommonMessage.delete_error'),lang('Complain.complain_image'));
			}
            
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Complain.complain_image'));
        }
        echo json_encode($response);
        exit();
    }

    public function getComplainCode()
	{
		$prefix = $this->request->getVar('prefix');
		$societyId = $this->request->getVar('society_id');

        $centralDB = \Config\Database::connect();

        $society = $centralDB->table('tbl_society')
            ->where('society_id', $societyId)
            ->get()
            ->getRowArray();

		$getComplainCode = $this->complain_model->getComplainCode($prefix,$society['db_name']);
		$response['success'] = true;
		$response['data'] = $prefix.$getComplainCode;
		$response['series'] = $getComplainCode;
		echo json_encode($response);
		exit;
	}
	public function view($id = null)
	{
		$complainId = $this->request->getVar("view_id");
		if($complainId == "" && $complainId == null){
            return redirect()->to('Admin/Complain');
		}
		else {
			$id = $complainId;
			$filterData = array(
				"complain_id" => $complainId
			);
			$data['complain_data'] = $this->complain_model->getComplainData($filterData);
			$data['image_data'] = $this->complain_model->getComplainImageData(array(
               "complain_id" => $complainId,
               "is_multiple" => 1
           ));

			$complainHistoryData = $this->complain_model->getComplainHistoryData(array(
               "complain_id" => $complainId,
               "is_multiple" => 1
           ));

			$historyImageData = $this->complain_model->getComplainHistoryImageData(array(
               "complain_id" => $complainId,
               "is_multiple" => 1
           ));

		   $historyImageDataArray = array();
		   if(!empty($historyImageData)){
			foreach ($historyImageData as $displayData){
				$historyImageDataArray[$displayData['complain_history_id']][] = $displayData;
			}
		   }

		   if (!empty($complainHistoryData)) {
			foreach ($complainHistoryData as $fkey => $complainHistoryElement) {
					$complainHistoryData[$fkey]['image_data'] = array_key_exists($complainHistoryElement['complain_history_id'],$historyImageDataArray) ? $historyImageDataArray[$complainHistoryElement['complain_history_id']]: array();
				}
			}

			$data['complain_history_data']  = $complainHistoryData;

		    // printArray($data['complain_history_data'],1);

			$complainView = view("Admin/Complain/ComplainModelView", $data);
			$response['view_title'] = "Complain Details";
			$response['view_detail'] = $complainView;
			$response['success'] = true;
			echo json_encode($response);
		}
	}

	public function excelExportComplain()
    {
        $fileName ='complain-' . DATETIMEFORMAT;
        $sheetName = 'Complain-' . DATEFORMAT;
        $excelHeaderName = 'Complain';
        $tableData = $this->getComplainListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('Complain.society'),
            lang('Complain.complain_number'),
            lang('Complain.flat'),
            lang('Complain.complain_title'),
            lang('Complain.description'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["complain_number"],
                $row["excel_flat_no"],
                $row["complain_title"],
                $row["description"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'F';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        //excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
        excelExport($excelFilterData);
    }

    public function changeComplainStatus()
	{
		$validation = \Config\Services::validation();
		$this->db->transStart();
		$modalComplainId    = $this->request->getVar('modal_complain_id');
		$statusId = $this->request->getVar('status_id');
		$resourceId = $this->request->getVar('resource_id');
		$remarks = $this->request->getVar('remarks');

		$validation->setRule('modal_complain_id', lang('Complain.complain_id'), 'required');
		$validation->setRule('status_id', lang('Complain.status'), 'required');
		$validation->setRule('remarks', lang('Complain.remarks'), 'required');
		
		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

        	$complainImage = array();
			if (isset($_FILES["complain_image"])) {
				$complainImagePath = MEDIA_IMAGE_PATH;
				$complainImage = $this->dt_ci_file_upload->UploadMultipleFile('complain_image', MAX_IMAGE_SIZE_LIMIT, $complainImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
				if ($complainImage['success'] == false) {
					$response['success'] = false;
					$response['msg'] = strip_tags($complainImage['message']);
					echo json_encode($response);
					die();
				}
				else{
                    unset($complainImage['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($complainImage, MEDIA_IMAGE_PATH, THUMBNAIL_MEDIA_IMAGE_PATH);
                }
			}
			$complainIdArray = explode(',', $modalComplainId);

			if (!empty($complainIdArray)) {
				foreach($complainIdArray as $complainId){
					$complainData = $this->complain_model->getComplainData(array('complain_id'=>$complainId));

					$complainStatusId ='';
					$complainRemarks ='';
				
					if(!empty($complainData)){
						$complainStatusId = isset($complainData['status_id']) ? $complainData['status_id'] :'';
						$complainRemarks = isset($complainData['remarks']) ? $complainData['remarks'] :'';
					}
					$statusData = $this->status_model->getStatusData(array(
						'status_id' => $complainStatusId,
					));


					if($complainStatusId == $statusId){
						$response['success'] = false;
						$response['msg'] = "Complain Status Already " . $statusData['status_name'];
						echo json_encode($response);
						exit();
					}

					
					if($statusData['is_close']){
						$response['success'] = false;
						$response['msg'] = "Complain Already Closed";
						echo json_encode($response);
						exit();
					}

					

					$complainUpdateArray = array(
						'complain_id' => $complainId,
						'remarks' => $remarks,
						'status_id' => $statusId,
					);
					$complainExtraDataArray = array();
	                $complainExtraDataArray['module_id'] = $complainStatusId;
	                $complainExtraDataArray['module'] = 'Complain Status Change';
	                $complainExtraDataArray['type'] = 'Complain';
	                $complainExtraDataArray['old_data'] = $complainData;
	                $complainExtraDataArray['user_id'] = $this->data['userId'];
	                $complainExtraDataArray['society_id'] = $this->session->get('society_id');
					$closingUpdateData = $this->complain_model->insertUpdateRecord($complainUpdateArray, "complain_id",  'tbl_complain',1,$complainExtraDataArray);


					$complainHistoryArray = array(
						'complain_history_id' => '',
						'complain_id' => $complainId,
						'remarks' => $complainRemarks,
						'status_id' => $complainStatusId,
						'resource_id' => $resourceId,
					);
					$complainHistoryExtraDataArray = array();

					// printArray($complainHistoryArray,1);
	                // $complainExtraDataArray['module_id'] = $complainStatusId;
	                // $complainExtraDataArray['module'] = 'Complain Status Change';
	                // $complainExtraDataArray['type'] = 'Complain';
	                // $complainExtraDataArray['old_data'] = $complainData;
	                // $complainExtraDataArray['user_id'] = $this->data['userId'];
	                // $complainExtraDataArray['society_id'] = $this->session->get('society_id');
					$complainHistoryUpdateData = $this->complain_model->insertUpdateRecord($complainHistoryArray,"complain_history_id",  'tbl_complain_history',1);
					$lastComplainHistoryId = $complainHistoryUpdateData['lastInsertedId'];
					// $complainImageData = $this->complain_model->getComplainImageData(array(
					// 	'complain_id' => $complainId,
					// 	'is_multiple' => 1
					// ));

					$complainImageData = $this->media_model->getMediaData(array(
		                "media_for" => 'complain',
		                "media_for_id" => $complainId,
		                "media_type" =>'image',
		                'is_multiple' => 1
		            ));

					if(!empty($complainImage) && count($complainImage) > 0){
		                $batchArray = array();
		                unset($complainImage['success']);
		                $this->complain_model->deleteComplainImageForHistory($complainId);
		                foreach ($complainImage as $key => $imageData) {
		                	if(!empty($imageData['file_name'])){
		                        $dataArray = array(
		                            'media_id' => '',
		                            'media_for' => 'complain',
		                            'media_type' => 'image',
		                            'media_for_id' => $complainId,
		                            'media_file' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
		                            'created_by' => $this->data['userId'],
									'updated_by' => $this->data['userId'],
									'created_at' => date("Y-m-d H:i:s"),
									'updated_at' => date("Y-m-d H:i:s"),
		                        );
		                    }
                        	array_push($batchArray, $dataArray);
                    	}

                    	$complainExtraDataArray = array();
		                $complainExtraDataArray['module_id'] = $complainId;
		                $complainExtraDataArray['module'] = 'Complain Image';
		                $complainExtraDataArray['type'] = 'Complain';
		                $complainExtraDataArray['old_data'] = array();
		                $complainExtraDataArray['user_id'] = $this->data['userId'];
		                $complainExtraDataArray['society_id'] = $this->session->get('society_id');
                    	$this->complain_model->batchInsert($batchArray, 'tbl_media',$complainExtraDataArray);
			        }
			        $mediaIdArray = array();
			        if(!empty($complainImageData)){
			        	$imageBatchArray = array();
			        	foreach($complainImageData as $complainImageHistory){
			        		$mediaIdArray[] = $complainImageHistory['media_id'];
			        		$imageHistoryArray = array(
	                            'complain_history_image_id' => '',
	                            'complain_history_id' => $lastComplainHistoryId,
	                            'complain_id' => $complainImageHistory['media_for_id'],
	                            'complain_image' => $complainImageHistory['media_file'],
	                            'created_by' => $this->data['userId'],
								'updated_by' => $this->data['userId'],
								'created_at' => date("Y-m-d H:i:s"),
								'updated_at' => date("Y-m-d H:i:s"),
	                        );
	                        array_push($imageBatchArray, $imageHistoryArray);
			        	}
			        	// printArray($imageBatchArray,1);
			        	$this->complain_model->batchInsert($imageBatchArray, 'tbl_complain_history_image');
			        	if(!empty($mediaIdArray)){
			        		$mediaData = $this->complain_model->deleteComplainMediaRecord($mediaIdArray);
			        	}
			        }
			        
				}	
			}

			if ($closingUpdateData['success']) {
				$memberIdArray = array();
				$notificationDataArray = array();
				$notificationMergeArray = array();
				$userDeviceUserIdArray = array();
                $userDeviceUserTypeIdArray = array();
                $userDeviceUserTypeArray = array();
                $userManagerDevice = array();
                $userDeviceManagerIdArray = array();
                $userDeviceManagerTypeIdArray = array();
                $ownershipFlatMemberIdArray = array();
                $userDeviceManagerTypeArray = array();
				if (!empty($complainIdArray)) {
					foreach($complainIdArray as $complainId){
						$complainData = $this->complain_model->getComplainData(array('complain_id'=>$complainId));
						// printArray($complainData,1);
						// if($complainData['is_resolved'] == 1){
							$managementCommitteeData = $this->management_committee_model->getManagementCommitteeData(array(
			                    'society_id' => $complainData['society_id'],
			                    'is_active' => 1,
			                    'is_api' => 1,
			                    'is_multiple' => 1
			                ));
			                if(!empty($managementCommitteeData)){
			                    foreach($managementCommitteeData as $managementCommitteeElement){
			                        $ownershipFlatMemberIdArray[] = $managementCommitteeElement['member_id'];
			                    }
			                }
			                if(!empty($ownershipFlatMemberIdArray)){
			                	$ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
	                                'ownership_flat_member_id' => $ownershipFlatMemberIdArray,
	                                'is_show_all_member' => 1,
	                                'is_multiple' => 1,
	                                'is_active' => 1
	                            ));

			                
	                            if(!empty($ownershipFlatMemberData)){
	                                foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
	                                    $memberIdArray[] = $ownershipFlatMember['member_id'];
	                                }
	                            }

				                $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
					                'resource_type_name' => RESOURCE_TYPE_MEMBER,
					                'society_id' => $this->session->get('society_id'),
					            ));

			                    $userSocietyCommitteeData = $this->common_web_service_model->getUserSocietyData(array(
			                        'society_id' => $this->session->get('society_id'),
			                        'resource_type_id' => $resourceTypeData['resource_type_id'],
			                        'type_id' => $memberIdArray,
			                        'user_id_not' => $this->data['userId'],
			                        'is_multiple' => 1
			                    ));

			                    if (!empty($userSocietyCommitteeData)) {
			                        foreach ($userSocietyCommitteeData as $userSocietyCommitteeElement) {
			                            $userDeviceUserIdArray[] = isset($userSocietyCommitteeElement['user_society_id']) ? $userSocietyCommitteeElement['user_society_id'] : 0;
			                        }


			                        $userMemberDevice = $this->common_web_service_model->deviceData(array(
			                            "user_society_id" => $userDeviceUserIdArray,
			                            "user_type" => MEMBER_APP,
			                            "is_latest" => 1,
			                            "is_multiple" => 1
			                        ));
			                        $resourceTypeManagerData = $this->resource_type_model->getResourceTypeData(array(
						                'resource_type_name' => RESOURCE_TYPE_MANAGER,
						                'society_id' => $this->session->get('society_id'),
						            ));

			                        $userManagerData = $this->common_web_service_model->getUserSocietyData(array(
			                            'society_id' => $this->session->get('society_id'),
			                            'resource_type_id' =>  $resourceTypeManagerData['resource_type_id'],
			                            'user_id_not' => $this->data['userId'],
			                            'is_active' => 1,
			                            'is_multiple' => 1
			                        ));

			                        if (!empty($userManagerData)) {
			                            foreach ($userManagerData as $userManagerCommittee) {
			                                $userDeviceManagerIdArray[] = isset($userManagerCommittee['user_society_id']) ? $userManagerCommittee['user_society_id'] : 0;
			                            }

			                            $userManagerDevice = $this->common_web_service_model->deviceData(array(
			                                "user_society_id" => $userDeviceManagerIdArray,
			                                "user_type" => MANAGER_APP,
			                                "is_latest" => 1,
			                                "is_multiple" => 1
			                            ));
			                        }

			                        $userMergeArray = array_merge($userMemberDevice,$userManagerDevice);
			                        if (!empty($userMergeArray)) {
			                            foreach ($userMergeArray as $userDeviceElement) {
			                                if ($userDeviceElement['one_signal_id'] != '' && $userDeviceElement['device_id'] != '') {
			                                    $notificationArray = array(
			                                        'ownership_flat_id' => 0,
			                                        'ownership_flat_member_id' => isset($userDeviceElement['type_id']) ? $userDeviceElement['type_id'] : 0,
			                                        'type' => 'complain',
			                                        'status' => 'complain_resolved',
			                                        'type_id' => $complainId,
			                                        'user_id' => $this->data['userId'],
			                                        'complain_title' => $complainData['complain_title'],
			                                        'complain_number' => $complainData['complain_number'],
			                                        // 'description' => $complainData['description'],
			                                        'member_name' => $complainData['complainant_name'],
			                                        'society_id' => $this->session->get('society_id'),
			                                        'notification_title' => 'Complain Status Updated '.$complainData['complain_number'],
			                                        'description' => 'Your complain regarding '.$complainData['complain_title'].' has been updated. Please check the app for the latest details and status.',
			                                        'module' => 'complain',
			                                        'action_type' => 'sent',
			                                        'device_type' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
			                                        'notification_for' => isset($userDeviceElement['device_type']) ? strtolower($userDeviceElement['device_type']) : '',
			                                        'one_signal_id' => isset($userDeviceElement['one_signal_id']) ? $userDeviceElement['one_signal_id'] : '',
			                                        'device_id' => isset($userDeviceElement['device_id']) ? $userDeviceElement['device_id'] : '',
			                                        'app_url' => MEMBER_URL .'ticket_detail_page/' . $complainId,
			                                    );

			                                    
		                                        $notificationArray['send_for_notification'] = 'admin';
		                                        $notificationArray['send_for_notification_id'] = $this->data['userId'];
		                                        $notificationArray['receive_for_notification'] = isset($userDeviceElement['user_type']) ? $userDeviceElement['user_type'] : '';
		                                        $notificationArray['receive_for_notification_id'] = isset($userDeviceElement['user_type_id']) ? $userDeviceElement['user_type_id'] : 0;
			                                    
			                                    $notificationArray['extra_data_json'] = json_encode($notificationArray);
			                                    array_push($notificationDataArray, $notificationArray);
			                                }
			                            }
			                        }
		                    	}

			                    if (isset($notificationDataArray) && !empty($notificationDataArray)) {
			                        sendNotificationComplainAndroid($notificationDataArray);
			                    }
			                }   
						// }
					}
				}
				$transactionStatus = $this->db->transComplete();
				if($transactionStatus == 1){
					$response['success']  = true;
					$response['msg']      = "Complain Status Change Successfully";
				}
				else{
					$response['success']  = false;
					$response['msg']      = "Complain Status Change Error!";
				}
			} else {
				$response['success']  = false;
				$response['msg']      = "Complain Status Change Error!";
			}
			echo json_encode($response);
			exit();
		}
	}

	public function getUserDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $userId       = $this->request->getVar('user_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'user_id' => $userId,

        );
        echo $this->complain_model->getUser($filterData);
    }

    public function getGroupDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $groupId       = $this->request->getVar('group_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'group_id' => $groupId,

        );
        echo $this->complain_model->getGroup($filterData);
    }
}
