<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\CommonKeysModel;
use App\Models\KeyIssueModel;
use App\Models\SocietyModel;

class CommonKeys extends BaseController
{
	protected $common_keys_model;
    public function __construct() {
        $this->common_keys_model = new CommonKeysModel();
        $this->key_issue_model = new KeyIssueModel();
        $this->society_model = new SocietyModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Common Keys';
        return $this->dt_ci_template->load("Admin","CommonKeys/CommonKeysView",$data);
	}

	public function manage($commonKeysId = '')
	{

		$data['extra_js'] = array(
            "js/jquery.form.min.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/bootstrap-datepicker/bootstrap-datepicker.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
        );

        if ($commonKeysId != '') {
			$filterData = array(
				"common_keys_id" => $commonKeysId
			);
			$data['common_keys_data'] = $this->common_keys_model->getCommonKeysData($filterData);

            $commonKeysAvailabilityData = $this->common_keys_model->getCommonKeysAvailabilityData(array(
                'common_keys_id' => $commonKeysId,
                'is_multiple' => 1
            ));
            $data['key_availability_data'] = $commonKeysAvailabilityData;
		}
		if ($commonKeysId != '') {
			$data['title'] = 'Edit Common Keys';
		} else {
			$data['title'] = 'Add Common Keys';
		}

		if ((isset($data['common_keys_data']['society_id']) && $data['common_keys_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/CommonKeys');
        }
        $data['key_availability_table'] = view('Admin/CommonKeys/KeyAvailabilityTableView', isset($data) ? $data : array());
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Ajax)? $select2Ajax : array());
		return $this->dt_ci_template->load("Admin","CommonKeys/CommonKeysManageView",$data);
	}

    public function getCommonKeysListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_common_keys as tck");
		$this->datatables->select("tck.common_keys_id,ts.society_name,ts.society_name,tck.is_active,tck.description,tck.remarks,GROUP_CONCAT(COALESCE(tcka.keys_name,'') SEPARATOR ', ') as keys_name");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tck.updated_at");
		$this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tck.society_id","left");
		$this->datatables->join("tbl_common_keys_availability as tcka","tcka.common_keys_id = tck.common_keys_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tck.updated_by AND tupdate.society_id = tck.society_id","left");
		$this->datatables->groupBy("tck.common_keys_id");
		accessFilter($this->datatables, array("society" => "tck.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"common_keys_id" => isset($data[$key]['common_keys_id']) ? $data[$key]['common_keys_id'] : ""
				);
				$data[$key]['action_button'] = commonKeysActionButton($actionButtonFilter);
				$data[$key]['updated_at'] = isValidDate($data[$key]['updated_at']) ? siteDateFormat($data[$key]['updated_at'],true) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $commonKeysId = $this->request->getVar('common_keys_id');
        $status = $this->request->getVar('status');
        $return = $this->common_keys_model->statusChange($commonKeysId,$status,'common_keys_id','tbl_common_keys');
		if ($return == 1) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('CommonKeys.common_keys'));
        } else {
            $response['success'] = false;
            $response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('CommonKeys.common_keys'));
        }
		echo json_encode($response);
		exit;
    }

    public function save()
	{
        $this->db->transStart();
		$validation = \Config\Services::validation();
		$commonKeysId = $this->request->getVar('common_keys_id');
		$description = $this->request->getVar("description");
		$remarks = $this->request->getVar("remarks");
		$isActive = $this->request->getVar("is_active");

        $keysNameArray = $this->request->getVar('keys_name');
        $commonKeysAvailabilityIdArray = $this->request->getVar('common_keys_availability_id');
		$validation->setRule('description', lang('CommonKeys.description'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

            $oldCommonKeysAvailabilityData = array();
            if(!empty($commonKeysId)){
                $oldCommonKeysAvailabilityData = $this->common_keys_model->getCommonKeysAvailabilityData(array(
                    'common_keys_id' => $commonKeysId,
                    'is_multiple' => 1
                ));
            }

			$commonKeysUpdateArray = array();
			$commonKeysArray = array(
				'common_keys_id' => $commonKeysId,
				'description' => $description,
				'society_id' => $this->session->get('society_id'),
				'remarks' => $remarks,
				'is_active' => isset($isActive) ? 1 : 0,
			);
			if(!empty($commonKeysId)){
                $commonKeysUpdateData = $this->common_keys_model->getCommonKeysData(array(
                    'common_keys_id' => $commonKeysId,
                ));
                $commonKeysUpdateArray = compareArray($commonKeysArray,$commonKeysUpdateData);
            }
			$commonKeysData = $this->common_keys_model->insertUpdateRecord($commonKeysArray, 'common_keys_id', 'tbl_common_keys', 1,'',array(),array(),$commonKeysUpdateArray);
			$lastCommonKeysId = $commonKeysData['lastInsertedId'];

            if (!empty($commonKeysAvailabilityIdArray)) {
                foreach ($commonKeysAvailabilityIdArray as $fkey => $commonKeysAvailabilityId) {
                    $keysName = array_key_exists($fkey, $keysNameArray) ? $keysNameArray[$fkey] : '';
                    if ($commonKeysAvailabilityId == '') {
                        $commonKeysAvailabilityInsertArray[$fkey] = array(
                            'common_keys_availability_id' => '',
                            'common_keys_id' => $lastCommonKeysId,
                            'keys_name' => $keysName,
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                    } else {
                        $commonKeysAvailabilityUpdateArray[$fkey] = array(
                            'common_keys_availability_id' => $commonKeysAvailabilityId,
                            'common_keys_id' => $lastCommonKeysId,
                            'keys_name' => $keysName,
                            'updated_by' => $this->data['userId'],
                            'updated_at' => date("Y-m-d h:i:s"),
                        );
                    }
                }
//              printArray($oldcommonKeysAvailabilityData,1);
                $commonKeysAvailabilityExtraDataArray = array();
                $commonKeysAvailabilityExtraDataArray['module_id'] = $lastCommonKeysId;
                $commonKeysAvailabilityExtraDataArray['module'] = 'Common Keys Availability';
                $commonKeysAvailabilityExtraDataArray['type'] = 'Common Keys';
                $commonKeysAvailabilityExtraDataArray['old_data'] = $oldCommonKeysAvailabilityData;
                $commonKeysAvailabilityExtraDataArray['user_id'] = $this->data['userId'];
                $commonKeysAvailabilityExtraDataArray['society_id'] = $this->session->get('society_id');
                if (!empty($commonKeysAvailabilityInsertArray)) {
                    $this->common_keys_model->batchInsert($commonKeysAvailabilityInsertArray, 'tbl_common_keys_availability',$commonKeysAvailabilityExtraDataArray);
                }
                if (!empty($commonKeysAvailabilityUpdateArray)) {
                    $this->common_keys_model->batchUpdate($commonKeysAvailabilityUpdateArray, "common_keys_availability_id", 'tbl_common_keys_availability',$commonKeysAvailabilityExtraDataArray);
                }
            }
            $transactionStatus = $this->db->transComplete();
			if (isset($commonKeysId) && $commonKeysId != '') {
                if (($commonKeysData['success']) && ($transactionStatus == 1)) {
                    $response['success']    = true;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record'),lang('CommonKeys.common_keys'));
                } else {
                    $response['success']    = false;
                    $response['msg']        = sprintf(lang('CommonMessage.update_record_error'),lang('CommonKeys.common_keys'));
                }
            } else {
                if (($commonKeysData['success']) && ($transactionStatus == 1)) {
                    $response['success']  = true;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record'),lang('CommonKeys.common_keys'));
                } else {
                    $response['success']  = false;
                    $response['msg']      = sprintf(lang('CommonMessage.create_record_error'),lang('CommonKeys.common_keys'));
                }
            }
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
        $commonKeysId = $this->request->getVar('common_keys_id');
        if( isReferenceInTable( 'common_keys_id','tbl_key_issue', $commonKeysId)
       ){
           if(!empty($commonKeysId)){
               foreach($commonKeysId as $commonKeys){
                   $deleteDataArray['module'] = 'Common Keys';
                   $deleteDataArray['activity'] = "Tried to delete Common Keys ";
                   $deleteDataArray['module_id'] = $commonKeys;
                   logActivity('Tried to delete Common Keys [CommonKeysID: ' . $commonKeys . ']',$this->data['userId'],'Common Keys',$commonKeys,json_encode($deleteDataArray),'','Common Keys',$commonKeys);
               }
           }

           $response['success'] = false;
           $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
           echo json_encode($response);
           exit;
       }

        $keyIssueData = $this->key_issue_model->getKeyIssueData(array('common_keys_id' => $commonKeysId,'is_multiple' => 1));

        $keyNameArray = array();
        if(!empty($keyIssueData)){
            foreach($keyIssueData as $keyIssueElement){
                array_push($keyNameArray,$keyIssueElement['keys_name']);
            }
        }
        if(!empty($keyNameArray)){
            $keyNameArray = array_unique($keyNameArray);
            $keyName = implode(",", $keyNameArray);
            $response['success'] = false;
            $response['msg'] = $keyName. " Already Issued So Can't Deleted " ;
            echo json_encode($response);
            exit;
        }

        $commonKeysData = $this->common_keys_model->deleteRecord($commonKeysId);
        $transactionStatus = $this->db->transComplete();
        if (($commonKeysData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("CommonKeys.common_keys"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("CommonKeys.common_keys"));
        }
        echo json_encode($response);
        exit;
    }

    public function view($id = null)
	{
		$commonKeysId = $this->request->getVar("view_id");
		if($commonKeysId == "" && $commonKeysId == null){
            return redirect()->to('Admin/CommonKeys');
		}
		else {
			$id = $commonKeysId;
			$filterData = array(
				"common_keys_id" => $commonKeysId
			);
			$data['common_keys_data'] = $this->common_keys_model->getCommonKeysData($filterData);
			$data['common_keys_issue_data'] = $this->common_keys_model->getCommonKeysIssueData(array("common_keys_id" => $commonKeysId,"is_multiple" => 1));

            $data['key_issue_data'] = $this->key_issue_model->getKeyIssueData(array('common_keys_id' => $commonKeysId,'is_multiple' => 1));
		    // printArray($data['complaint_history_data'],1);

			$commonKeysView = view("Admin/CommonKeys/CommonKeysModelView", $data);
			$response['view_title'] = "Common Keys Details";
			$response['view_detail'] = $commonKeysView;
			$response['success'] = true;
			echo json_encode($response);
		}
	}

    public function excelExportCommonKeys()
    {
        $fileName ='CK-' . DATETIMEFORMAT;
        $sheetName = 'CK-' . DATEFORMAT;
        $excelHeaderName = 'Common Keys';
        $tableData = $this->getCommonKeysListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            // lang('CommonKeys.society'),
            lang('CommonKeys.description'),
            lang('CommonKeys.remarks'),
            lang('CommonKeys.keys_set'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                // $row["society_name"],
                $row["description"],
                $row["remarks"],
                $row["keys_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'E';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        excelExport($excelFilterData);
    }

    public function addKeyAvailabilityRow()
    {
        $data['row_number'] = $this->request->getVar("row_number");
        $mobileRow = view('Admin/CommonKeys/KeyAvailabilityTableRowView', $data);
        echo $mobileRow;
    }

    public function deleteKeyAvailabilityRow()
    {
        $this->db->transStart();
        $commonKeysAvailabilityId = $this->request->getVar('common_keys_availability_id');
        $commonKeysId = $this->request->getVar('common_keys_id');

        $keyIssueData = $this->key_issue_model->getKeyIssueData(array('common_keys_availability_id' => $commonKeysAvailabilityId,'is_multiple' => 1));

        $keyNameArray = array();
        if(!empty($keyIssueData)){
            foreach($keyIssueData as $keyIssueElement){
                array_push($keyNameArray,$keyIssueElement['keys_name']);
            }
        }
        if(!empty($keyNameArray)){
            $keyNameArray = array_unique($keyNameArray);
            $keyName = implode(",", $keyNameArray);
            $response['success'] = false;
            $response['msg'] = $keyName. " Already Issued So Can't Deleted " ;
            echo json_encode($response);
            exit;
        }

        $commonKeysAvailabilityData = $this->common_keys_model->deleteCommonKeysAvailabilityRecord($commonKeysAvailabilityId,$commonKeysId);
        $transactionStatus = $this->db->transComplete();
        if (($commonKeysAvailabilityData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('CommonKeys.common_keys_availability'));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('CommonKeys.common_keys_availability'));
        }
        echo json_encode($response);
        exit();
    }


    public function getCommonKeysDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $commonKeysId = $this->request->getVar('common_keys_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'common_keys_id' => $commonKeysId,

        );
        echo $this->common_keys_model->getCommonKeys($filterData);
    }

    public function getCommonKeysAvailabilityDd(){
        $filterParameter = $this->request->getVar('filter_param');
        $page            = $this->request->getVar('page');
        $commonKeysAvailabilityId = $this->request->getVar('common_keys_availability_id');
        $commonKeysId = $this->request->getVar('common_keys_id');

        $filterData = array(
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'limit' => DATA_LIMIT,
            'is_active' => 1,
            'common_keys_availability_id' => $commonKeysAvailabilityId,
            'common_keys_id' => $commonKeysId,

        );
        echo $this->common_keys_model->getCommonKeysAvailability($filterData);
    }

    public function commonKeysPdf()
    {
        if(!$this->dt_ci_acl->checkAccess('CommonKeys|pdf')){
            return show_error(NO_ACCESS_SECTION);
        } else {
            $societyData = $this->society_model->getSocietyData(array(
                "society_id" => $this->session->get('society_id'),
            ));
            $data['society_data'] = $societyData;
            $filterData = array(
                'is_multiple' => 1,
            );
            $commonKeysData = $this->common_keys_model->getCommonKeysData($filterData);
            $commonKeysAvailabilityData = $this->common_keys_model->getCommonKeysAvailabilityData(array(
                'society_id' => $this->session->get('society_id'),
                'is_multiple' => 1
            ));
            $keyNameArray = array();
            if(!empty($commonKeysAvailabilityData)){
                foreach($commonKeysAvailabilityData as $commonKeysAvailabilityElement){
                    array_push($keyNameArray,$commonKeysAvailabilityElement['keys_name']);
                }
            }
            if(!empty($keyNameArray)){
                $keyNameArray = array_unique($keyNameArray);
            }
            $commonKeysIssueData = $this->common_keys_model->getCommonKeysIssueData(array("is_multiple" => 1));
            $commonKeysIssueDataArray = [];
            if (isset($commonKeysIssueData) && !empty($commonKeysIssueData)) {
                foreach ($commonKeysIssueData as  $commonKeysIssue) {
                    $commonKeysIssueDataArray[$commonKeysIssue['common_keys_id']][] = $commonKeysIssue;
                }
            }
            if (!empty($commonKeysData)) {
                foreach ($commonKeysData as $key => $displayData) {
                    $commonKeysData[$key]['key_issue_data'] = array_key_exists($displayData['common_keys_id'], $commonKeysIssueDataArray) ? $commonKeysIssueDataArray[$displayData['common_keys_id']] : array();
                }
            }
            $data['common_keys_data'] = $commonKeysData;
            // printArray($keyNameArray);
            // printArray($data['common_keys_data'],1);
            $keyIssueData = $this->key_issue_model->getKeyIssueData(array('is_multiple' => 1));
            $data['key_name_data'] = $keyNameArray;
            $data['key_issue_data'] = $keyIssueData;            
            $data['name'] = lang("CommonKeys.common_keys_pdf") . ".pdf";
            $printHeader = '';
            $printFooter = '';
            $printFooter = pdfFooter( 0, array());
            $html = view('Admin/CommonKeys/Pdf/CommonKeysPdfView', $data);
            generate_pdf($html, $data['name'], false, $printFooter, '', $printHeader, '', 'P');
        }
    }
}
