<?php

namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\CategoryModel;
class Category extends BaseController
{
    protected $category_model;
    public function __construct() {
        $this->category_model = new CategoryModel();
        // checkAndCreatePath(THUMBNAIL_CATEGORY_IMAGE_PATH);
    }
	public function index()
	{

		$data['extra_js'] = array(
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
		$data['title'] = 'Category';
		$data['v_category_modal'] = view('Admin/Category/CategoryModalView', $data);
		$this->dt_ci_template->load("Admin","Category/CategoryView",$data);
	}

	

    public function getCategoryListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
            $filterData['length'] = '';
            $_POST = $filterData;
        }
        $this->datatables->table("tbl_category as tc");
		$this->datatables->select("tc.category_id,tc.category_name,tc.category_for");
		$this->datatables->select("tc.is_active,tc.category_image");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by");
        $this->datatables->select("concat(COALESCE(tcreate.first_name,''),' ',COALESCE(tcreate.last_name,'')) as created_by,tc.created_at,tc.updated_at");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tc.updated_by AND tupdate.society_id = tc.society_id","left");
        $this->datatables->join(MASTER_DB.".tbl_users_info as tcreate","tcreate.id = tc.created_by AND tcreate.society_id = tc.society_id","left");
		$this->datatables->groupBy("tc.category_id");
		accessFilter($this->datatables, array("society" => "tc.society_id"));
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"category_id" => isset($data[$key]['category_id']) ? $data[$key]['category_id'] : ""
				);
				$data[$key]['action_button'] = categoryActionButton($actionButtonFilter);
				$data[$key]['display_category_for'] = underscoreToUcWord($displayData['category_for']);
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
                $data[$key]['created_at'] = isValidDate($displayData['created_at']) ? siteDateFormat($displayData['created_at'],true) : "";

				$imageUrl = '';
				$imageThumbnailUrl = '';
				if(isset($displayData['category_image']) && $displayData['category_image'] != '') {
					$imageUrl = site_url() . CATEGORY_IMAGE_PATH . $displayData['category_image'];
				}
				if(isset($displayData['category_image']) && $displayData['category_image'] != '') {
					$imageThumbnailUrl = site_url() . THUMBNAIL_CATEGORY_IMAGE_PATH . $displayData['category_image'];
				}
				$data[$key]['thumbnail_category_image'] = $imageThumbnailUrl;
				$data[$key]['category_image'] = $imageUrl;
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $categoryId = $this->request->getVar('category_id');
        $status = $this->request->getVar('status');
        $return = $this->category_model->statusChange($categoryId,$status,'category_id','tbl_category');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Category.category'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Category.category'));
		}
		echo json_encode($response);
		exit;
    }

    public function addEdit()
	{
		$this->db->transStart();
		$validation = \Config\Services::validation();
		$categoryId = $this->request->getVar('category_id');
		$categoryName = $this->request->getVar('category_name');
		$categoryFor = $this->request->getVar('category_for');
		$isActive = $this->request->getVar('is_active');

		$validation->setRule('category_for', lang('Category.category_for'), 'required');
		$validation->setRule('category_name', lang('Category.category_name'), 'required');
        if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {

			$categoryForNameCheck = $this->category_model->checkCategoryNameExist(array('category_id' => $categoryId,'category_name' => $categoryName,'category_for' => $categoryFor));

            if(!empty($categoryForNameCheck)){
                $response['success'] = false;
                $response['msg'] = "This Category For ".underscoreToUcWord($categoryForNameCheck['category_for']). " Category Name ". $categoryName. " Already Exists";
                echo json_encode($response);
                exit();
            }
			$categoryUpdateArray = array();
			$categoryArray = array(
				'category_id' => $categoryId,
				'category_name' => $categoryName,
				'category_for' => $categoryFor,
				'is_active' => isset($isActive) ? 1 : 0,
				'society_id' => $this->session->get('society_id'),
			);
			if(!empty($categoryId)){
                $categoryUpdateData = $this->category_model->getCategoryData(array(
                    'category_id' => $categoryId,
                ));
                $categoryUpdateArray = compareArray($categoryArray,$categoryUpdateData);
            }
			$categoryData = $this->category_model->insertUpdateRecord($categoryArray, 'category_id', 'tbl_category', 1,'',array(),$categoryUpdateArray);
			$lastCategoryId = $categoryData['lastInsertedId'];
			if (isset($categoryData['success']) && $categoryData['success']) {
				if (isset($_FILES['category_image'])) {
					$categoryImagePath    = CATEGORY_IMAGE_PATH;
					$imageResult        = $this->dt_ci_file_upload->UploadFile('category_image', MAX_IMAGE_SIZE_LIMIT, $categoryImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
					if ($imageResult['success'] == false) {
						$response['success']    = false;
						$response['msg']        = strip_tags($imageResult['message']);
						echo json_encode($response);
						die();
					} else {
						unset($imageResult['success']);
                    	$thumbnailResult =  $this->dt_ci_file_upload->ThumbnailUploadFile($imageResult, CATEGORY_IMAGE_PATH, THUMBNAIL_CATEGORY_IMAGE_PATH);

						if ($lastCategoryId != '') {
							$imageData = $this->category_model->getCategoryData(array("category_id" => $lastCategoryId));
							$imageUrl = '';
							if(isset($imageData['category_image']) && $imageData['category_image'] != '') {
								$imageUrl = CATEGORY_IMAGE_PATH. $imageData['category_image'];
							}
							if (file_exists($imageUrl)) {
								unlink($imageUrl);
							}

							$thumbnailImageUrl = '';
							if(isset($imageData['category_image']) && $imageData['category_image'] != '') {
								$thumbnailImageUrl = THUMBNAIL_CATEGORY_IMAGE_PATH. $imageData['category_image'];
							}
							if (file_exists($thumbnailImageUrl)) {
								unlink($thumbnailImageUrl);
							}
						}
						unset($imageResult['success']);
						$imageUpdateArray = array(
							'category_id' => $lastCategoryId,
							'category_image' => $imageResult['file_name'],
						);
						$this->category_model->insertUpdateRecord($imageUpdateArray, 'category_id','tbl_category');
					}
				}
			}
			$transactionStatus = $this->db->transComplete();
			if (isset($categoryId) && $categoryId != '') {
				if (($categoryData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Category.category"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Category.category"));
				}
			} else {
				if (($categoryData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Category.category"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Category.category"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
    	$this->db->transStart();
        $categoryId = $this->request->getVar('category_id');
        if( isReferenceInTable( 'category_id','tbl_complain', $categoryId) ||
    		isReferenceInTable( 'category_id','tbl_event_category', $categoryId) ||
    		isReferenceInTable( 'category_id','tbl_notice_category', $categoryId) ||
    		isReferenceInTable( 'category_id','tbl_visitor', $categoryId) ||
    		isReferenceInTable( 'category_id','tbl_resource', $categoryId) ||
    		isReferenceInTable( 'category_id','tbl_vendor_category', $categoryId)){

        	if(!empty($categoryId)){
				foreach($categoryId as $category){
					$deleteDataArray['module'] = 'Category';
            		$deleteDataArray['activity'] = "Category Deleted";
					$deleteDataArray['module_id'] = $category;
					logActivity('Category Deleted [CategoryID: ' . $category . ']',$this->data['userId'],'Category',$category,json_encode($deleteDataArray),'','Category',$category);
				}
			}
            $response['success'] = false;
            $response['msg'] = lang('CommonMessage.common_delete_record_dependency');
            echo json_encode($response);
            exit;
        }

        $categoryData = $this->category_model->getCategoryData(array(
			"category_id" => $categoryId,
			"is_multiple" => 1,
		));
		if(is_array($categoryData) && !empty($categoryData)){
			foreach ($categoryData as $category){
				$imageUrl = '';
				if(isset($category['category_image']) && $category['category_image'] != '') {
					$imageUrl = CATEGORY_IMAGE_PATH . $category['category_image'];
				}
				if (file_exists($imageUrl)) {
					unlink($imageUrl);
				}

				$thumbnailImageUrl = '';
				if(isset($category['category_image']) && $category['category_image'] != '') {
					$thumbnailImageUrl = THUMBNAIL_CATEGORY_IMAGE_PATH. $category['category_image'];
				}
				if (file_exists($thumbnailImageUrl)) {
					unlink($thumbnailImageUrl);
				}
			}
		}
		
        $categoryData = $this->category_model->deleteRecord($categoryId);
        $transactionStatus = $this->db->transComplete();
        if (($categoryData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Category.category"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Category.category"));
        }
        echo json_encode($response);
        exit;
    }

    public function getCategoryDd(){
    	$filterParameter = $this->request->getVar('filter_param');
        $page = $this->request->getVar('page');
        $categoryId = $this->request->getVar('category_id');
        $categoryFor = $this->request->getVar('category_for');
        $filterData = array(
            'category_id' => $categoryId,
            'category_for' => $categoryFor,
            'filter_param' => $filterParameter,
            'page' => $page,
            'start' => 0,
            'is_active' => 1,
            'limit' => DATA_LIMIT
        );
        echo $this->category_model->getCategory($filterData);
    }

	public function excelExportCategory()
    {
        $fileName ='category-' . DATETIMEFORMAT;
        $sheetName = 'Category-' . DATEFORMAT;
        $excelHeaderName = 'Category';
        $tableData = $this->getCategoryListing(true, $_GET);
        $dataRows = array();
        $dataRows[] = array(
            lang('Category.category_for'),
            lang('Category.category_name'),
            lang('CommonMessage.common_updated_by'),
            lang('CommonMessage.common_updated_at')
        );
        foreach ($tableData as $row) {
            $dataRows[] = array(
                underscoreToUcWord($row["category_for"]),
                $row["category_name"],
                $row["updated_by"],
                $row["updated_at"]
            );
        }
        $subTotalCellValueArray = [];
        $toColumn = 'D';
        $excelFilterData = array(
            'file_name' => $fileName,
            'sheet_name' => $sheetName,
            'excel_header_name' => $excelHeaderName,
            'data_row' => $dataRows,
            'sub_total_cell_value_array' => $subTotalCellValueArray,
            'to_column' => $toColumn,
            'skip_header' => false,
            'ignore_currency_symbols_sub_total_cell_value_array' => array(),
            'row_cell_currency_format' => array()
        );
        //excelExport($filename,$sheetName,$excelHeaderName,$dataRows,$subTotalCellValueArray,$toColumn,false,array(),array());
        excelExport($excelFilterData);
    }

}
