<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\AmenitiesModel;
use App\Models\BookingModel;
use App\Models\TimeSlotModel;
class BookingCalendar extends BaseController
{
    protected $amenities_model;
    public function __construct() {
        $this->amenities_model = new AmenitiesModel();
        $this->booking_model = new BookingModel();
        $this->time_slot_model = new TimeSlotModel();
    }
    public function index()
    {
        $data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js"
        );
        $data['title'] = 'Booking Calendar';
        return $this->dt_ci_template->load("Admin","BookingCalendar/BookingCalendarView",$data);
    }

    public function bookingData(){
        $bookingYear = $this->request->getVar("booking_year");
        $bookingMonth = $this->request->getVar("booking_month");

        if(!empty($bookingMonth) && !empty($bookingYear)) {
            $monthName = date('M', mktime(0, 0, 0, $bookingMonth, 10)); // March
            $amenitiesFilterData = array(
                "is_multiple" => 1,
                "type" => "amenities",
                "is_active" => 1,
            );
            $amenitiesData = $this->amenities_model->getAmenitiesData($amenitiesFilterData);
            $timeSlotData = $this->time_slot_model->getTimeSlotData(array(
                'is_multiple' => 1
            ));

            $timeSlotId = [];
            if (!empty($timeSlotData)) {
                foreach ($timeSlotData as $key => $displayData) {
                    array_push($timeSlotId,$displayData['time_slot_id']);
                }
            }
            $amenitiesTimeSlotWiseData = array();

            if(!empty($amenitiesData)){
                foreach($amenitiesData as $amenitiesElement){
                    $amenitiesTimeSlotObject = array();
                    $amenitiesTimeSlotObject = $amenitiesElement;
                    $amenitiesTimeSlotObject['time_slot_data'] = $timeSlotData;
                    array_push($amenitiesTimeSlotWiseData,$amenitiesTimeSlotObject);
                }
            }
//			printArray($amenitiesTimeSlotWiseData,1);
            //query for count booking
            $hallFilterData = array(
                "is_multiple" => 1,
                "start_month" => $bookingMonth,
                "start_year" => $bookingYear,
            );
            $bookingData = $this->booking_model->getBookingData($hallFilterData);

            $bookingDataDateWise = array();
            $bookingDataDateWiseTimeSlot = array();

            if (!empty($bookingData)) {
                foreach ($bookingData as $qKey => $booking) {
                    $bookingStartDate = date('d', strtotime($booking['booking_date']));
                    $dayOfMonth = $bookingStartDate;
                    $bookingDataDateWise[ltrim($dayOfMonth, 0)][] = $booking;
                    $bookingDataDateWiseTimeSlot[ ltrim($dayOfMonth, 0)][$booking['amenities_id'].'|'.$booking['time_slot_id']] = $booking;
                }
            }

//			printArray($bookingDataDateWiseTimeSlot,1);

            $returnHtml = '';
            $monthDays = cal_days_in_month(CAL_GREGORIAN, $bookingMonth, $bookingYear);

            $returnHtml .= '<table class="table table-bordered table-xs dt-no-padding-table text-center">';
            $returnHtml .= '<tbody>';
            $returnHtml .= '<tr>';
            $returnHtml .= '<td rowspan="3" style="width: 150px"></td>';
            //month name
            for ($mNo = 1; $mNo <= $monthDays; $mNo++) {
                $returnHtml .= '<td class="">' . $monthName . '</td>';
            }
            $returnHtml .= '</tr>';

            //month number
            $returnHtml .= '<tr>';
            for ($mNo = 1; $mNo <= $monthDays; $mNo++) {
                $returnHtml .= '<td class="">' . $mNo . '</td>';
            }
            $returnHtml .= '</tr>';

            //day name
            $returnHtml .= '<tr>';
            for ($mNo = 1; $mNo <= $monthDays; $mNo++) {
                $monthDate = '' . $mNo . '-' . $bookingMonth . '-' . $bookingYear . '';
                $nameOfDay = date('D', strtotime($monthDate));
                $returnHtml .= '<td class="">' . $nameOfDay . '</td>';
            }
            $returnHtml .= '</tr>';

            //booking count month wise
            $returnHtml .= '<tr>';
            $returnHtml .= '<td class="">Booking</td>';
            for ($mNo = 1; $mNo <= $monthDays; $mNo++) {
                $bookingCount = 0;
                if (array_key_exists($mNo, $bookingDataDateWise)) {
                    $bookingCount = count($bookingDataDateWise[$mNo]);
                }
                $returnHtml .= '<td class="">' . $bookingCount . '</td>';
            }
            $returnHtml .= '</tr>';

            if(!empty($amenitiesTimeSlotWiseData)){
                foreach($amenitiesTimeSlotWiseData as $aKey => $amenitiesTimeSlotWiseElement){

                    $timeSlotData = $amenitiesTimeSlotWiseElement['time_slot_data'];
                    if(!empty($timeSlotData)){
                        foreach ($timeSlotData as $atKey => $timeSlotElement){
                            $returnHtml .= '<tr class="">';
                            if ($atKey == 0) {
                                $returnHtml .= '<td class="" rowspan="'.count($timeSlotData).'">' . $amenitiesTimeSlotWiseElement['amenities_name'] . '</td>';
                            }

                            for ($mNo = 1; $mNo <= $monthDays; $mNo++) {
                                $bookingClass = "bg-success";
                                $bookingId = 0;
                                if (array_key_exists($mNo, $bookingDataDateWiseTimeSlot)) {
                                    $bookedData = $bookingDataDateWiseTimeSlot[$mNo];
                                    if(isset($bookedData[$amenitiesTimeSlotWiseElement['amenities_id'].'|'.$timeSlotElement['time_slot_id']])){
                                        $bookingClass = "bg-danger";
                                        $bookingId = $bookedData[$amenitiesTimeSlotWiseElement['amenities_id'].'|'.$timeSlotElement['time_slot_id']]['booking_id'];
                                    }
                                }
                                if($bookingClass == "bg-danger"){
                                    $returnHtml .= '<td class="' . $bookingClass . ' text-white dt-detail-model-view" data-dt_view_id="'.$bookingId.'" data-dt_view_url="'.  admin_url('Booking/view'). '" >' . $timeSlotElement['time_slot_name'] . '</td>';
                                } else {
                                    $returnHtml .= '<td class="' . $bookingClass . ' text-white  ">' . $timeSlotElement['time_slot_name'] . '</td>';
                                }

                            }

                            $returnHtml .= '</tr>';
                        }
                    }
                }
            }
            $returnHtml .= '</tbody>';
            $returnHtml .= '</table>';
            echo $returnHtml;
        }
    }
}
