<?php

namespace App\Controllers\Admin;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\CLIRequest;
use CodeIgniter\HTTP\IncomingRequest;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;
use App\Libraries\Dt_ci_template;
use App\Libraries\Dt_ci_file_upload;
use App\Libraries\Datatables;
use App\Models\ProductCategoryModel;
use CodeIgniter\Events\Events;
use App\Services\DatabaseService;
/**
 * Class BaseController
 *
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 * Extend this class in any new controllers:
 *     class Home extends BaseController
 *
 * For security be sure to declare any new methods as protected or private.
 */
abstract class BaseController extends Controller
{
    /**
     * Instance of the main Request object.
     *
     * @var CLIRequest|IncomingRequest
     */
    protected $request;

    /**
     * An array of helpers to be loaded automatically upon
     * class instantiation. These helpers will be available
     * to all other controllers that extend BaseController.
     *
     * @var list<string>
     */
    protected $helpers = ['Dt_ci_site_helper','form','Dt_ci_action_button_helper','Dt_ci_item_helper','number','Dt_ci_pdf_helper'];

    /**
     * Be sure to declare properties for any property fetch you initialized.
     * The creation of dynamic property is deprecated in PHP 8.2.
     */
    // protected $session;

    /**
     * @return void
     */

    public $dt_ci_template;
    public $dt_ci_file_upload;
    public $datatables;
    public $data ;
    // public $db = 0;
    protected $db;
    public $dt_ci_acl;
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);
        // Preload any models, libraries, etc, here.
        checkAndCreatePath(MEDIA_IMAGE_PATH);
        checkAndCreatePath(DOCUMENT_IMAGE_PATH);
        checkAndCreatePath(MEETING_RECORD_PATH);
        checkAndCreatePath(FLAT_MEMBER_IMAGE_PATH);

        $locale = $this->request->getLocale();
        $this->dt_ci_template = new dt_ci_template();
        $this->dt_ci_file_upload = new dt_ci_file_upload();
        $this->session       = \Config\Services::session();
        $this->ionAuth    = new \App\Libraries\IonAuth();
        $this->data['userId'] = $this->ionAuth->getUserId();
        $this->centralDB = \Config\Database::connect();
        $this->databaseService = new DatabaseService();
        $societyId = session()->get('society_id') ?? $this->request->getPost('society_id');
        if ($societyId) {
            $this->db = $this->databaseService->getTenantConnection($societyId);
            $this->db = $this->db ?? $this->centralDB;        
        }
        $this->datatables = new \App\Libraries\Datatables($this->db);
        $this->dt_ci_acl    = new \App\Libraries\Dt_ci_acl();
        Events::on('post_controller_constructor', [$this->dt_ci_acl, 'checkPermission']);
    }
}
