<?php
namespace App\Controllers\Admin;
use CodeIgniter\Controller;
use App\Models\BannerModel;
use App\Models\SocietyModel;
use App\Models\VisitorModel;
use App\Models\CommonWebServiceModel;
use App\Models\FinancialYearModel;
use App\Models\OwnershipFlatModel;
use App\Models\ResourceTypeModel;

class Banner extends BaseController
{
    protected $banner_model;
    protected $society_model;
    protected $financial_year_model;
    public function __construct() {
        $this->banner_model = new BannerModel();
        $this->society_model = new SocietyModel();
        $this->financial_year_model = new FinancialYearModel();
        $this->visitor_model = new VisitorModel();
        $this->common_web_service_model = new CommonWebServiceModel();
        $this->ownership_flat_model = new OwnershipFlatModel();
        $this->resource_type_model = new ResourceTypeModel();
    }
	public function index()
	{
		$data['extra_js'] = array(
            "vendor/libs/datatables-bs5/datatables-bootstrap5.js",
            "vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
            "js/jquery.form.min.js",
            "js/validate.min.js",
            "js/additional_methods.min.js",
			"vendor/libs/moment/moment.js",
			"vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js"
        );
		$data['title'] = 'Banner';
		$this->dt_ci_template->load("Admin","Banner/BannerView",$data);
	}

	public function manage($bannerId = '')
	{
		$data['extra_js'] = array(
			"js/jquery.form.min.js",
			"vendor/libs/sweetalert2/sweetalert2.js",
            "vendor/libs/toastr/toastr.js",
			"vendor/libs/flatpickr/flatpickr.js",
			"js/validate.min.js",
			"js/additional_methods.min.js",
			"vendor/libs/ckeditor/ckeditor_classic.js",
		);

        if ($bannerId != '') {
			$filterData = array(
				"banner_id" => $bannerId
			);
			$data['banner_data'] = $this->banner_model->getBannerData($filterData);

			$data['image_data'] = $this->visitor_model->getDocumentImageData(array(
                "document_type_id" => $bannerId,
                "document_type" => 'banner',
                "is_multiple" => 1
            ));

			if (empty($data['banner_data'])) {
                return redirect()->to('Admin/Banner');
            }
		}
		if ($bannerId != '') {
			$data['title'] = 'Edit Banner';
		} else {
			$data['title'] = 'Add Banner';
		}
		$data['select2_ajax'] = view("Admin/CommonMaster/Select2View", isset($select2Condition) ? $select2Condition : array());
		if ((isset($data['banner_data']['society_id']) && $data['banner_data']['society_id'] != $this->session->get('society_id'))) {
            return redirect()->to('Admin/Banner');
        }
		$this->dt_ci_template->load("Admin","Banner/BannerManageView",$data);
	}

    public function getBannerListing($return = false,$filterData=array())
    {
    	if($return == TRUE){
			$filterData['length'] = '';
			$_POST = $filterData;
		}
		

        $this->datatables->table("tbl_banner as tb");
		$this->datatables->select("tb.banner_id,tb.banner_title,tb.start_date,tb.end_date,tb.description,tb.sort_order,tb.is_active");
		$this->datatables->select("concat(COALESCE(tupdate.first_name,''),' ',COALESCE(tupdate.last_name,'')) as updated_by,tb.updated_at");
		$this->datatables->join(MASTER_DB.".tbl_society as ts","ts.society_id = tb.society_id","left");
		$this->datatables->join(MASTER_DB.".tbl_users_info as tupdate","tupdate.id = tb.updated_by AND tupdate.society_id = tb.society_id","left");
		accessFilter($this->datatables, array("society" => "tb.society_id"));
		$this->datatables->groupBy("tb.banner_id");
		$dataReport =  $this->datatables->generate();
		$dataReport = json_decode($dataReport, true);
		$data       = $dataReport['data'];
		if(count($data) > 0){
			foreach($data as $key => $displayData){
				$actionButtonFilter = array(
					"banner_id" => isset($displayData['banner_id']) ? $displayData['banner_id'] : ""
				);
				$data[$key]['action_button'] = bannerActionButton($actionButtonFilter);
				$data[$key]['start_date'] = siteDateFormat($displayData['start_date']);
				$data[$key]['end_date'] = siteDateFormat($displayData['end_date']);
				$data[$key]['updated_at'] = isValidDate($displayData['updated_at']) ? siteDateFormat($displayData['updated_at'],true) : "";
			}
		}

		if($return){
			return $data;
		}else{
			$dataReport['data'] = $data;
			echo json_encode($dataReport);
			exit;
		}
        
    }

    public function changeStatus(){
        $bannerId = $this->request->getVar('banner_id');
        $status = $this->request->getVar('status');
        $isSendNotification = $this->request->getVar('is_send_notification');
        if($isSendNotification == 1 && !empty($isSendNotification)){
        	$userSocietyIdArray = array();
            $customerDataArray = array();
            $batchNotificationDataArray = array();
            $notificationMergeArray = array();
            $memberIdArray = array();
            $userSocietyIdArray = array();
            $notificationArray = array(
                'notification_title' => 'New Offer Available!',
                'description' => 'A new offer has been added by the management. Check out the latest deals and promotions on the app to take advantage of these exciting offers!',

            );
            $deviceIdArray = array();
            $iosDeviceIdArray = array();
            $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
            $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
            $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                'resource_type_name' => RESOURCE_TYPE_MEMBER,
                'society_id' => $this->session->get('society_id'),
            ));

            $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                'society_id' => $this->session->get('society_id'),
                'is_active' => 1,
                'is_transferred_not' => 1,
                'is_multiple' => 1
            ));
            if(!empty($ownershipFlatMemberData)){
                foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                    $memberIdArray[] = $ownershipFlatMember['member_id'];
                }
            }
            if(!empty($memberIdArray)){
                $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
                    "type_id" => $memberIdArray,
                    "resource_type_id" => $resourceTypeData['resource_type_id'],
                    'society_id' => $this->session->get('society_id'),
                    'is_multiple' => 1
                ));
                if(!empty($userSocietyData)){
                    foreach ($userSocietyData as $userElement) {
                        $userSocietyIdArray[] = $userElement['user_society_id'];
                    }
                }

                if(!empty($userSocietyIdArray)){
                    $userDeviceArray = $this->common_web_service_model->deviceData(array(
                        "user_society_id" => $userSocietyIdArray,
                        'user_type' => MEMBER_APP,
                        "is_latest" => 1,
                        "is_multiple" => 1,
                    ));
                }
                $sendNotificationDataArray = array();
                if(!empty($userDeviceArray)){
                    foreach($userDeviceArray as $userDevice){
                        $notificationOtherArray = array(
                            'notification_id' => '',
                            'society_id' => $this->session->get('society_id'),
                            'notification_date' => TODAY_DATE_YMD,
                            'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                            'type' => 'banner',
                            'type_id' => $bannerId,
                            // 'module' => 'poll',
                            'created_by' => $this->data['userId'],
                            'updated_by' => $this->data['userId'],
                            'created_at' => date("Y-m-d H:i:s"),
                            'updated_at' => date("Y-m-d H:i:s"),
                        );
                        $notificationOtherArray['send_for_notification'] = 'manager';
                        $notificationOtherArray['send_for_notification_id'] = $this->data['userId'];
                        $notificationOtherArray['receive_for_notification'] = MEMBER_APP;
                        $notificationOtherArray['receive_for_notification_id'] = $userDevice['user_type_id'];
                        if(!empty($notificationArray)){
                            $notificationMergeArray = array_merge($notificationArray,$notificationOtherArray);
                            $extraDataJsonArray = $notificationMergeArray;
    	                    $extraDataJsonArray['module'] = 'banner';
    	                    $extraDatajson = json_encode($extraDataJsonArray);
                            $notificationMergeArray['extra_data'] = $extraDatajson;
                            $customerData['extra_data'] = json_encode($notificationMergeArray);
                            $customerData['app_url'] = MEMBER_URL .'banner_detail_page/' . $bannerId;

                            $sendNotificationDataArray[] = array(
                                'notification_title' => 'New Offer Available!',
                                'description' => 'A new offer has been added by the management. Check out the latest deals and promotions on the app to take advantage of these exciting offers!',
                                'extra_data_json' => $extraDatajson,
                                'app_url' => MEMBER_URL .'banner_detail_page/' . $bannerId,
                                'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                'device_id' => $userDevice['device_id'],
                                'type' => 'banner',
                            );
                            //send notification data
                            // $deviceToken = $userDevice['one_signal_id'];
                            // $deviceId = $userDevice['device_id'];
                            // $batchNotificationDataArray[] = $notificationMergeArray;
                            // if(strtolower($userDevice['device_type']) == 'android'){
                            //     if (!empty($deviceId)) {
                            //         array_push($deviceIdArray,$deviceId);
                            //     }
                            // } else {
                            //     if (!empty($deviceId)) {
                            //         array_push($iosDeviceIdArray,$deviceId);
                            //     }
                            // }
                        }
                    }
                }
                if(!empty($batchNotificationDataArray)){
                    $this->ownership_flat_model->batchInsert($batchNotificationDataArray,'tbl_notification');
                }
                // $sendNotificationData = array();
                if(!empty($sendNotificationDataArray)){
                    // $customerData['device_id'] = $deviceIdArray;
                    // $sendNotificationData = $customerData;
                    sendNotification($sendNotificationDataArray);
                }
                // $sendNotificationIOSData = array();
                // if(!empty($iosDeviceIdArray)){
                //     $customerData['device_id'] = $iosDeviceIdArray;
                //     $sendNotificationIOSData = $customerData;
                //     sendNotificationIOS($sendNotificationIOSData);
                // }
            }
        }
        $return = $this->banner_model->statusChange($bannerId,$status,'banner_id','tbl_banner');
		if ($return == 1) {
			$response['success'] = true;
			$response['msg']     = sprintf(lang('CommonMessage.status_change'),lang('Banner.banner'));
		} else {
			$response['success'] = false;
			$response['msg']     = sprintf(lang('CommonMessage.status_change_error'),lang('Banner.banner'));
		}
		echo json_encode($response);
		exit;
    }

    public function save()
	{
		$this->db->transStart();
		$validation = \Config\Services::validation();
		$bannerId = $this->request->getVar('banner_id');
		$bannerTitle = $this->request->getVar('banner_title');
		$startDate = $this->request->getVar('start_date');
		$endDate = $this->request->getVar('end_date');
		$description = $this->request->getVar('description');
		$sortOrder = $this->request->getVar('sort_order');
		$isActive = $this->request->getVar('is_active');
		$validation->setRule('banner_title', lang('Banner.banner_title'), 'required');
		$validation->setRule('start_date', lang('Banner.start_date'), 'required');
		$validation->setRule('end_date', lang('Banner.end_date'), 'required');
		$validation->setRule('description', lang('Banner.description'), 'required');
		$validation->setRule('sort_order', lang('Banner.sort_order'), 'required|integer');
		if (!$validation->withRequest($this->request)->run()) {
            $errors = $validation->getErrors();
            $response['success'] = false;
            $response['msg'] = implode("\n", $errors);
            echo json_encode($response);
            exit;
        } else {
			if (strtotime($startDate) > strtotime($endDate)){
				$response['success'] = false;
				$response['msg'] = lang('Banner.banner_start_date_to_end_date_message');
				echo json_encode($response);
				exit;
			}
			$bannerImage = array();
			if (isset($_FILES["banner_image"])) {
				$bannerImagePath = DOCUMENT_IMAGE_PATH;
				$bannerImage = $this->dt_ci_file_upload->UploadMultipleFile('banner_image', MAX_IMAGE_SIZE_LIMIT, $bannerImagePath, true, true, array('jpeg', 'png', 'jpg', 'JPG'));
				if ($bannerImage['success'] == false) {
					$response['success'] = false;
					$response['msg'] = strip_tags($bannerImage['message']);
					echo json_encode($response);
					die();
				}
				else{
                    unset($bannerImage['success']);
                    $thumbnailResult =  $this->dt_ci_file_upload->ThumbnailMultipleUploadFile($bannerImage, DOCUMENT_IMAGE_PATH, THUMBNAIL_DOCUMENT_IMAGE_PATH);
                }
			}
			$bannerUpdateArray = array();
			$bannerArray = array(
				'banner_id' => $bannerId,
				'banner_title' => $bannerTitle,
				'start_date' => DMYToYMD($startDate),
				'end_date' => DMYToYMD($endDate),
				'description' => $description,
				'sort_order' => $sortOrder,
				'society_id' => $this->session->get('society_id'),
				'is_active' => isset($isActive) ? 1 : 0,
			);
			if(!empty($bannerId)){
                $bannerUpdateData = $this->banner_model->getBannerData(array(
                    'banner_id' => $bannerId,
                ));
                $bannerUpdateArray = compareArray($bannerArray,$bannerUpdateData);
            }
			$bannerData = $this->banner_model->insertUpdateRecord($bannerArray, 'banner_id', 'tbl_banner', 1,'',array(),array(),$bannerUpdateArray);
			$lastBannerId = $bannerData['lastInsertedId'];
			if($lastBannerId != ''){
                $bannerImageData = $this->visitor_model->getDocumentImageData(array(
                    "document_type_id" => $bannerId,
                    "document_type" => 'banner',
                    "is_multiple" => 1
                ));
                if(!empty($bannerImageData)){
                    foreach ($bannerImageData as $key => $value) {
                        $imageUrl = '';
                        if(isset($value['document_image']) && $value['document_image'] != '') {
                            $imageUrl = DOCUMENT_IMAGE_PATH. $value['document_image'];
                        }
                        if (file_exists($imageUrl)) {
                            unlink($imageUrl);
                        }
                        $thumbnailImageUrl = '';
                        if(isset($value['document_image']) && $value['document_image'] != '') {
                            $thumbnailImageUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH. $value['document_image'];
                        }
                        if (file_exists($thumbnailImageUrl)) {
                            unlink($thumbnailImageUrl);
                        }
                    }
                }
                if(isset($bannerImage) && count($bannerImage) > 0){
                    $batchArray = array();
                    unset($bannerImage['success']);
                    foreach ($bannerImage as $key => $imageData) {
                        $dataArray = array(
                            'document_image_id' =>   '',
                            'document_type' =>   'banner',
                            'document_type_id' => $lastBannerId,
                            'document_image' => isset($imageData['file_name']) ? $imageData['file_name'] : "",
                        );
                        array_push($batchArray, $dataArray);
                    }
                    $bannerImageExtraDataArray = array();
                    $bannerImageExtraDataArray['module_id'] = $lastBannerId;
                    $bannerImageExtraDataArray['module'] = 'Banner Image';
                    $bannerImageExtraDataArray['type'] = 'Banner';
                    $bannerImageExtraDataArray['old_data'] = array();
                    $bannerImageExtraDataArray['user_id'] = $this->data['userId'];
                    $bannerImageExtraDataArray['society_id'] = $this->session->get('society_id');
                    $this->banner_model->batchInsert($batchArray, 'tbl_document_image',$bannerImageExtraDataArray);
                }
			}
            $transactionStatus = $this->db->transComplete();
			if (isset($bannerId) && $bannerId != '') {
				if (($bannerData['success']) && ($transactionStatus == 1)) {
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.update_record'), lang("Banner.banner"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.update_record_error'), lang("Banner.banner"));
				}
			} else {
				if (($bannerData['success']) && ($transactionStatus == 1)) {

					if($bannerId == '' && empty($bannerId)){
						if(isset($isActive)){
							$memberIdArray = array();
                            $userSocietyIdArray = array();
		                    $customerDataArray = array();
		                    $batchNotificationDataArray = array();
		                    $notificationMergeArray = array();
		                    $notificationArray = array(
		                        'notification_title' => 'New Offer Available!',
		                        'description' => 'A new offer has been added by the management. Check out the latest deals and promotions on the app to take advantage of these exciting offers!',

		                    );
		                    $deviceIdArray = array();
		                    $iosDeviceIdArray = array();
                            $sendNotificationDataArray = array();
		                    $customerData['title_name'] = isset($notificationArray['notification_title']) ? $notificationArray['notification_title'] : "";
		                    $customerData['description'] = isset($notificationArray['description']) ? $notificationArray['description'] : "";
                            $resourceTypeData = $this->resource_type_model->getResourceTypeData(array(
                                'resource_type_name' => RESOURCE_TYPE_MEMBER,
                                'society_id' => $this->session->get('society_id'),
                            ));
                
                            $ownershipFlatMemberData = $this->ownership_flat_model->getOwnershipFlatMemberData(array(
                                'society_id' => $this->session->get('society_id'),
                                'is_active' => 1,
                                'is_multiple' => 1
                            ));
                            if(!empty($ownershipFlatMemberData)){
                                foreach ($ownershipFlatMemberData as $ownershipFlatMember) {
                                    $memberIdArray[] = $ownershipFlatMember['member_id'];
                                }
                            }
                            if(!empty($memberIdArray)){
                                $userSocietyData = $this->common_web_service_model->getUserSocietyData(array(
                                    "type_id" => $memberIdArray,
                                    "resource_type_id" => $resourceTypeData['resource_type_id'],
                                    'society_id' => $this->session->get('society_id'),
                                    'is_multiple' => 1
                                ));
                                if(!empty($userSocietyData)){
                                    foreach ($userSocietyData as $userElement) {
                                        $userSocietyIdArray[] = $userElement['user_society_id'];
                                    }
                                }
    		                    if(!empty($userSocietyIdArray)){
    		                        $userDeviceArray = $this->common_web_service_model->deviceData(array(
    		                            "user_society_id" => $userSocietyIdArray,
    		                            'user_type' => MEMBER_APP,
    		                            "is_latest" => 1,
    		                            "is_multiple" => 1,
    		                        ));
    		                    }
    		                    if(!empty($userDeviceArray)){
    		                        foreach($userDeviceArray as $userDevice){
    		                            $notificationOtherArray = array(
    		                                'notification_id' => '',
    		                                'society_id' => $this->session->get('society_id'),
    		                                'notification_date' => TODAY_DATE_YMD,
    		                                'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
    		                                'type' => 'banner',
    				                        'type_id' => $lastBannerId,
    		                                // 'module' => 'poll',
    		                                'created_by' => $this->data['userId'],
    		                                'updated_by' => $this->data['userId'],
    		                                'created_at' => date("Y-m-d H:i:s"),
    		                                'updated_at' => date("Y-m-d H:i:s"),
    		                            );
    		                            $notificationOtherArray['send_for_notification'] = 'manager';
    		                            $notificationOtherArray['send_for_notification_id'] = $this->data['userId'];
    		                            $notificationOtherArray['receive_for_notification'] = $userDevice['user_type'];
    		                            $notificationOtherArray['receive_for_notification_id'] = $userDevice['user_type_id'];
    		                            if(!empty($notificationArray)){
    		                                $notificationMergeArray = array_merge($notificationArray,$notificationOtherArray);
    		                                $extraDataJsonArray = $notificationMergeArray;
    					                    $extraDataJsonArray['module'] = 'banner';
    					                    $extraDatajson = json_encode($extraDataJsonArray);
    		                                $notificationMergeArray['extra_data'] = $extraDatajson;
    		                                $customerData['extra_data'] = json_encode($notificationMergeArray);
    		                                $customerData['app_url'] = MEMBER_URL .'banner_detail_page/' . $lastBannerId;
                                            $sendNotificationDataArray[] = array(
                                                'notification_title' => 'New Offer Available!',
                                                'description' => 'A new offer has been added by the management. Check out the latest deals and promotions on the app to take advantage of these exciting offers!',
                                                'extra_data_json' => $extraDatajson,
                                                'app_url' => MEMBER_URL .'banner_detail_page/' . $lastBannerId,
                                                'notification_for' => (isset($userDevice['device_type'])) ? strtolower($userDevice['device_type']) : "",
                                                'device_id' => $userDevice['device_id'],
                                                'type' => 'banner',
                                            );
    		                                //send notification data
    		                                // $deviceToken = $userDevice['one_signal_id'];
    		                                // $deviceId = $userDevice['device_id'];
    		                                // $batchNotificationDataArray[] = $notificationMergeArray;
    		                                // if(strtolower($userDevice['device_type']) == 'android'){
    		                                //     if (!empty($deviceId)) {
    		                                //         array_push($deviceIdArray,$deviceId);
    		                                //     }
    		                                // } else {
    		                                //     if (!empty($deviceId)) {
    		                                //         array_push($iosDeviceIdArray,$deviceId);
    		                                //     }
    		                                // }
    		                            }
    		                        }
    		                    }
    		                    if(!empty($batchNotificationDataArray)){
    		                        $this->ownership_flat_model->batchInsert($batchNotificationDataArray,'tbl_notification');
    		                    }
    		                    // $sendNotificationData = array();
    		                    if(!empty($sendNotificationDataArray)){
    		                        // $customerData['device_id'] = $deviceIdArray;
    		                        // $sendNotificationData = $customerData;
    		                        sendNotification($sendNotificationDataArray);
    		                    }
    		                    // $sendNotificationIOSData = array();
    		                    // if(!empty($iosDeviceIdArray)){
    		                    //     $customerData['device_id'] = $iosDeviceIdArray;
    		                    //     $sendNotificationIOSData = $customerData;
    		                    //     sendNotificationIOS($sendNotificationIOSData);
    		                    // }
                            }
						}
					}
					$response['success'] = true;
					$response['msg'] = sprintf(lang('CommonMessage.create_record'), lang("Banner.banner"));
				} else {
					$response['success'] = false;
					$response['msg'] = sprintf(lang('CommonMessage.create_record_error'), lang("Banner.banner"));
				}
			}
			echo json_encode($response);
			exit;
		}
	}

    public function delete()
    {
        $this->db->transStart();
		$bannerId = $this->request->getVar('banner_id');

		$imageData = $this->visitor_model->getDocumentImageData(array(
			"document_type_id" => $bannerId,
			"document_type" => 'banner',
			"is_multiple" =>1,
		));
		if(is_array($imageData) && !empty($imageData)){
			foreach ($imageData as $image){
				$FileUrl = '';
				if(isset($image['document_image']) && $image['document_image'] != '') {
					$FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
				}
				if (file_exists($FileUrl)) {
					unlink($FileUrl);
				}

				$thumbnailFileUrl = '';
				if(isset($image['document_image']) && $image['document_image'] != '') {
					$thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
				}
				if (file_exists($thumbnailFileUrl)) {
					unlink($thumbnailFileUrl);
				}
			}
		}
		$imageData = $this->banner_model->deleteDocumentImageRecord(array('document_type' => 'banner','document_type_id' => $bannerId));
		$bannerData = $this->banner_model->deleteRecord($bannerId);
        $transactionStatus = $this->db->transComplete();
        if (($bannerData) && ($transactionStatus == 1)) {
            $response['success'] = true;
            $response['msg'] = sprintf(lang('CommonMessage.delete_record'), lang("Banner.banner"));
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.error_delete_record'), lang("Banner.banner"));
        }
        echo json_encode($response);
        exit;
    }

    public function deleteBannerImage()
    {
        $this->db->transStart();
        $documentImageId = $this->request->getVar('document_image_id');
        $documentTypeId = $this->request->getVar('document_type_id');
        $documentType = $this->request->getVar('document_type');
        $imageData = $this->visitor_model->getDocumentImageData(array(
            "document_image_id" => $documentImageId,
            "is_multiple" => 1
        ));
        if(is_array($imageData) && !empty($imageData)){
            foreach ($imageData as $image){
                $FileUrl = '';
                if(isset($image['document_image']) && $image['document_image'] != '') {
                    $FileUrl = DOCUMENT_IMAGE_PATH . $image['document_image'];
                }
                if (file_exists($FileUrl)) {
                    unlink($FileUrl);
                } 

                $thumbnailFileUrl = '';
				if(isset($image['document_image']) && $image['document_image'] != '') {
					$thumbnailFileUrl = THUMBNAIL_DOCUMENT_IMAGE_PATH . $image['document_image'];
				}
				if (file_exists($thumbnailFileUrl)) {
					unlink($thumbnailFileUrl);
				}
            }
        }
        //delete setting location
        $imageData = $this->visitor_model->deleteDocumentImage($documentImageId,"banner");      
        if ($imageData) {
			$ids = is_array($documentImageId) ? implode(',',$documentImageId) : $documentImageId;
			$deleteDataArray['module'] = 'Banner Image';
			$deleteDataArray['activity'] = "Banner Image Deleted";
			$deleteDataArray['module_id'] = $documentImageId;
			logActivity('Banner Image Deleted [BannerImageID: ' . $ids . ']',$this->data['userId'],'Banner Image',$ids,json_encode($deleteDataArray),'','Banner',$documentTypeId);
            $transactionStatus = $this->db->transComplete();
            if($transactionStatus == 1){
                $response['success'] = true;
                $response['msg']     = sprintf(lang('CommonMessage.delete_record'),lang('Banner.banner_image'));
            }
            else{
                $response['success'] = false;
                $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Banner.banner_image'));
            }
        } else {
            $response['success'] = false;
            $response['msg'] = sprintf(lang('CommonMessage.delete_error'),lang('Banner.banner_image'));
        }
        echo json_encode($response);
        exit();
    }
}
