<?php

namespace Config;

use CodeIgniter\Config\Filters as BaseFilters;
use CodeIgniter\Filters\Cors;
use CodeIgniter\Filters\CSRF;
use CodeIgniter\Filters\DebugToolbar;
use CodeIgniter\Filters\ForceHTTPS;
use CodeIgniter\Filters\Honeypot;
use CodeIgniter\Filters\InvalidChars;
use CodeIgniter\Filters\PageCache;
use CodeIgniter\Filters\PerformanceMetrics;
use CodeIgniter\Filters\SecureHeaders;
use App\Filters\LoginFilter;
use App\Filters\AuthFilter;

class Filters extends BaseFilters
{
    /**
     * Configures aliases for Filter classes to
     * make reading things nicer and simpler.
     *
     * @var array<string, class-string|list<class-string>>
     *
     * [filter_name => classname]
     * or [filter_name => [classname1, classname2, ...]]
     */
    public array $aliases = [
        'csrf'          => CSRF::class,
        'toolbar'       => DebugToolbar::class,
        'honeypot'      => Honeypot::class,
        'invalidchars'  => InvalidChars::class,
        'secureheaders' => SecureHeaders::class,
        'cors'          => Cors::class,
        'forcehttps'    => ForceHTTPS::class,
        'pagecache'     => PageCache::class,
        'performance'   => PerformanceMetrics::class,
        'loginFilter'   => LoginFilter::class,
        'authFilter'    => AuthFilter::class,
    ];

    /**
     * List of special required filters.
     *
     * The filters listed here are special. They are applied before and after
     * other kinds of filters, and always applied even if a route does not exist.
     *
     * Filters set by default provide framework functionality. If removed,
     * those functions will no longer work.
     *
     * @see https://codeigniter.com/user_guide/incoming/filters.html#provided-filters
     *
     * @var array{before: list<string>, after: list<string>}
     */
    public array $required = [
        'before' => [
            'forcehttps', // Force Global Secure Requests
            'pagecache',  // Web Page Caching,
            //'group:admin,superadmin'  => ['before' => ['admin/*']],
            //'permission:users.manage' => ['before' => ['admin/users/*']],
        ],
        'after' => [
            'pagecache',   // Web Page Caching
            'performance', // Performance Metrics
            'toolbar',     // Debug Toolbar
        ],
    ];

    /**
     * List of filter aliases that are always
     * applied before and after every request.
     *
     * @var array<string, array<string, array<string, string>>>|array<string, list<string>>
     */
    public array $globals = [
        'before' => [
            // 'honeypot',
            // 'csrf',
            // 'invalidchars',
            'loginFilter' => ['except' => ['/Admin/Auth/login','/Admin/Auth/user_society','/Admin/Auth/forgot_password','/Admin/Auth/checkEmailExist','/Admin/Auth/reset_password/*','/Api/*','/SocietyApi.*','/ManagerApi.*','/SuperAdmin*']],
            'authFilter' => ['except' => ['/Admin/*','/SuperAdmin*','/Api/SocietyApi/*','/Api/SocietyApi/userLogin','/Api/SocietyApi/getAppLoadData','/Api/SocietyApi/getOwnershipFlatList','/Api/SocietyApi/getDashboardData','/Api/SocietyApi/getFaqTopicList','/Api/SocietyApi/getFaqMediaList','/Api/SocietyApi/deleteForum','/Api/SocietyApi/getCategoryList','/Api/SocietyApi/resourceEntered','/Api/SocietyApi/getDashboardList','/Api/SocietyApi/addEditCompany','/Api/SocietyApi/approveAmenitiesBooking','/Api/SocietyApi/getParkingList','/Api/SocietyApi/userSocietyLogin','/Api/SocietyApi/getUserSocietyList','/Api/SocietyApi/resendOtp','/Api/SocietyApi/checkPin','/Api/SocietyApi/getProfileList','/Api/SocietyApi/changePin','/Api/SocietyApi/editProfile','/Api/SocietyApi/submitOtp','/Api/SocietyApi/getUserSocietyFlatList','/Api/SocietyApi/UserSocietyFlatLogin','/Api/SocietyApi/checkVersion','/Api/SocietyApi/deviceInfo','/Api/SocietyApi/updateUserDeviceInfo','/Api/SocietyApi/cancelEvent'
                ,'/Api/ManagerApi/getGeneratorList','/Api/SocietyApi/addEditResource','/Api/SocietyApi/getResourceList','/Api/SocietyApi/getEventList','/Api/SocietyApi/getCommentList','/Api/SocietyApi/addEditComment','/Api/SocietyApi/getForumList','/Api/SocietyApi/deleteComplaint','/Api/SocietyApi/sendVisitorApprovalNotification','/Api/ManagerApi/getGeneratorReadingList','/Api/ManagerApi/getOrganicWasteRecordPdf','/Api/ManagerApi/addEditOrganicWasteRecord','/Api/ManagerApi/deleteOrganicWasteRecord','/Api/ManagerApi/getOrganicWasteRecordList','/Api/ManagerApi/getGeneratorList','/Api/ManagerApi/addEditGeneratorReading','/Api/ManagerApi/deleteGeneratorReading','/Api/ManagerApi/getStaffList','/Api/ManagerApi/getMenPowerAttendanceList','/Api/ManagerApi/addEditMenPowerAttendance','/Api/ManagerApi/deleteMenPowerAttendance','/Api/SocietyApi/getStatusList','/Api/SocietyApi/getEventList','/Api/SocietyApi/scanEventBooking','/Api/SocietyApi/getAmenitiesDetails','/Api/SocietyApi/getBookingList','/Api/SocietyApi/getServiceDirectoryList','/Api/SocietyApi/addEditBooking','/Api/SocietyApi/cancelBooking','/Api/SocietyApi/getComplaintTicketList','/Api/SocietyApi/addEditComplaintTicket','/Api/SocietyApi/getOwnershipFlatParkingList','/Api/SocietyApi/getServiceDirectoryList','/Api/SocietyApi/getVisitorList','/Api/SocietyApi/addEditEventBooking','/Api/SocietyApi/getEventDetailList','/Api/SocietyApi/getComplaintTicketList','/Api/SocietyApi/getNoticeList','/Api/SocietyApi/cancelEvent','/Api/SocietyApi/addEditMember','/Api/ManagerApi/getWaterMeterReadingList','/Api/ManagerApi/getGeneratorReadingList','/Api/ManagerApi/addEditWaterMeterReading','/Api/ManagerApi/getAddressList'

//             ',/Api/SocietyApi/addEditVisitor','/Api/SocietyApi/getTowerList','/Api/SocietyApi/getOwnershipFlatList','/Api/SocietyApi/getOwnershipFlatMemberList','/Api/SocietyApi/getOwnershipFlatParkingList','/Api/SocietyApi/getVisitorList','/Api/SocietyApi/getCompanyList','/Api/SocietyApi/getNoticeList','/Api/SocietyApi/bookmarkChange','/Api/SocietyApi/getPollList','/Api/SocietyApi/addEditPollVotes','/Api/SocietyApi/addEditBookmark',
//                 '/Api/SocietyApi/addEditFollow','/Api/SocietyApi/getForumList','/Api/SocietyApi/addEditForum','/Api/SocietyApi/deleteForum','/Api/SocietyApi/addEditLikes','/Api/SocietyApi/getCommentList','/Api/SocietyApi/deleteComment','/Api/SocietyApi/addEditComment','/Api/SocietyApi/addEditCompany','/Api/SocietyApi/getEmergencyList','/Api/SocietyApi/getAmenitiesList','/Api/SocietyApi/getNotificationList','/Api/SocietyApi/getBookingList','/Api/SocietyApi/getResourceVisitorList',
//                 '/Api/SocietyApi/addEditBooking','/Api/SocietyApi/getServiceDirectoryList','/Api/SocietyApi/getSocietyCommiteeList','/Api/SocietyApi/addEditResource','/Api/SocietyApi/getResourceList','/Api/SocietyApi/getCategoryList','/Api/SocietyApi/getGuardDirectoryList','/Api/SocietyApi/getDocumentFolderList','/Api/SocietyApi/getResourceDetailList','/Api/SocietyApi/deleteResource','/Api/SocietyApi/getResourceCountList','/Api/SocietyApi/getSosList','/Api/SocietyApi/deleteVisitor','/Api/SocietyApi/getStaticDropdownList','/Api/SocietyApi/addEditSosEmergency','/Api/SocietyApi/resourceEntered','/Api/SocietyApi/getBannerList','/Api/SocietyApi/SosEmergencyResolved',
//                 '/Api/SocietyApi/getEditResourceList','/Api/SocietyApi/getDashboardList','/Api/SocietyApi/addEditComplaintTicket','/Api/SocietyApi/getComplaintTicketList','/Api/SocietyApi/deleteComplaintTicketRecording','/Api/SocietyApi/getSettingList','/Api/SocietyApi/getFaqList','/Api/SocietyApi/getFaqMediaList','/Api/SocietyApi/getFaqTopicList','/Api/SocietyApi/getResourceGateKeeperList','/Api/SocietyApi/createQRCode','/Api/SocietyApi/getParkingList','/Api/SocietyApi/resourceExited','/Api/SocietyApi/visitorStatusChange',
//                 '/Api/SocietyApi/scanQRCode','/Api/SocietyApi/sendNotification','/Api/SocietyApi/getNotificationTypeList','/Api/SocietyApi/notificationStore','/Api/SocietyApi/addEditVehicle','/Api/SocietyApi/getVehicleList','/Api/SocietyApi/editCustomerProfile','/Api/SocietyApi/addEditMember','/Api/SocietyApi/getMemberList','/Api/SocietyApi/getSosEmergencyList','/Api/SocietyApi/getAmenitiesList','/Api/SocietyApi/getAmenitiesDetails','/Api/SocietyApi/addEditBooking','/Api/SocietyApi/cancelBooking','/Api/SocietyApi/deleteForumImage','/Api/SocietyApi/sendVisitorApprovalNotification','/Api/SocietyApi/sendBulk','/Api/SocietyApi/acceptRejectNotification','/Api/SocietyApi/getSosEmergencyNotificationList','/Api/SocietyApi/deleteMember','/Api/SocietyApi/deleteVehicle'
            ]],
//            'authFilter' => ['except' => ['/Admin/*','/Api/SocietyApi/userLogin','/Api/SocietyApi/userSocietyLogin','/Api/SocietyApi/getUserSocietyList','/Api/SocietyApi/addEditVisitor','/Api/SocietyApi/submitOtp','/Api/SocietyApi/getTowerList','/Api/SocietyApi/getOwnershipFlatList','/Api/SocietyApi/getOwnershipFlatMemberList','/Api/SocietyApi/getOwnershipFlatParkingList','/Api/SocietyApi/getVisitorList','/Api/SocietyApi/getCompanyList','/Api/SocietyApi/getNoticeList','/Api/SocietyApi/bookmarkChange','/Api/SocietyApi/getPollList','/Api/SocietyApi/addEditPollVotes','/Api/SocietyApi/addEditBookmark',
//                '/Api/SocietyApi/addEditFollow','/Api/SocietyApi/deleteForum','/Api/SocietyApi/addEditLikes','/Api/SocietyApi/getCommentList','/Api/SocietyApi/deleteComment','/Api/SocietyApi/addEditComment','/Api/SocietyApi/addEditCompany','/Api/SocietyApi/getEmergencyList','/Api/SocietyApi/getAmenitiesList','/Api/SocietyApi/getNotificationList','/Api/SocietyApi/getBookingList','/Api/SocietyApi/getResourceVisitorList',
//                '/Api/SocietyApi/addEditBooking','/Api/SocietyApi/getServiceDirectoryList','/Api/SocietyApi/getSocietyCommiteeList','/Api/SocietyApi/addEditResource','/Api/SocietyApi/getResourceList','/Api/SocietyApi/getCategoryList','/Api/SocietyApi/getGuardDirectoryList','/Api/SocietyApi/getDocumentFolderList','/Api/SocietyApi/getResourceDetailList','/Api/SocietyApi/deleteResource','/Api/SocietyApi/getResourceCountList','/Api/SocietyApi/getSosList','/Api/SocietyApi/deleteVisitor','/Api/SocietyApi/getStaticDropdownList','/Api/SocietyApi/addEditSosEmergency','/Api/SocietyApi/resourceEntered','/Api/SocietyApi/getBannerList','/Api/SocietyApi/SosEmergencyResolved',
//                '/Api/SocietyApi/getEditResourceList','/Api/SocietyApi/getDashboardList','/Api/SocietyApi/addEditComplaintTicket','/Api/SocietyApi/getComplaintTicketList','/Api/SocietyApi/deleteComplaintTicketRecording','/Api/SocietyApi/getSettingList','/Api/SocietyApi/getFaqList','/Api/SocietyApi/getFaqMediaList','/Api/SocietyApi/getFaqTopicList','/Api/SocietyApi/getResourceGateKeeperList','/Api/SocietyApi/createQRCode','/Api/SocietyApi/getParkingList','/Api/SocietyApi/resendOtp','/Api/SocietyApi/checkPin','/Api/SocietyApi/getProfileList','/Api/SocietyApi/changePin','/Api/SocietyApi/editProfile','/Api/SocietyApi/resourceExited','/Api/SocietyApi/visitorStatusChange',
//                '/Api/SocietyApi/getUserSocietyFlatList','/Api/SocietyApi/UserSocietyFlatLogin'
//            ]],
            ],
        'after' => [
            // 'honeypot',
            // 'secureheaders',
        ],
    ];

    /**
     * List of filter aliases that works on a
     * particular HTTP method (GET, POST, etc.).
     *
     * Example:
     * 'POST' => ['foo', 'bar']
     *
     * If you use this, you should disable auto-routing because auto-routing
     * permits any HTTP method to access a controller. Accessing the controller
     * with a method you don't expect could bypass the filter.
     *
     * @var array<string, list<string>>
     */
    public array $methods = [];

    /**
     * List of filter aliases that should run on any
     * before or after URI patterns.
     *
     * Example:
     * 'isLoggedIn' => ['before' => ['account/*', 'profiles/*']]
     *
     * @var array<string, array<string, list<string>>>
     */
    public array $filters = [
        //'isLoggedIn' => 'before' => ['account/*', 'profiles/*']
    ];
}
